/*
 * Decompiled with CFR 0.152.
 */
package two.newdawn.commands;

import java.util.LinkedList;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S26PacketMapChunkBulk;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import two.newdawn.util.SpiralPatternGenerator;

public class CommandGenerateWorld
extends CommandBase {
    public String func_71517_b() {
        return "generateWorld";
    }

    public int func_82362_a() {
        return 3;
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "[OP-only] /generateWorld <chunkRadius|0-100> - generates <chunkRadius> blocks";
    }

    public void func_71515_b(ICommandSender icommandsender, String[] params) {
        EntityPlayerMP player = CommandGenerateWorld.func_71521_c((ICommandSender)icommandsender);
        if (params.length != 1) {
            throw new SyntaxErrorException();
        }
        int rangeMax = CommandGenerateWorld.func_71526_a((ICommandSender)icommandsender, (String)params[0]);
        if (rangeMax < 0 || rangeMax > 100) {
            throw new SyntaxErrorException();
        }
        int chunksMax = (int)Math.pow(rangeMax * 2 + 1, 2.0) - 1;
        World world = player.func_130014_f_();
        SpiralPatternGenerator spiralPattern = new SpiralPatternGenerator(new ChunkCoordIntPair(player.field_70176_ah, player.field_70164_aj), rangeMax);
        int count = 0;
        player.func_145747_a((IChatComponent)new ChatComponentText("Generating " + chunksMax + " chunks..."));
        LinkedList<Chunk> chunks = new LinkedList<Chunk>();
        for (ChunkCoordIntPair coord : spiralPattern) {
            chunks.add(world.func_72964_e(coord.field_77276_a, coord.field_77275_b));
            if (++count % 50 != 0) continue;
            player.func_145747_a((IChatComponent)new ChatComponentText(count + " chunks generated..."));
            player.field_71135_a.func_147359_a((Packet)new S26PacketMapChunkBulk(chunks));
            chunks.clear();
        }
        player.func_145747_a((IChatComponent)new ChatComponentText(count + " chunks have been generated."));
    }
}

