/*
 * Decompiled with CFR 0.152.
 */
package two.newdawn.worldgen;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import two.newdawn.API.ChunkInformation;
import two.newdawn.API.NewDawnBiome;
import two.newdawn.API.NewDawnBiomeSelector;
import two.newdawn.API.NewDawnRegistry;
import two.newdawn.API.WorldBaseValues;
import two.newdawn.API.noise.NoiseStretch;
import two.newdawn.API.noise.SimplexNoise;
import two.newdawn.worldgen.NewDawnChunk;

public class NewDawnTerrainGenerator
implements IChunkProvider {
    protected static final boolean SHOW_MAP_FEATURES = true;
    protected static final boolean SHOW_MAP_STUCTURES = false;
    protected static final boolean SHOW_MAP_DECORATION = true;
    private final World worldObj;
    private final boolean mapFeaturesEnabled;
    private final MapGenBase caveGenerator;
    private final MapGenStronghold strongholdGenerator;
    private final MapGenVillage villageGenerator;
    private final MapGenMineshaft mineshaftGenerator;
    private final MapGenScatteredFeature scatteredFeatureGenerator;
    private final MapGenBase ravineGenerator;
    protected final Random seedRandom;
    protected final SimplexNoise worldNoise;
    protected final NoiseStretch terrainRoughness;
    protected final NoiseStretch heightBlock;
    protected final NoiseStretch heightAreaSmall;
    protected final NoiseStretch heightAreaLarge;
    protected final NoiseStretch heightRegionNoise;
    protected final NoiseStretch fillerNoise;
    protected final NoiseStretch temperatureChunkNoise;
    protected final NoiseStretch temperatureAreaNoise;
    protected final NoiseStretch temperatureRegionNoise;
    protected final NoiseStretch humidityLocalNoise;
    protected final NoiseStretch humidityAreaNoise;
    protected final NoiseStretch humidityRegionNoise;
    protected final NoiseStretch stretchForestSmallNoise;
    protected final WorldBaseValues baseValues;
    protected final List<NewDawnBiomeSelector> biomeSelectors;
    protected final List<NewDawnBiomeSelector> terrainModifiers;

    public NewDawnTerrainGenerator(World world, long worldSeed, boolean useMapFeatures) {
        this.baseValues = new WorldBaseValues(-0.5f, 0.5f, -0.5f, 0.6f, 0.18f, world.field_73011_w.func_76557_i());
        this.seedRandom = new Random(worldSeed);
        this.worldNoise = new SimplexNoise(this.seedRandom);
        this.terrainRoughness = this.worldNoise.generateNoiseStretcher(1524.0, 1798.0, this.seedRandom.nextDouble(), this.seedRandom.nextDouble());
        this.heightBlock = this.worldNoise.generateNoiseStretcher(23.0, 27.0, this.seedRandom.nextDouble(), this.seedRandom.nextDouble());
        this.heightAreaSmall = this.worldNoise.generateNoiseStretcher(413.0, 467.0, this.seedRandom.nextDouble(), this.seedRandom.nextDouble());
        this.heightAreaLarge = this.worldNoise.generateNoiseStretcher(913.0, 967.0, this.seedRandom.nextDouble(), this.seedRandom.nextDouble());
        this.heightRegionNoise = this.worldNoise.generateNoiseStretcher(1920.0, 1811.0, this.seedRandom.nextDouble(), this.seedRandom.nextDouble());
        this.fillerNoise = this.worldNoise.generateNoiseStretcher(16.0, 16.0, this.seedRandom.nextDouble(), this.seedRandom.nextDouble());
        this.temperatureChunkNoise = this.worldNoise.generateNoiseStretcher(2.1, 2.2, this.seedRandom.nextDouble(), this.seedRandom.nextDouble());
        this.temperatureAreaNoise = this.worldNoise.generateNoiseStretcher(260.0, 273.0, this.seedRandom.nextDouble(), this.seedRandom.nextDouble());
        this.temperatureRegionNoise = this.worldNoise.generateNoiseStretcher(2420.0, 2590.0, this.seedRandom.nextDouble(), this.seedRandom.nextDouble());
        this.humidityLocalNoise = this.worldNoise.generateNoiseStretcher(6.0, 7.0, this.seedRandom.nextDouble(), this.seedRandom.nextDouble());
        this.humidityAreaNoise = this.worldNoise.generateNoiseStretcher(320.0, 273.0, this.seedRandom.nextDouble(), this.seedRandom.nextDouble());
        this.humidityRegionNoise = this.worldNoise.generateNoiseStretcher(1080.0, 919.0, this.seedRandom.nextDouble(), this.seedRandom.nextDouble());
        this.stretchForestSmallNoise = this.worldNoise.generateNoiseStretcher(93.0, 116.0, this.seedRandom.nextDouble(), this.seedRandom.nextDouble());
        this.biomeSelectors = NewDawnRegistry.getSelectors(this.worldNoise);
        this.terrainModifiers = new ArrayList<NewDawnBiomeSelector>();
        if (this.biomeSelectors.isEmpty()) {
            throw new IllegalStateException("No biome registered for NewDawn world type!");
        }
        for (NewDawnBiomeSelector selector : this.biomeSelectors) {
            if (selector.modifiesTerrain()) {
                this.terrainModifiers.add(selector);
            }
            FMLLog.info((String)"Using NewDawn biome: %s %s", (Object[])new Object[]{selector.getClass().getSimpleName(), selector.modifiesTerrain() ? "(modifies terrain)" : ""});
        }
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)new MapGenCaves(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.strongholdGenerator = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)new MapGenStronghold(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)new MapGenVillage(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.mineshaftGenerator = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)new MapGenMineshaft(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        this.scatteredFeatureGenerator = (MapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)new MapGenScatteredFeature(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
        this.ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)new MapGenRavine(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
        this.worldObj = world;
        this.mapFeaturesEnabled = useMapFeatures;
    }

    public Chunk func_73154_d(int chunkX, int chunkZ) {
        ChunkInformation chunkInfo = this.generateChunkInformation(chunkX, chunkZ);
        Block[] chunkData = new Block[65536];
        BiomeGenBase[] generatedBiomes = new BiomeGenBase[256];
        this.generateNewDawnTerrain(chunkInfo, chunkData, generatedBiomes);
        this.generateCavesAndRavines(chunkX, chunkZ, chunkData);
        NewDawnChunk chunk = new NewDawnChunk(this.worldObj, chunkData, chunkX, chunkZ);
        byte[] chunkBiomes = chunk.func_76605_m();
        int i = -1;
        for (BiomeGenBase biome : generatedBiomes) {
            chunkBiomes[++i] = (byte)(biome.field_76756_M & 0xFF);
        }
        chunk.func_76616_a(chunkBiomes);
        chunk.func_76603_b();
        return chunk;
    }

    protected ChunkInformation generateChunkInformation(int chunkX, int chunkZ) {
        int[] heightMap = new int[256];
        int[] regionHeightMap = new int[256];
        boolean[] isMountain = new boolean[256];
        float[] temperatureMap = new float[256];
        float[] humidityMap = new float[256];
        ChunkInformation result = new ChunkInformation(chunkX, chunkZ, this.baseValues, heightMap, regionHeightMap, isMountain, temperatureMap, humidityMap);
        int x0 = chunkX << 4;
        int z0 = chunkZ << 4;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int blockX = x0 + x;
                int blockZ = z0 + z;
                int dataPos = x + z * 16;
                double roughness = this.terrainRoughness.getNoise(blockX, blockZ) + 1.0;
                double localBlockHeight = this.heightBlock.getNoise(blockX, blockZ) * roughness * 0.5 * 2.0;
                double areaSmallHeight = this.heightAreaSmall.getNoise(blockX, blockZ) * roughness * 6.0 * 2.0;
                double areaLargeHeight = this.heightAreaLarge.getNoise(blockX, blockZ) * roughness * 10.0 * 2.0;
                double regionHeight = (this.heightRegionNoise.getNoise(blockX, blockZ) + 0.25) * 8.0 / 1.25 * 2.0;
                double baseHeight = (double)this.baseValues.groundLevel + regionHeight + areaLargeHeight + areaSmallHeight + localBlockHeight;
                double heightMod = 0.0;
                boolean isModified = false;
                for (NewDawnBiomeSelector selector : this.terrainModifiers) {
                    if (!selector.modifiesLocation(blockX, blockZ, result)) continue;
                    heightMod += selector.modifyHeight(blockX, blockZ, baseHeight, regionHeight, roughness, heightMod, isModified, result);
                    isModified = true;
                }
                int height = Math.max(1, Math.min(255, (int)Math.round(baseHeight + heightMod)));
                double heightShifted = (double)(height + this.baseValues.groundLevel) - 128.0;
                double worldHeightMod = heightShifted < 0.0 ? 0.0 : -Math.pow(heightShifted / 256.0, 3.0) * Math.pow(heightShifted * 0.4, 1.001);
                double temperature = this.temperatureRegionNoise.getNoise(blockX, blockZ) * 0.8 + this.temperatureAreaNoise.getNoise(blockX, blockZ) * 0.15 + this.temperatureChunkNoise.getNoise(blockX, blockZ) * 0.05 + worldHeightMod;
                double humidity = this.humidityRegionNoise.getNoise(blockX, blockZ) * 0.4 + this.humidityAreaNoise.getNoise(blockX, blockZ) * 0.55 + this.humidityLocalNoise.getNoise(blockX, blockZ) * 0.05 + (this.stretchForestSmallNoise.getNoise(blockX, blockZ) > (temperature >= (double)this.baseValues.temperatureHot ? 0.85 : 0.6) ? 0.5 : 0.0) + worldHeightMod;
                heightMap[dataPos] = height;
                regionHeightMap[dataPos] = (int)Math.round(regionHeight);
                temperatureMap[dataPos] = (float)temperature;
                humidityMap[dataPos] = (float)humidity;
            }
        }
        result.updateMinMaxInformation();
        return result;
    }

    protected void generateNewDawnTerrain(ChunkInformation chunkInfo, Block[] chunkData, BiomeGenBase[] chunkBiomes) {
        int x0 = chunkInfo.chunkX * 16;
        int z0 = chunkInfo.chunkZ * 16;
        int dataPos = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int blockX = x0 + x;
                int blockZ = z0 + z;
                NewDawnBiome blockBiome = this.getBiomeFor(blockX, blockZ, chunkInfo);
                chunkBiomes[x + z * 16] = blockBiome.vanillaBiome;
                int height = chunkInfo.getHeight(blockX, blockZ);
                int heightFiller = height - 1 - (int)Math.round((this.fillerNoise.getNoise(blockX, blockZ) + 1.0) * 1.5 * 2.0);
                blockBiome.fillLocation(this.worldNoise, chunkData, dataPos, height, heightFiller, blockX, blockZ, chunkInfo);
                dataPos += 256;
            }
        }
    }

    protected NewDawnBiome getBiomeFor(int blockX, int blockY, ChunkInformation chunkInfo) {
        for (NewDawnBiomeSelector selector : this.biomeSelectors) {
            NewDawnBiome result = selector.selectBiome(blockX, blockY, chunkInfo);
            if (result == null) continue;
            return result;
        }
        throw new IllegalStateException("No biome was selected during world-gen for (" + blockX + ", " + blockY + ")!");
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    protected void generateCavesAndRavines(int chunkX, int chunkZ, Block[] chunkData) {
        if (this.mapFeaturesEnabled) {
            this.caveGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, chunkData);
            this.ravineGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, chunkData);
        }
    }

    public void func_73153_a(IChunkProvider chunkProvider, int chunkX, int chunkZ) {
        BlockSand.field_149832_M = true;
        int blockX = chunkX * 16;
        int blockZ = chunkZ * 16;
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(blockX + 16, blockZ + 16);
        this.seedRandom.setSeed(this.worldObj.func_72905_C());
        long seedModX = this.seedRandom.nextLong() / 2L * 2L + 1L;
        long seedModY = this.seedRandom.nextLong() / 2L * 2L + 1L;
        this.seedRandom.setSeed((long)chunkX * seedModX + (long)chunkZ * seedModY ^ this.worldObj.func_72905_C());
        boolean hasVillage = false;
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(chunkProvider, this.worldObj, this.seedRandom, chunkX, chunkZ, hasVillage));
        if (this.mapFeaturesEnabled) {
            int z;
            int y;
            int x;
            this.mineshaftGenerator.func_75051_a(this.worldObj, this.seedRandom, chunkX, chunkZ);
            hasVillage = this.villageGenerator.func_75051_a(this.worldObj, this.seedRandom, chunkX, chunkZ);
            this.strongholdGenerator.func_75051_a(this.worldObj, this.seedRandom, chunkX, chunkZ);
            this.scatteredFeatureGenerator.func_75051_a(this.worldObj, this.seedRandom, chunkX, chunkZ);
            if (biomegenbase != BiomeGenBase.field_76769_d && biomegenbase != BiomeGenBase.field_76786_s && !hasVillage && this.seedRandom.nextInt(10) == 0 && TerrainGen.populate((IChunkProvider)chunkProvider, (World)this.worldObj, (Random)this.seedRandom, (int)chunkX, (int)chunkZ, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
                x = blockX + this.seedRandom.nextInt(16) + 8;
                y = this.seedRandom.nextInt(256);
                z = blockZ + this.seedRandom.nextInt(16) + 8;
                new WorldGenLakes(Blocks.field_150355_j).func_76484_a(this.worldObj, this.seedRandom, x, y, z);
            }
            if (TerrainGen.populate((IChunkProvider)chunkProvider, (World)this.worldObj, (Random)this.seedRandom, (int)chunkX, (int)chunkZ, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA) && !hasVillage && this.seedRandom.nextInt(16) == 0) {
                x = blockX + this.seedRandom.nextInt(16) + 8;
                y = this.seedRandom.nextInt(this.seedRandom.nextInt(248) + 8);
                z = blockZ + this.seedRandom.nextInt(16) + 8;
                if (y < this.baseValues.groundLevel || this.seedRandom.nextInt(10) == 0) {
                    new WorldGenLakes(Blocks.field_150353_l).func_76484_a(this.worldObj, this.seedRandom, x, y, z);
                }
            }
            if (TerrainGen.populate((IChunkProvider)chunkProvider, (World)this.worldObj, (Random)this.seedRandom, (int)chunkX, (int)chunkZ, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON)) {
                for (int tries = 0; tries < 8; ++tries) {
                    x = blockX + this.seedRandom.nextInt(16) + 8;
                    y = this.seedRandom.nextInt(256);
                    z = blockZ + this.seedRandom.nextInt(16) + 8;
                    new WorldGenDungeons().func_76484_a(this.worldObj, this.seedRandom, x, y, z);
                }
            }
            biomegenbase.func_76728_a(this.worldObj, this.seedRandom, blockX, blockZ);
            SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)biomegenbase, (int)(blockX + 8), (int)(blockZ + 8), (int)16, (int)16, (Random)this.seedRandom);
            if (TerrainGen.populate((IChunkProvider)chunkProvider, (World)this.worldObj, (Random)this.seedRandom, (int)chunkX, (int)chunkZ, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE)) {
                this.applyIceAndSnow(chunkX, chunkZ);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(chunkProvider, this.worldObj, this.seedRandom, chunkX, chunkZ, hasVillage));
        BlockSand.field_149832_M = false;
    }

    protected void applyIceAndSnow(int chunkX, int chunkZ) {
        Chunk chunk = this.worldObj.func_72964_e(chunkX, chunkZ);
        int x0 = chunkX * 16;
        int z0 = chunkZ * 16;
        byte[] chunkBiomes = chunk.func_76605_m();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int biomeID = chunkBiomes[x + z * 16] & 0xFF;
                BiomeGenBase blockBiome = BiomeGenBase.func_150568_d((int)biomeID);
                if (!blockBiome.func_76746_c()) continue;
                int height = chunk.func_76611_b(x, z);
                Block block = chunk.func_150810_a(x, height, z);
                while (block == Blocks.field_150350_a) {
                    if (--height <= 0) {
                        throw new IllegalStateException("Chunk (x" + chunk.field_76635_g + " z" + chunk.field_76647_h + ") at x" + x0 + " z" + z0 + " contains no blocks.");
                    }
                    block = chunk.func_150810_a(x, height, z);
                }
                if (block == Blocks.field_150355_j) {
                    this.worldObj.func_147465_d(x0 + x, height, z0 + z, Blocks.field_150432_aD, 0, 2);
                    continue;
                }
                if (!this.canBlockCarrySnow(block)) continue;
                this.worldObj.func_147465_d(x0 + x, height + 1, z0 + z, Blocks.field_150431_aC, 0, 2);
            }
        }
    }

    protected boolean canBlockCarrySnow(Block block) {
        if (block == Blocks.field_150432_aD || block == Blocks.field_150403_cj) {
            return false;
        }
        Material material = block.func_149688_o();
        return material.func_76230_c();
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(par2, par4);
        return par1EnumCreatureType == EnumCreatureType.monster && this.scatteredFeatureGenerator.func_143030_a(par2, par3, par4) ? this.scatteredFeatureGenerator.func_82667_a() : biomegenbase.func_76747_a(par1EnumCreatureType);
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int chunkX, int chunkZ) {
        if (this.mapFeaturesEnabled) {
            this.mineshaftGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, (Block[])null);
            this.villageGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, (Block[])null);
            this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, (Block[])null);
            this.scatteredFeatureGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, (Block[])null);
        }
    }

    public boolean func_73156_b() {
        return false;
    }

    public void func_104112_b() {
    }

    public ChunkPosition func_147416_a(World world, String type, int x, int y, int z) {
        return "Stronghold".equals(type) && this.strongholdGenerator != null ? this.strongholdGenerator.func_151545_a(world, x, y, z) : null;
    }

    public Chunk func_73158_c(int par1, int par2) {
        return this.func_73154_d(par1, par2);
    }
}

