/*
 * Decompiled with CFR 0.152.
 */
package two.newdawn.worldgen.thaumcraft;

import java.util.Random;
import two.newdawn.API.ChunkInformation;
import two.newdawn.API.NewDawnBiome;
import two.newdawn.API.NewDawnBiomeSelector;
import two.newdawn.API.noise.NoiseStretch;
import two.newdawn.API.noise.SimplexNoise;
import two.newdawn.worldgen.thaumcraft.ThaumcraftConfiguration;

public class ThaumcraftBiomeSelector
extends NewDawnBiomeSelector {
    protected final ThaumcraftConfiguration thaumcraftConfiguration;
    protected final NewDawnBiome biomeTainted;
    protected final NewDawnBiome biomeEvil;
    protected final NewDawnBiome biomeGood;
    protected final NoiseStretch goodEvilNoise;
    protected final NoiseStretch areaNoise;
    protected final NoiseStretch blockNoise;

    public ThaumcraftBiomeSelector(SimplexNoise worldNoise, int priority, ThaumcraftConfiguration thaumcraftConfiguration, NewDawnBiome biomeTainted, NewDawnBiome biomeEvil, NewDawnBiome biomeGood) {
        super(worldNoise, priority);
        this.thaumcraftConfiguration = thaumcraftConfiguration;
        this.biomeTainted = biomeTainted;
        this.biomeEvil = biomeEvil;
        this.biomeGood = biomeGood;
        Random random = worldNoise.getRandom();
        this.goodEvilNoise = new NoiseStretch(worldNoise, 1130.0, 990.0, random.nextDouble(), random.nextDouble());
        this.areaNoise = new NoiseStretch(worldNoise, 62.3, 71.6, random.nextDouble(), random.nextDouble());
        this.blockNoise = new NoiseStretch(worldNoise, 8.2, 7.9, random.nextDouble(), random.nextDouble());
    }

    @Override
    public NewDawnBiome selectBiome(int blockX, int blockZ, ChunkInformation chunkInfo) {
        if (chunkInfo.isAboveSeaLevel(blockX, blockZ) || chunkInfo.isShallowWater(blockX, blockZ)) {
            double goodEvil = this.goodEvilNoise.getNoise(blockX, blockZ);
            if (goodEvil >= this.thaumcraftConfiguration.thresholdGood) {
                return this.biomeGood;
            }
            double modifiedGoodEvil = goodEvil * 0.95 + this.areaNoise.getNoise(blockX, blockZ) * 0.025 + this.blockNoise.getNoise(blockX, blockZ) * 0.025;
            if (modifiedGoodEvil <= this.thaumcraftConfiguration.thresholdTaint) {
                return this.biomeTainted;
            }
            if (modifiedGoodEvil <= this.thaumcraftConfiguration.thresholdEvil) {
                return this.biomeEvil;
            }
        }
        return null;
    }
}

