/*
 * Decompiled with CFR 0.152.
 */
package two.newdawn.worldgen.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import two.newdawn.API.ChunkInformation;
import two.newdawn.API.NewDawnBiome;
import two.newdawn.API.NewDawnBiomeSelector;
import two.newdawn.API.noise.NoiseStretch;
import two.newdawn.API.noise.SimplexNoise;

public class VanillaMountainSelector
extends NewDawnBiomeSelector {
    protected final NoiseStretch hillsNoise;
    protected final NoiseStretch hillsNoiseBlock;
    protected final NoiseStretch hillsNoiseAreaSmall;
    protected final NoiseStretch hillsNoiseAreaLarge;
    protected final NewDawnBiome[][] selection = new NewDawnBiome[ChunkInformation.Temperature.values().length][ChunkInformation.Humidity.values().length];

    public VanillaMountainSelector(SimplexNoise worldNoise, int priority) {
        super(worldNoise, priority);
        Random random = worldNoise.getRandom();
        this.hillsNoise = worldNoise.generateNoiseStretcher(897.0, 957.0, random.nextDouble(), random.nextDouble());
        this.hillsNoiseBlock = worldNoise.generateNoiseStretcher(2.0, 2.2, random.nextDouble(), random.nextDouble());
        this.hillsNoiseAreaSmall = worldNoise.generateNoiseStretcher(41.0, 45.0, random.nextDouble(), random.nextDouble());
        this.hillsNoiseAreaLarge = worldNoise.generateNoiseStretcher(127.0, 119.0, random.nextDouble(), random.nextDouble());
        this.selection[ChunkInformation.Temperature.cold.ordinal()][ChunkInformation.Humidity.sparse.ordinal()] = new NewDawnBiome(BiomeGenBase.field_76775_o, Blocks.field_150348_b, Blocks.field_150348_b);
        this.selection[ChunkInformation.Temperature.medium.ordinal()][ChunkInformation.Humidity.sparse.ordinal()] = new NewDawnBiome(BiomeGenBase.field_76770_e, Blocks.field_150348_b, Blocks.field_150348_b);
        this.selection[ChunkInformation.Temperature.hot.ordinal()][ChunkInformation.Humidity.sparse.ordinal()] = NewDawnBiome.copyVanilla(BiomeGenBase.field_76786_s);
        this.selection[ChunkInformation.Temperature.cold.ordinal()][ChunkInformation.Humidity.medium.ordinal()] = NewDawnBiome.copyVanilla(BiomeGenBase.field_76775_o);
        this.selection[ChunkInformation.Temperature.medium.ordinal()][ChunkInformation.Humidity.medium.ordinal()] = NewDawnBiome.copyVanilla(BiomeGenBase.field_76770_e);
        this.selection[ChunkInformation.Temperature.hot.ordinal()][ChunkInformation.Humidity.medium.ordinal()] = NewDawnBiome.copyVanilla(BiomeGenBase.field_150587_Y);
        this.selection[ChunkInformation.Temperature.cold.ordinal()][ChunkInformation.Humidity.woodland.ordinal()] = NewDawnBiome.copyVanilla(BiomeGenBase.field_150579_T);
        this.selection[ChunkInformation.Temperature.medium.ordinal()][ChunkInformation.Humidity.woodland.ordinal()] = NewDawnBiome.copyVanilla(BiomeGenBase.field_76785_t);
        this.selection[ChunkInformation.Temperature.hot.ordinal()][ChunkInformation.Humidity.woodland.ordinal()] = new NewDawnBiome(BiomeGenBase.field_150608_ab, (Block)Blocks.field_150349_c, Blocks.field_150405_ch);
        this.selection[ChunkInformation.Temperature.cold.ordinal()][ChunkInformation.Humidity.wet.ordinal()] = this.selection[ChunkInformation.Temperature.cold.ordinal()][ChunkInformation.Humidity.woodland.ordinal()];
        this.selection[ChunkInformation.Temperature.medium.ordinal()][ChunkInformation.Humidity.wet.ordinal()] = this.selection[ChunkInformation.Temperature.medium.ordinal()][ChunkInformation.Humidity.woodland.ordinal()];
        this.selection[ChunkInformation.Temperature.hot.ordinal()][ChunkInformation.Humidity.wet.ordinal()] = new NewDawnBiome(BiomeGenBase.field_150607_aa, Blocks.field_150405_ch, Blocks.field_150405_ch);
    }

    @Override
    public boolean modifiesTerrain() {
        return true;
    }

    @Override
    public boolean modifiesLocation(int blockX, int blockZ, ChunkInformation chunkInfo) {
        return this.getEffectiveHillsNoise(blockX, blockZ) > 0.0;
    }

    @Override
    public double modifyHeight(int blockX, int blockZ, double baseHeight, double regionHeight, double roughness, double currentModification, boolean isModified, ChunkInformation chunkInfo) {
        double hillsNoiseEffective = this.getEffectiveHillsNoise(blockX, blockZ);
        double hillsHeight = (this.hillsNoiseAreaLarge.getNoise(blockX, blockZ) * 0.4 + this.hillsNoiseAreaSmall.getNoise(blockX, blockZ) * 0.59 + this.hillsNoiseBlock.getNoise(blockX, blockZ) * 0.01 + 0.5) * hillsNoiseEffective * 32.0 * 2.0;
        chunkInfo.isMountain[ChunkInformation.blockToChunk((int)blockX, (int)blockZ)] = hillsHeight > 4.0;
        return hillsHeight;
    }

    protected double getEffectiveHillsNoise(int blockX, int blockZ) {
        double hillsNoiseEffective = this.hillsNoise.getNoise(blockX, blockZ);
        if (hillsNoiseEffective >= 0.0 && (hillsNoiseEffective = -(Math.cos(Math.PI * Math.pow(hillsNoiseEffective, 4.0)) - 1.0) / 2.0) >= 0.01) {
            return hillsNoiseEffective;
        }
        return 0.0;
    }

    @Override
    public NewDawnBiome selectBiome(int blockX, int blockZ, ChunkInformation chunkInfo) {
        if (chunkInfo.isMountain(blockX, blockZ) && chunkInfo.isAboveSeaLevel(blockX, blockZ)) {
            int temperature = chunkInfo.getTemperatureType(blockX, blockZ).ordinal();
            int humidity = chunkInfo.getHumidityType(blockX, blockZ).ordinal();
            return this.selection[temperature][humidity];
        }
        return null;
    }
}

