/*
 * Decompiled with CFR 0.152.
 */
package com.hea3ven.twintails.conf;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class TwinTailsConfig {
    public Boolean twinTailsEffects = true;
    public Boolean versionCheck = true;
    public String versionLatest = null;
    private Configuration configFile;
    private Property twintailsEffectsProp;
    private Property versionCheckProp;
    private Property versionLatestProp;

    public void init(File file) {
        this.configFile = new Configuration(file);
        this.twintailsEffectsProp = this.configFile.get("general", "TwinTailsEffects", false, "Enable to get effects while wearing certain twintails");
        this.versionCheckProp = this.configFile.get("general", "VersionCheck", true, "Enable to perform the version check");
        this.versionLatestProp = this.configFile.get("general", "VersionLatest", "", "The last version found, do not edit this value");
        this.syncWithFile();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("twintails")) {
            this.syncWithFile();
        }
    }

    private void syncWithFile() {
        this.twinTailsEffects = this.twintailsEffectsProp.getBoolean();
        this.versionCheck = this.versionCheckProp.getBoolean();
        this.versionLatest = this.versionLatestProp.getString();
        if (this.configFile.hasChanged()) {
            this.configFile.save();
        }
    }

    public List getConfigElements(String category) {
        ArrayList<ConfigElement> elems = new ArrayList<ConfigElement>();
        elems.add(new ConfigElement(this.twintailsEffectsProp));
        elems.add(new ConfigElement(this.versionCheckProp));
        return elems;
    }

    public String getPath() {
        return this.configFile.toString();
    }

    public void setLatestVersion(String version) {
        this.versionLatestProp.set(version);
        this.syncWithFile();
    }
}

