/*
 * Decompiled with CFR 0.152.
 */
package com.roripantsu.largesign.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class CustomGuiButton
extends GuiButton {
    protected Color color;
    protected ItemStack itemStack;
    private RenderItem renderItem = new RenderItem();
    private buttonStyle style;

    public CustomGuiButton(int ID, int X, int Y, int W, int H, buttonStyle style, Object obj) {
        super(ID, X, Y, W, H, "");
        this.style = style;
        if (style == buttonStyle.ITEMICON) {
            this.itemStack = (ItemStack)obj;
        }
        if (style == buttonStyle.COLORBLOCK) {
            this.color = (Color)obj;
        }
    }

    public void func_146112_a(Minecraft MC, int X, int Y) {
        if (this.field_146125_m) {
            if (this.style == buttonStyle.ITEMICON) {
                this.drawItemIconButton(MC, X, Y);
            }
            if (this.style == buttonStyle.COLORBLOCK) {
                this.drawColorBlockButton(MC, X, Y);
            }
        }
    }

    private void drawColorBlockButton(Minecraft MC, int X, int Y) {
        this.field_146123_n = X >= this.field_146128_h && Y >= this.field_146129_i && X < this.field_146128_h + this.field_146120_f && Y < this.field_146129_i + this.field_146121_g;
        int k = this.func_146114_a(this.field_146123_n);
        this.renderQuad(this.field_146128_h, this.field_146129_i, this.field_146128_h + this.field_146120_f, this.field_146129_i + this.field_146121_g, new Color(225, 225, 225, 32 * k));
        this.renderQuad(this.field_146128_h + 1, this.field_146129_i + 1, this.field_146128_h + this.field_146120_f - 1, this.field_146129_i + this.field_146121_g - 1, this.color);
    }

    private void drawItemIconButton(Minecraft MC, int X, int Y) {
        this.field_146123_n = X >= this.field_146128_h && Y >= this.field_146129_i && X < this.field_146128_h + this.field_146120_f && Y < this.field_146129_i + this.field_146121_g;
        int k = this.func_146114_a(this.field_146123_n);
        Color quadColor = new Color(225, 225, 225, 32 * k);
        this.renderQuad(this.field_146128_h, this.field_146129_i, this.field_146128_h + this.field_146120_f, this.field_146129_i + this.field_146121_g, quadColor);
        this.renderItemIcon(MC.field_71466_p, MC.func_110434_K(), this.itemStack, this.field_146128_h + (this.field_146120_f - 16) / 2, this.field_146129_i + (this.field_146121_g - 16) / 2);
    }

    private void renderItemIcon(FontRenderer fontRenderer, TextureManager textureManager, ItemStack itemStack, int X, int Y) {
        GL11.glEnable((int)32826);
        RenderHelper.func_74520_c();
        this.renderItem.func_82406_b(fontRenderer, textureManager, itemStack, X, Y);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
    }

    private void renderQuad(int X, int Y, int W, int H, Color color) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)((float)color.getRed() / 225.0f), (float)((float)color.getGreen() / 225.0f), (float)((float)color.getBlue() / 225.0f), (float)((float)color.getAlpha() / 225.0f));
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)X, (double)H, 0.0);
        tessellator.func_78377_a((double)W, (double)H, 0.0);
        tessellator.func_78377_a((double)W, (double)Y, 0.0);
        tessellator.func_78377_a((double)X, (double)Y, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static enum buttonStyle {
        COLORBLOCK,
        ITEMICON;

    }
}

