/*
 * Decompiled with CFR 0.152.
 */
package com.roripantsu.largesign.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import org.apache.commons.lang3.text.StrBuilder;

@SideOnly(value=Side.CLIENT)
public class CustomGuiTextAndFontStyleEditor
extends GuiScreen {
    private static final int[] ButtonSize = new int[]{60, 18};
    private static final String[] OnOffStr = new String[]{"[off]", "[on]"};
    protected GuiButton boldBtn;
    protected FontStyles currentFontStyle;
    protected GuiTextField editTextField;
    protected GuiButton italicBtn;
    protected final int lastButtonID;
    protected GuiButton resetAllBtn;
    protected GuiButton resetBtn;
    protected GuiButton field_146290_a;
    protected GuiButton shadowBtn;
    protected GuiButton strikethroughBtn;
    protected GuiButton underlineBtn;
    private List<GuiButton> buttonList = new ArrayList<GuiButton>();
    private int ID;
    private boolean isVisible;
    private int xPosition;
    private int yPosition;

    public CustomGuiTextAndFontStyleEditor(Minecraft MC, FontRenderer FontRenderer2, List<GuiButton> screenButtonList, int ID, int X, int Y) {
        this.field_146289_q = FontRenderer2;
        this.ID = ID;
        this.lastButtonID = ID + 6;
        this.xPosition = X;
        this.yPosition = Y;
        this.currentFontStyle = FontStyles.RESET;
        this.editTextField = new GuiTextField(this.field_146289_q, this.xPosition * 4 - 90, this.yPosition / 6 * 18, 180, 15);
        this.editTextField.func_146203_f(64);
        this.shadowBtn = new GuiButton(ID, this.xPosition - ButtonSize[0] / 2, this.yPosition, ButtonSize[0], ButtonSize[1] + 2, "Shadow " + OnOffStr[0]);
        this.buttonList.add(this.shadowBtn);
        this.boldBtn = new GuiButton(ID + 1, this.xPosition - ButtonSize[0] / 2, this.yPosition + (ButtonSize[1] + 2), ButtonSize[0] / 2, ButtonSize[1] + 2, "\u00a7l[B]\u00a7r " + FontStyles.BOLD.styleDisplayCode);
        this.buttonList.add(this.boldBtn);
        this.strikethroughBtn = new GuiButton(ID + 2, this.xPosition, this.yPosition + (ButtonSize[1] + 2), ButtonSize[0] / 2, ButtonSize[1] + 2, "\u00a7m[S]\u00a7r " + FontStyles.STRIKETHROUGH.styleDisplayCode);
        this.buttonList.add(this.strikethroughBtn);
        this.underlineBtn = new GuiButton(ID + 3, this.xPosition - ButtonSize[0] / 2, this.yPosition + (ButtonSize[1] + 2) * 2, ButtonSize[0] / 2, ButtonSize[1] + 2, "\u00a7n[U]\u00a7r " + FontStyles.UNDERLINE.styleDisplayCode);
        this.buttonList.add(this.underlineBtn);
        this.italicBtn = new GuiButton(ID + 4, this.xPosition, this.yPosition + (ButtonSize[1] + 2) * 2, ButtonSize[0] / 2, ButtonSize[1] + 2, "\u00a7o[I]\u00a7r " + FontStyles.ITALIC.styleDisplayCode);
        this.buttonList.add(this.italicBtn);
        this.resetBtn = new GuiButton(ID + 5, this.xPosition - ButtonSize[0] / 2, this.yPosition + (ButtonSize[1] + 2) * 3, ButtonSize[0], ButtonSize[1] + 2, "Reset " + FontStyles.RESET.styleDisplayCode);
        this.buttonList.add(this.resetBtn);
        this.resetAllBtn = new GuiButton(ID + 6, this.xPosition - ButtonSize[0] / 2, this.yPosition + (ButtonSize[1] + 2) * 4, ButtonSize[0], ButtonSize[1] + 2, "ResetAll");
        this.buttonList.add(this.resetAllBtn);
        screenButtonList.addAll(this.buttonList);
        FontStyles.SHADOW.enable = false;
    }

    public void func_73863_a(int mouseX, int mouseY, float par3) {
        if (this.isVisible) {
            this.editTextField.func_146194_f();
            this.func_73732_a(this.field_146289_q, "Font Styles:", this.xPosition, this.yPosition - 13, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, "Edit message:", this.xPosition * 4, this.yPosition / 6 * 16, 0xFFFFFF);
        }
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
        this.editTextField.func_146189_e(isVisible);
        this.editTextField.func_146184_c(isVisible);
        this.editTextField.func_146195_b(isVisible);
        if (!isVisible) {
            this.editTextField.func_146180_a("");
            FontStyles.SHADOW.enable = isVisible;
        }
        for (int i = 0; i < this.buttonList.size(); ++i) {
            this.buttonList.get((int)i).field_146125_m = isVisible;
            this.buttonList.get((int)i).field_146124_l = isVisible;
        }
    }

    public void func_73876_c() {
        this.editTextField.func_146178_a();
    }

    protected void func_146284_a(GuiButton btn) {
        if (btn.field_146124_l) {
            if (btn.field_146127_k == this.ID) {
                this.currentFontStyle = FontStyles.SHADOW;
                FontStyles.SHADOW.enable = !FontStyles.SHADOW.enable;
                btn.field_146126_j = btn.field_146126_j.contains(OnOffStr[0]) ? btn.field_146126_j.replace(OnOffStr[0], OnOffStr[1]) : btn.field_146126_j.replace(OnOffStr[1], OnOffStr[0]);
            }
            if (btn.field_146127_k == this.ID + 1) {
                this.currentFontStyle = FontStyles.BOLD;
                this.editTextField.func_146180_a(this.formatStringInsert(this.editTextField.func_146179_b()));
            }
            if (btn.field_146127_k == this.ID + 2) {
                this.currentFontStyle = FontStyles.STRIKETHROUGH;
                this.editTextField.func_146180_a(this.formatStringInsert(this.editTextField.func_146179_b()));
            }
            if (btn.field_146127_k == this.ID + 3) {
                this.currentFontStyle = FontStyles.UNDERLINE;
                this.editTextField.func_146180_a(this.formatStringInsert(this.editTextField.func_146179_b()));
            }
            if (btn.field_146127_k == this.ID + 4) {
                this.currentFontStyle = FontStyles.ITALIC;
                this.editTextField.func_146180_a(this.formatStringInsert(this.editTextField.func_146179_b()));
            }
            if (btn.field_146127_k == this.ID + 5) {
                this.currentFontStyle = FontStyles.RESET;
                this.editTextField.func_146180_a(this.formatStringInsert(this.editTextField.func_146179_b()));
            }
            if (btn.field_146127_k == this.ID + 6) {
                this.currentFontStyle = FontStyles.RESETALL;
                this.editTextField.func_146180_a(this.formatStringClear(this.editTextField.func_146179_b()));
                FontStyles.SHADOW.enable = false;
                if (this.shadowBtn.field_146126_j.contains(OnOffStr[1])) {
                    this.shadowBtn.field_146126_j = this.shadowBtn.field_146126_j.replace(OnOffStr[1], OnOffStr[0]);
                }
            }
        }
    }

    protected String formatStringChange(String str) {
        char[] displycodes = new char[]{FontStyles.BOLD.styleDisplayCode, FontStyles.ITALIC.styleDisplayCode, FontStyles.RESET.styleDisplayCode, FontStyles.STRIKETHROUGH.styleDisplayCode, FontStyles.UNDERLINE.styleDisplayCode};
        String[] formatcodes = new String[]{FontStyles.BOLD.styleCode, FontStyles.ITALIC.styleCode, FontStyles.RESET.styleCode, FontStyles.STRIKETHROUGH.styleCode, FontStyles.UNDERLINE.styleCode};
        StrBuilder strb = new StrBuilder(str);
        for (int i = 0; i < displycodes.length; ++i) {
            strb.replaceAll(String.valueOf(displycodes[i]), formatcodes[i]);
        }
        return strb.toString();
    }

    protected void func_73869_a(char par1, int par2) {
        this.editTextField.func_146201_a(par1, par2);
        this.editTextField.func_146180_a(this.StringNumberLimitProcess(this.editTextField.func_146179_b()));
    }

    protected void func_73864_a(int mouseX, int mouseY, int par3) {
        if (par3 == 0) {
            this.editTextField.func_146192_a(mouseX, mouseY, par3);
        }
    }

    private int CharNumberCount(String str) {
        return this.formatStringClear(str).length();
    }

    private String formatStringClear(String str) {
        char[] displycodes = new char[]{FontStyles.BOLD.styleDisplayCode, FontStyles.ITALIC.styleDisplayCode, FontStyles.RESET.styleDisplayCode, FontStyles.STRIKETHROUGH.styleDisplayCode, FontStyles.UNDERLINE.styleDisplayCode};
        StrBuilder strb = new StrBuilder(str);
        if (this.editTextField.func_146179_b() != null) {
            for (char c : displycodes) {
                strb.deleteAll(c);
            }
        }
        return strb.toString();
    }

    private String formatStringInsert(String str) {
        StrBuilder strb = new StrBuilder(str);
        if (this.editTextField.func_146179_b() != null) {
            int currentCursorPosition = this.editTextField.func_146198_h();
            strb.insert(currentCursorPosition, this.currentFontStyle.styleDisplayCode);
            this.editTextField.func_146195_b(true);
        }
        return strb.toString();
    }

    private String StringNumberLimitProcess(String str) {
        char[] displycodes = new char[]{FontStyles.BOLD.styleDisplayCode, FontStyles.ITALIC.styleDisplayCode, FontStyles.RESET.styleDisplayCode, FontStyles.STRIKETHROUGH.styleDisplayCode, FontStyles.UNDERLINE.styleDisplayCode};
        StrBuilder strb = new StrBuilder(str);
        int index = strb.length() - 1;
        while (this.CharNumberCount(strb.toString()) > 8) {
            char a = strb.charAt(index);
            if (a != displycodes[0] && a != displycodes[1] && a != displycodes[2] && a != displycodes[3]) {
                strb.deleteCharAt(index);
            }
            --index;
        }
        return strb.toString();
    }

    public static enum FontStyles {
        BOLD("\u00a7l", '\u24b7'),
        ITALIC("\u00a7o", '\u24be'),
        RESET("\u00a7r", '\u24c7'),
        RESETALL,
        SHADOW(false),
        STRIKETHROUGH("\u00a7m", '\u24c8'),
        UNDERLINE("\u00a7n", '\u24ca');

        public boolean enable = false;
        public final String styleCode;
        public final char styleDisplayCode;

        private FontStyles() {
            this.styleCode = "";
            this.styleDisplayCode = '\u0000';
        }

        private FontStyles(boolean enable) {
            this.styleCode = "";
            this.styleDisplayCode = '\u0000';
            this.enable = enable;
        }

        private FontStyles(String code, char displayCode) {
            this.styleCode = code;
            this.styleDisplayCode = displayCode;
        }
    }
}

