/*
 * Decompiled with CFR 0.152.
 */
package com.roripantsu.largesign.network;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.roripantsu.largesign.network.AbsPacket;
import com.roripantsu.largesign.network.NetHandlerPlayClientSide;
import com.roripantsu.largesign.network.NetHandlerPlayServerSide;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ChannelHandler.Sharable
public class PacketPipeline {
    private static final Logger logger = LogManager.getLogger();
    private static PacketPipeline packetPipeline;
    private FMLEventChannel channels;
    private BiMap<Integer, String> channelsList = HashBiMap.create();
    private boolean isPostInitialised = false;
    private LinkedList<Class<? extends AbsPacket>> packetsList = new LinkedList();

    public static PacketPipeline getPacketPipeline() {
        return packetPipeline;
    }

    public PacketPipeline() {
        packetPipeline = this;
    }

    public void addNewChannel(int channelkey, String channelName) {
        if (this.channelsList.containsKey((Object)channelkey) || this.channelsList.containsValue((Object)channelName)) {
            throw new RuntimeException("That channel is already exist");
        }
        this.channelsList.put((Object)channelkey, (Object)channelName);
        this.channels = NetworkRegistry.INSTANCE.newEventDrivenChannel(channelName);
    }

    public void decode(FMLProxyPacket proxyPacket, int channelKey, List<Object> out) throws Exception {
        ByteBuf payload = proxyPacket.payload();
        byte discriminator = payload.readByte();
        Class<? extends AbsPacket> theClass = this.packetsList.get(discriminator);
        if (theClass == null) {
            throw new NullPointerException("No packet registered for discriminator: " + discriminator);
        }
        AbsPacket thePacket = theClass.newInstance();
        thePacket.decodePacket(new PacketBuffer(payload.slice()));
        switch (FMLCommonHandler.instance().getEffectiveSide()) {
            case CLIENT: {
                NetHandlerPlayClientSide NHPCS = new NetHandlerPlayClientSide(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71462_r, Minecraft.func_71410_x().func_147114_u().func_147298_b());
                thePacket.handleClientSide(NHPCS, this.getEntityPlayer());
                break;
            }
            case SERVER: {
                NetHandlerPlayServer netHandler = (NetHandlerPlayServer)NetworkRegistry.INSTANCE.getChannel((String)this.channelsList.get((Object)channelKey), Side.SERVER).attr(NetworkRegistry.NET_HANDLER).get();
                NetHandlerPlayServerSide NHPSS = new NetHandlerPlayServerSide(MinecraftServer.func_71276_C(), netHandler.field_147369_b, netHandler.field_147371_a);
                thePacket.handleServerSide(NHPSS, (EntityPlayer)netHandler.field_147369_b);
                break;
            }
        }
        out.add(thePacket);
    }

    public void encode(AbsPacket thePacket, int channelKey, List<Object> out) throws Exception {
        PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
        Class<?> theClass = thePacket.getClass();
        if (!this.packetsList.contains(thePacket.getClass())) {
            throw new NullPointerException("No Packet Registered for: " + thePacket.getClass().getCanonicalName());
        }
        byte discriminator = (byte)this.packetsList.indexOf(theClass);
        packetBuffer.writeByte((int)discriminator);
        thePacket.encodePacket(packetBuffer);
        FMLProxyPacket proxyPacket = new FMLProxyPacket(packetBuffer.copy(), (String)this.channelsList.get((Object)channelKey));
        out.add(proxyPacket);
    }

    @SideOnly(value=Side.CLIENT)
    public EntityPlayer getEntityPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public List<Object> getPacketsList() {
        LinkedList<Object> list = new LinkedList<Object>();
        list.addAll(this.packetsList);
        return list;
    }

    public void postInitialise() {
        if (this.isPostInitialised) {
            return;
        }
        this.isPostInitialised = true;
        Collections.sort(this.packetsList, new Comparator<Class<? extends AbsPacket>>(){

            @Override
            public int compare(Class<? extends AbsPacket> theClass1, Class<? extends AbsPacket> theClass2) {
                int com = String.CASE_INSENSITIVE_ORDER.compare(theClass1.getCanonicalName(), theClass2.getCanonicalName());
                if (com == 0) {
                    com = theClass1.getCanonicalName().compareTo(theClass2.getCanonicalName());
                }
                return com;
            }
        });
    }

    public void registeEventListener(Object obj) {
        this.channels.register(obj);
    }

    public boolean registerPacket(Class<? extends AbsPacket> theClass) {
        if (this.packetsList.size() > 256) {
            logger.debug("packetsList.size() > 256");
            return false;
        }
        if (this.packetsList.contains(theClass)) {
            logger.debug("packetsList.contains(theClass)");
            return false;
        }
        if (this.isPostInitialised) {
            logger.debug("isPostInitialised");
            return false;
        }
        this.packetsList.add(theClass);
        return true;
    }

    public void sendTo(FMLProxyPacket pkt, EntityPlayerMP player) {
        this.channels.sendTo(pkt, player);
    }

    public void sendToAll(FMLProxyPacket pkt) {
        this.channels.sendToAll(pkt);
    }

    public void sendToAllAround(FMLProxyPacket pkt, NetworkRegistry.TargetPoint point) {
        this.channels.sendToAllAround(pkt, point);
    }

    public void sendToDimension(FMLProxyPacket pkt, int dimensionId) {
        this.channels.sendToDimension(pkt, dimensionId);
    }

    public void sendToServer(FMLProxyPacket pkt) {
        this.channels.sendToServer(pkt);
    }
}

