/*
 * Decompiled with CFR 0.152.
 */
package com.roripantsu.largesign.texture;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.client.resources.data.TextureMetadataSection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class CustomTextureSprite
extends TextureAtlasSprite {
    private static final Logger logger = LogManager.getLogger();
    int anisotropicFiltering;
    int mipmapLevels;
    private final String basePath;

    public CustomTextureSprite(int originX, int originY, String basePath, String iconName) {
        super(iconName);
        this.anisotropicFiltering = Minecraft.func_71410_x().field_71474_y.field_151443_J;
        this.mipmapLevels = Minecraft.func_71410_x().field_71474_y.field_151442_I;
        this.basePath = basePath;
        this.field_110975_c = originX;
        this.field_110974_d = originY;
        this.field_130223_c = 16;
        this.field_130224_d = 16;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public boolean load(IResourceManager manager, ResourceLocation location) {
        try {
            ResourceLocation locationNormal = this.completeResourceLocation(location, 0);
            IResource iresource = manager.func_110536_a(locationNormal);
            BufferedImage[] abufferedimage = new BufferedImage[1 + this.mipmapLevels];
            abufferedimage[0] = ImageIO.read(iresource.func_110527_b()).getSubimage(this.field_110975_c, this.field_110974_d, 16, 16);
            TextureMetadataSection texturemetadatasection = (TextureMetadataSection)iresource.func_110526_a("texture");
            if (texturemetadatasection != null) {
                int l;
                List list = texturemetadatasection.func_148535_c();
                if (!list.isEmpty()) {
                    int k = abufferedimage[0].getWidth();
                    l = abufferedimage[0].getHeight();
                    if (MathHelper.func_151236_b((int)k) != k || MathHelper.func_151236_b((int)l) != l) {
                        throw new RuntimeException("Unable to load extra miplevels, source-texture is not power of two");
                    }
                }
                Iterator iterator3 = list.iterator();
                while (iterator3.hasNext()) {
                    l = (Integer)iterator3.next();
                    if (l <= 0 || l >= abufferedimage.length - 1 || abufferedimage[l] != null) continue;
                    ResourceLocation locationNormalMipmaps = this.completeResourceLocation(location, l);
                    try {
                        abufferedimage[l] = ImageIO.read(manager.func_110536_a(locationNormalMipmaps).func_110527_b());
                    }
                    catch (IOException ioexception) {
                        logger.error("Unable to load miplevel {} from: {}", new Object[]{l, locationNormalMipmaps, ioexception});
                    }
                }
            }
            AnimationMetadataSection animationmetadatasection = (AnimationMetadataSection)iresource.func_110526_a("animation");
            this.func_147964_a(abufferedimage, animationmetadatasection, (float)this.anisotropicFiltering > 1.0f);
        }
        catch (RuntimeException runtimeexception) {
            logger.error("Unable to parse metadata from " + location, (Throwable)runtimeexception);
        }
        catch (IOException ioexception1) {
            logger.error("Using missing texture, unable to load " + location, (Throwable)ioexception1);
        }
        return false;
    }

    private ResourceLocation completeResourceLocation(ResourceLocation location, int num) {
        return num == 0 ? new ResourceLocation(location.func_110624_b(), String.format("%s/%s%s", this.basePath, location.func_110623_a(), ".png")) : new ResourceLocation(location.func_110624_b(), String.format("%s/mipmaps/%s.%d%s", this.basePath, location.func_110623_a(), num, ".png"));
    }
}

