/*
 * Decompiled with CFR 0.152.
 */
package net.einsteinsci.betterbeginnings.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.config.Configuration;

public class BBConfig {
    public static final String GENERAL = "general";
    public static final String CRAFTING = "otherCrafting";
    public static final String SMELTING = "smelting";
    public static final String MOBDROPS = "mobdrops";
    public static final String WORLDGEN = "worldgen";
    public static final String TWEAKS = "tweaks";
    public static boolean greetUser;
    public static boolean debugLogging;
    public static boolean moduleBlockBreaking;
    public static boolean moduleAdvancedCrafting;
    public static boolean moduleInfusionRepair;
    public static boolean moduleCampfire;
    public static boolean moduleFurnaces;
    public static boolean advancedCraftingForLotsOfThings;
    public static boolean removeCraftedFoodRecipes;
    public static boolean canMakeChainArmor;
    public static boolean removeWoodToolRecipes;
    public static boolean anyStringForTraps;
    public static boolean allowStringAsToolBinding;
    public static boolean flamingAnimalsDropCharredMeat;
    public static boolean spidersDropString;
    public static boolean moreBones;
    public static boolean moreBonesPeacefulOnly;
    public static boolean spawnMarshmallows;
    public static boolean canSmelterDoKilnStuff;
    public static boolean removeSmeltingRecipes;
    public static boolean removeOnlyVanillaSmeltingRecipes;
    public static boolean canCampfireDoAllKilnStuff;
    public static boolean makeStuffStackable;
    public static boolean noDamageOnBadBreak;
    public static List<String> alwaysBreakable;

    public static void initialize() {
        greetUser = true;
        debugLogging = false;
        moduleBlockBreaking = true;
        moduleAdvancedCrafting = true;
        moduleInfusionRepair = true;
        moduleCampfire = true;
        moduleFurnaces = true;
        advancedCraftingForLotsOfThings = true;
        removeCraftedFoodRecipes = true;
        canMakeChainArmor = true;
        removeWoodToolRecipes = true;
        anyStringForTraps = false;
        allowStringAsToolBinding = true;
        flamingAnimalsDropCharredMeat = true;
        spidersDropString = false;
        moreBones = true;
        moreBonesPeacefulOnly = true;
        spawnMarshmallows = true;
        canSmelterDoKilnStuff = false;
        removeSmeltingRecipes = true;
        removeOnlyVanillaSmeltingRecipes = true;
        canCampfireDoAllKilnStuff = false;
        makeStuffStackable = true;
        noDamageOnBadBreak = false;
        alwaysBreakable = new ArrayList<String>();
    }

    public static void syncConfig(Configuration config) {
        greetUser = config.getBoolean("Greet user", GENERAL, true, "Greet user upon login");
        debugLogging = config.getBoolean("Debug logging", GENERAL, false, "Log all kinds of stuff, for debug purposes");
        moduleBlockBreaking = config.getBoolean("Module - Block breaking", GENERAL, true, "Enable BetterBeginnings block breaking mechanics. Set to false for vanilla mechanics.");
        moduleAdvancedCrafting = config.getBoolean("Module - Force Advanced crafting", GENERAL, true, "Disable vanilla crafting for some recipes that require advanced crafting table.");
        moduleInfusionRepair = config.getBoolean("Module - Infusion Repair", GENERAL, true, "Enable Infusion Repair Table recipe. Set to false to force anvil repairs.");
        moduleCampfire = config.getBoolean("Module - Campfire", GENERAL, true, "Enable Campfire recipe. Set to false to make the beginning even harder.");
        moduleFurnaces = config.getBoolean("Module - Furnaces", GENERAL, true, "Enable Furnaces recipes. Set to false to only allow vanilla furnace. \nThis will revert the vanilla furnace to the vanilla recipe.");
        flamingAnimalsDropCharredMeat = config.getBoolean("Flaming animals drop charred meat", MOBDROPS, true, "Animals that die by flame drop charred meat instead of vanilla cooked meat");
        spidersDropString = config.getBoolean("Spiders drop string", MOBDROPS, false, "Spiders drop vanilla string as well as silk.");
        moreBones = config.getBoolean("All bones", MOBDROPS, true, "Almost all mobs drop bones, not just skeletons.");
        moreBonesPeacefulOnly = config.getBoolean("More bones only works on peaceful", MOBDROPS, true, "Non-skeleton mobs only drop bones on peaceful. Requires 'All bones' to be true in order to do anything.");
        spawnMarshmallows = config.getBoolean("Generate marshmallows", WORLDGEN, true, "[WIP] Marshmallows spawn in dungeons, mineshafts, desert temples, and jungle temples.");
        makeStuffStackable = config.getBoolean("Make stuff stackable", TWEAKS, true, "Makes items that should be stackable (minecarts, potions, etc.) stackable.");
        noDamageOnBadBreak = config.getBoolean("No damage on wrong block breaking", TWEAKS, false, "Set to true to disable damage when breaking certain blocks with your hands/face.");
        advancedCraftingForLotsOfThings = config.getBoolean("Advanced crafting for lots of things", CRAFTING, true, "Require Advanced Crafting for things like doors, pistons, chests, etc.");
        removeCraftedFoodRecipes = config.getBoolean("Remove crafted food recipes", CRAFTING, true, "Remove crafting recipes of vanilla food items, enforcing the use of the brick ovens.");
        canMakeChainArmor = config.getBoolean("Enable chain armor", CRAFTING, true, "Allow vanilla chain armor to be craftable from iron nuggets");
        removeWoodToolRecipes = config.getBoolean("Remove wooden tool recipes", CRAFTING, true, "Remove recipes for wooden pickaxe, axe, shovel, and hoe.");
        anyStringForTraps = config.getBoolean("Any string for traps", CRAFTING, false, "Allow any string to be used for tripwire hooks, trapped chests, etc.");
        allowStringAsToolBinding = config.getBoolean("Allow string and twine as tool binding", CRAFTING, true, "Allow string and twine to be used in place of leather strips in tool bindings, at a higher cost.");
        canSmelterDoKilnStuff = config.getBoolean("Smelter can make kiln products", SMELTING, false, "Allow smelter to make glass, bricks, smooth stone, etc.");
        removeSmeltingRecipes = config.getBoolean("Disable vanilla smelting", SMELTING, true, "Remove recipes that normally use the vanilla furnace");
        removeOnlyVanillaSmeltingRecipes = config.getBoolean("Only remove smelting recipes for vanilla items", SMELTING, true, "Only remove furnace recipes for vanilla items/blocks. Requires 'Disable vanilla smelting'.");
        canCampfireDoAllKilnStuff = config.getBoolean("Allow campfire to use all kiln recipes", SMELTING, false, "Allow campfire to process all recipes kiln can, instead of just a few.");
        String[] _alwaysBreakable = config.getStringList("Always breakable", GENERAL, new String[0], "List of blocks to always be breakable. Use this format: 'modid:blockName'.");
        alwaysBreakable.clear();
        Collections.addAll(alwaysBreakable, _alwaysBreakable);
        if (config.hasChanged()) {
            config.save();
        }
    }
}

