/*
 * Decompiled with CFR 0.152.
 */
package net.einsteinsci.betterbeginnings.event;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import net.einsteinsci.betterbeginnings.ModMain;
import net.einsteinsci.betterbeginnings.config.BBConfig;
import net.einsteinsci.betterbeginnings.event.BlockBreakHelper;
import net.einsteinsci.betterbeginnings.items.ItemHammer;
import net.einsteinsci.betterbeginnings.items.ItemKnife;
import net.einsteinsci.betterbeginnings.register.RegisterBlocks;
import net.einsteinsci.betterbeginnings.register.RegisterItems;
import net.einsteinsci.betterbeginnings.register.achievement.RegisterAchievements;
import net.einsteinsci.betterbeginnings.tileentity.TileEntityCampfire;
import net.einsteinsci.betterbeginnings.util.ChatUtil;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public class BBEventHandler {
    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        if (BBConfig.greetUser) {
            ChatUtil.sendChatToPlayer(e.player, "\u00a7aBetterBeginnings 0.9.5-R1b loaded successfully.");
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (e.modID.equals("betterbeginnings")) {
            BBConfig.syncConfig(ModMain.configFile);
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent e) {
        Block block;
        Item item = e.itemStack.func_77973_b();
        if (item == RegisterItems.charredMeat) {
            e.toolTip.add("Not to be confused with charcoal");
        }
        if (item == RegisterItems.rotisserie) {
            e.toolTip.add("\u00a79Not for roasting people");
        }
        if (item == RegisterItems.ironNugget) {
            e.toolTip.add("Good for hinges and rivets");
        }
        if (item == RegisterItems.flintKnife) {
            e.toolTip.add("Don't bring it to a gunfight");
        }
        if (item == RegisterItems.noobWoodSword && EnchantmentHelper.func_82781_a((ItemStack)e.itemStack).isEmpty()) {
            e.toolTip.add("\u00a79+0 Attack Damage");
        }
        if (item == RegisterItems.testItem) {
            e.toolTip.add("\u00a7dFor dev testing only. What it does");
            e.toolTip.add("\u00a7dchanges from one version to the next.");
        }
        if (item == RegisterItems.pan) {
            e.toolTip.add("\u00a79Fry stuff over a campfire!");
        }
        if (item == RegisterItems.fireBow) {
            e.toolTip.add("\u00a7oNot that kind of bow.");
        }
        if (item == Items.field_151102_aT) {
            e.toolTip.add("\u00a7oYes please!");
        }
        if (item == Item.func_150898_a((Block)RegisterBlocks.campfire) && !BBConfig.moduleCampfire) {
            e.toolTip.add("\u00a7cModule disabled in config.");
        }
        if (item == Item.func_150898_a((Block)RegisterBlocks.infusionRepairStation) && !BBConfig.moduleInfusionRepair) {
            e.toolTip.add("\u00a7cModule disabled in config.");
        }
        if (!((block = Block.func_149634_a((Item)item)) == null || block != RegisterBlocks.kiln && block != RegisterBlocks.obsidianKiln && block != RegisterBlocks.brickOven && block != RegisterBlocks.netherBrickOven && block != RegisterBlocks.smelter && block != RegisterBlocks.enderSmelter || BBConfig.moduleFurnaces)) {
            e.toolTip.add("\u00a7cModule disabled in config.");
        }
        if (this.isWIP(e.itemStack)) {
            e.toolTip.add("\u00a7cWIP. May not be fully functional.");
        }
    }

    public boolean isWIP(ItemStack stack) {
        ArrayList wip = new ArrayList();
        for (ItemStack test : wip) {
            if (stack.func_77973_b() != test.func_77973_b()) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent e) {
        BlockBreakHelper.handleBlockBreaking(e);
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent e) {
        Block b;
        ItemStack stack;
        Item item;
        if (!(e.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK || e.entityPlayer.func_70694_bm() == null || (item = (stack = e.entityPlayer.func_70694_bm()).func_77973_b()) != Items.field_151033_d && item != RegisterItems.fireBow || (b = e.world.func_147439_a(e.x, e.y, e.z)) != RegisterBlocks.campfire && b != RegisterBlocks.campfireLit)) {
            TileEntityCampfire campfire = (TileEntityCampfire)e.world.func_147438_o(e.x, e.y, e.z);
            campfire.lightFuel();
        }
    }

    @SubscribeEvent
    public void onBlockDrops(BlockEvent.HarvestDropsEvent e) {
        ItemStack crushResult;
        Block block = e.block;
        EntityPlayer player = e.harvester;
        if (player == null) {
            return;
        }
        ItemStack held = player.func_70694_bm();
        Random rand = player.field_70170_p.field_73012_v;
        if (block == Blocks.field_150395_bd && !e.isSilkTouching && held != null && held.func_77973_b() instanceof ItemKnife && rand.nextInt(8) == 0) {
            e.drops.add(new ItemStack(Blocks.field_150395_bd));
        }
        if ((block == Blocks.field_150329_H || block == Blocks.field_150330_I) && !e.isSilkTouching && held != null && held.func_77973_b() instanceof ItemKnife && rand.nextInt(8) == 0) {
            e.drops.add(new ItemStack(block, 1, e.blockMetadata));
        }
        if (held != null && held.func_77973_b() instanceof ItemHammer && (crushResult = ItemHammer.getCrushResult(block)) != null) {
            e.drops.clear();
            e.drops.add(crushResult);
        }
        if (block == Blocks.field_150473_bD) {
            int rem = 0;
            for (int i = 0; i < e.drops.size(); ++i) {
                if (((ItemStack)e.drops.get(i)).func_77973_b() != Items.field_151007_F) continue;
                rem = i;
            }
            int count = ((ItemStack)e.drops.get((int)rem)).field_77994_a;
            e.drops.remove(rem);
            e.drops.add(new ItemStack(RegisterItems.thread, count));
        }
        ItemStack heldItemStack = player.func_70694_bm();
        int neededHarvestLevel = block.getHarvestLevel(e.blockMetadata);
        String neededToolClass = block.getHarvestTool(e.blockMetadata);
        int usedHarvestLevel = 0;
        String usedToolClass = null;
        if (heldItemStack != null) {
            for (String toolClass : heldItemStack.func_77973_b().getToolClasses(heldItemStack)) {
                int hl = heldItemStack.func_77973_b().getHarvestLevel(heldItemStack, toolClass);
                if (hl < usedHarvestLevel) continue;
                usedHarvestLevel = hl;
                usedToolClass = toolClass;
            }
        }
        if (neededToolClass == null || neededToolClass.equalsIgnoreCase("shovel") || neededToolClass.equalsIgnoreCase("null")) {
            return;
        }
        if (usedToolClass == null || !usedToolClass.equalsIgnoreCase(neededToolClass) || usedHarvestLevel < neededHarvestLevel) {
            e.drops.clear();
        }
    }

    @SubscribeEvent
    public void onItemSmelted(PlayerEvent.ItemSmeltedEvent e) {
        if (e.smelting.func_77973_b() == Items.field_151153_ao && e.smelting.func_77960_j() == 1) {
            RegisterAchievements.achievementGet(e.player, "notchApple");
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent e) {
        int i;
        if (e.crafting.func_77973_b() instanceof ItemKnife) {
            for (i = 0; i < e.craftMatrix.func_70302_i_(); ++i) {
                ItemStack stack = e.craftMatrix.func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof ItemKnife)) continue;
                --stack.field_77994_a;
                if (stack.field_77994_a <= 0) {
                    e.craftMatrix.func_70299_a(i, null);
                    continue;
                }
                e.craftMatrix.func_70299_a(i, stack);
            }
        }
        if (e.crafting.func_77973_b() == RegisterItems.flintKnife) {
            RegisterAchievements.achievementGet(e.player, "flintKnife");
        } else if (e.crafting.func_77973_b() instanceof ItemKnife) {
            RegisterAchievements.achievementGet(e.player, "upgradeKnife");
        }
        if (e.crafting.func_77973_b() == Items.field_151007_F) {
            RegisterAchievements.achievementGet(e.player, "makeString");
        }
        if (e.crafting.func_77973_b() == RegisterItems.twine) {
            RegisterAchievements.achievementGet(e.player, "makeTwine");
        }
        for (i = 0; i < e.craftMatrix.func_70302_i_(); ++i) {
            ItemStack current;
            if (e.craftMatrix.func_70301_a(i) == null || !((current = e.craftMatrix.func_70301_a(i)).func_77973_b() instanceof ItemKnife) || e.crafting.func_77973_b() != Items.field_151055_y) continue;
            RegisterAchievements.achievementGet(e.player, "makeSticks");
        }
        if (e.crafting.func_77973_b() == RegisterItems.flintHatchet) {
            RegisterAchievements.achievementGet(e.player, "makeHatchet");
        }
        if (e.crafting.func_77973_b() instanceof ItemSword) {
            RegisterAchievements.achievementGet(e.player, "makeSword");
        }
        if (e.crafting.func_77973_b() == Item.func_150898_a((Block)RegisterBlocks.infusionRepairStation)) {
            RegisterAchievements.achievementGet(e.player, "infusionRepair");
        }
        if (e.crafting.func_77973_b() == RegisterItems.boneShard) {
            RegisterAchievements.achievementGet(e.player, "boneShards");
        }
        if (e.crafting.func_77973_b() == RegisterItems.bonePickaxe) {
            RegisterAchievements.achievementGet(e.player, "bonePick");
        }
        if (e.crafting.func_77973_b() == Item.func_150898_a((Block)RegisterBlocks.kiln)) {
            RegisterAchievements.achievementGet(e.player, "makeKiln");
        }
        if (e.crafting.func_77973_b() == Item.func_150898_a((Block)RegisterBlocks.obsidianKiln)) {
            RegisterAchievements.achievementGet(e.player, "obsidianKiln");
        }
        if (e.crafting.func_77973_b() == Item.func_150898_a((Block)RegisterBlocks.smelter)) {
            RegisterAchievements.achievementGet(e.player, "makeSmelter");
        }
        if (e.crafting.func_77973_b() == Item.func_150898_a((Block)RegisterBlocks.enderSmelter)) {
            RegisterAchievements.achievementGet(e.player, "enderSmelter");
        }
        if (e.crafting.func_77973_b() == Item.func_150898_a((Block)RegisterBlocks.brickOven)) {
            RegisterAchievements.achievementGet(e.player, "makeBrickOven");
        }
        if (e.crafting.func_77973_b() == Items.field_151105_aU) {
            RegisterAchievements.achievementGet(e.player, "cake");
        }
        if (e.crafting.func_77973_b() == Item.func_150898_a((Block)RegisterBlocks.netherBrickOven)) {
            RegisterAchievements.achievementGet(e.player, "netherBrickOven");
        }
    }

    @SubscribeEvent
    public void onEntityLivingDrops(LivingDropsEvent e) {
        int dropCount;
        Random rand = e.entity.field_70170_p.field_73012_v;
        if (e.entityLiving instanceof EntitySpider) {
            if (!BBConfig.spidersDropString) {
                Iterator iterator = e.drops.iterator();
                while (iterator.hasNext()) {
                    EntityItem entityItem = (EntityItem)iterator.next();
                    Item item = entityItem.func_92059_d().func_77973_b();
                    if (item != Items.field_151007_F) continue;
                    iterator.remove();
                }
            }
            dropCount = rand.nextInt(3 + e.lootingLevel) + 2;
            for (int i = 0; i < dropCount; ++i) {
                e.entityLiving.func_145779_a(RegisterItems.silk, 1);
            }
        }
        if (BBConfig.moreBones) {
            if (!BBConfig.moreBonesPeacefulOnly || e.entity.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
                int i;
                int maxBones = 0;
                int maxShards = 0;
                if (e.entityLiving instanceof EntityCow) {
                    maxBones = 4;
                }
                if (e.entityLiving instanceof EntitySheep || e.entityLiving instanceof EntityPig) {
                    maxBones = 3;
                }
                if (e.entityLiving instanceof EntityChicken || e.entityLiving instanceof EntityOcelot) {
                    maxShards = 3;
                }
                if (e.entityLiving instanceof EntityZombie) {
                    maxBones = 2;
                    maxShards = 3;
                }
                if (maxBones > 0 && e.recentlyHit && !e.entityLiving.func_70631_g_()) {
                    int dropCount2 = rand.nextInt(maxBones + e.lootingLevel);
                    for (i = 0; i < dropCount2; ++i) {
                        e.entityLiving.func_145779_a(Items.field_151103_aS, 1);
                    }
                }
                if (maxShards > 0 && e.recentlyHit && !e.entityLiving.func_70631_g_()) {
                    int dropCount3 = rand.nextInt(maxShards + e.lootingLevel);
                    for (i = 0; i < dropCount3; ++i) {
                        e.entityLiving.func_145779_a(RegisterItems.boneShard, 1);
                    }
                }
            }
            if (e.entityLiving instanceof EntitySkeleton) {
                dropCount = rand.nextInt(3 + e.lootingLevel);
                e.entityLiving.func_145779_a(Items.field_151103_aS, 1);
                e.entityLiving.func_145779_a(RegisterItems.boneShard, dropCount);
            }
        }
        if (BBConfig.flamingAnimalsDropCharredMeat && (e.entityLiving instanceof EntityCow || e.entityLiving instanceof EntityPig || e.entityLiving instanceof EntityChicken)) {
            int charredDrops = 0;
            Iterator iterator = e.drops.iterator();
            while (iterator.hasNext()) {
                EntityItem entityItem = (EntityItem)iterator.next();
                Item item = entityItem.func_92059_d().func_77973_b();
                if (item != Items.field_151083_be && item != Items.field_151157_am && item != Items.field_151077_bg) continue;
                iterator.remove();
                charredDrops += entityItem.func_92059_d().field_77994_a;
            }
            e.entityLiving.func_145779_a(RegisterItems.charredMeat, charredDrops);
        }
    }
}

