/*
 * Decompiled with CFR 0.152.
 */
package net.einsteinsci.betterbeginnings.event;

import java.util.HashMap;
import java.util.Map;
import net.einsteinsci.betterbeginnings.ModMain;
import net.einsteinsci.betterbeginnings.config.BBConfig;
import net.einsteinsci.betterbeginnings.event.DamageSourceFace;
import net.einsteinsci.betterbeginnings.items.ItemKnife;
import net.einsteinsci.betterbeginnings.util.ChatUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import org.apache.logging.log4j.Level;

public class BlockBreakHelper {
    public static final Map<EntityPlayer, BlockPos> brokenOnce = new HashMap<EntityPlayer, BlockPos>();

    public static void handleBlockBreaking(BlockEvent.BreakEvent e) {
        String stackName;
        if (!BBConfig.moduleBlockBreaking) {
            return;
        }
        if (e.getPlayer() instanceof FakePlayer) {
            return;
        }
        Block block = e.block;
        EntityPlayer player = e.getPlayer();
        ItemStack heldItemStack = player.func_70694_bm();
        for (String blockId : BBConfig.alwaysBreakable) {
            if (!block.func_149739_a().equals(blockId)) continue;
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        int neededHarvestLevel = block.getHarvestLevel(e.blockMetadata);
        String neededToolClass = block.getHarvestTool(e.blockMetadata);
        int usedHarvestLevel = 0;
        String usedToolClass = null;
        String string = stackName = heldItemStack != null ? heldItemStack.func_82833_r() : "NULL";
        if (heldItemStack != null) {
            for (String toolClass : heldItemStack.func_77973_b().getToolClasses(heldItemStack)) {
                int hl = heldItemStack.func_77973_b().getHarvestLevel(heldItemStack, toolClass);
                if (hl < usedHarvestLevel) continue;
                usedHarvestLevel = hl;
                usedToolClass = toolClass;
            }
        }
        boolean cancel = false;
        if (heldItemStack != null && heldItemStack.func_77973_b() instanceof ItemKnife && ItemKnife.getBreakable().contains(block)) {
            return;
        }
        if (neededToolClass == null || neededToolClass.equalsIgnoreCase("shovel") || neededToolClass.equalsIgnoreCase("null")) {
            return;
        }
        if (neededToolClass.equalsIgnoreCase(usedToolClass)) {
            if (usedHarvestLevel < neededHarvestLevel) {
                cancel = true;
            }
        } else if (usedToolClass == null || usedToolClass.equalsIgnoreCase("null")) {
            if (e.world.field_73013_u != EnumDifficulty.PEACEFUL && !BBConfig.noDamageOnBadBreak) {
                player.func_70097_a((DamageSource)new DamageSourceFace(block), 6.0f);
            }
            if (!brokenOnce.containsKey(player) || brokenOnce.get(player) == null || !brokenOnce.get(player).equals(new BlockPos(e.x, e.y, e.z))) {
                ChatUtil.sendModChatToPlayer(player, "Almost. Once more should do it.");
                brokenOnce.put(player, new BlockPos(e.x, e.y, e.z));
                e.setCanceled(true);
                return;
            }
            ChatUtil.sendModChatToPlayer(player, "Ouch! But at least it worked.");
            brokenOnce.put(player, null);
            ModMain.Log(Level.INFO, "Block break failed for " + stackName + " on " + block.func_149739_a());
            ModMain.Log(Level.INFO, "  Required tool class: " + neededToolClass + ", supplied: " + usedToolClass);
            ModMain.Log(Level.INFO, "  Minimum harvest level: " + neededHarvestLevel + ", supplied: " + usedHarvestLevel);
        } else {
            cancel = true;
        }
        if (cancel) {
            ModMain.Log(Level.INFO, "Block break failed for " + stackName + " on " + block.func_149739_a());
            ModMain.Log(Level.INFO, "  Required tool class: " + neededToolClass + ", supplied: " + usedToolClass);
            ModMain.Log(Level.INFO, "  Minimum harvest level: " + neededHarvestLevel + ", supplied: " + usedHarvestLevel);
            ChatUtil.sendModChatToPlayer(player, "Wrong tool!");
            ChatUtil.sendModChatToPlayer(player, "Requires " + BlockBreakHelper.getToolLevelName(neededHarvestLevel) + " " + neededToolClass + ".");
            e.setCanceled(true);
        }
    }

    public static String getToolLevelName(int level) {
        switch (level) {
            case 0: {
                return "flint or bone";
            }
            case 1: {
                return "stone";
            }
            case 2: {
                return "iron";
            }
            case 3: {
                return "diamond";
            }
        }
        return "[LEVEL " + level + "]";
    }

    public static class BlockPos {
        int x;
        int y;
        int z;

        public BlockPos(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }

        public void setX(int val) {
            this.x = val;
        }

        public void setY(int val) {
            this.y = val;
        }

        public void setZ(int val) {
            this.z = val;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BlockPos) {
                BlockPos p = (BlockPos)obj;
                return p.x == this.x && p.y == this.y && p.z == this.z;
            }
            return false;
        }

        public Object clone() {
            return new BlockPos(this.x, this.y, this.z);
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ", " + this.z + ")";
        }
    }
}

