/*
 * Decompiled with CFR 0.152.
 */
package net.einsteinsci.betterbeginnings.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.einsteinsci.betterbeginnings.inventory.ContainerNetherBrickOven;
import net.einsteinsci.betterbeginnings.tileentity.TileEntityNetherBrickOven;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiNetherBrickOven
extends GuiContainer {
    private static final ResourceLocation ovenGuiTextures = new ResourceLocation("betterbeginnings:textures/gui/container/netherBrickOven.png");
    private TileEntityNetherBrickOven tileBrickOven;

    public GuiNetherBrickOven(InventoryPlayer inventory, TileEntityNetherBrickOven tile) {
        super((Container)new ContainerNetherBrickOven(inventory, tile));
        this.tileBrickOven = tile;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String string = this.tileBrickOven.func_145818_k_() ? this.tileBrickOven.func_145825_b() : I18n.func_135052_a((String)this.tileBrickOven.func_145825_b(), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(string, 40, 6, 0x404040);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        if (mouseX >= k + 16 && mouseX <= k + 33 && mouseY >= l + 9 && mouseY <= l + 58) {
            this.drawFluidTooltip(mouseX - k, mouseY - l);
        }
    }

    private void drawFluidTooltip(int x, int y) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("" + this.tileBrickOven.getFuelLevel() + " mB");
        this.func_146283_a(lines, x, y);
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(ovenGuiTextures);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        int i1 = this.tileBrickOven.getCookProgressScaled(24);
        this.func_73729_b(k + 103, l + 34, 176, 14, i1 + 1, 16);
        int tankFillPx = this.tileBrickOven.getFuelLevelScaled(48);
        this.drawFluid(this.tileBrickOven.getFuelStack(), k + 17, l + 10, 16, 48, this.tileBrickOven.fuelTank.getCapacity());
    }

    public void drawFluid(FluidStack fluid, int x, int y, int width, int height, int maxCapacity) {
        int i;
        if (fluid == null || fluid.getFluid() == null) {
            return;
        }
        IIcon icon = fluid.getFluid().getIcon(fluid);
        this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GuiNetherBrickOven.setGLColorFromInt(fluid.getFluid().getColor(fluid));
        int fullX = width / 16;
        int fullY = height / 16;
        int lastX = width - fullX * 16;
        int lastY = height - fullY * 16;
        int level = fluid.amount * height / maxCapacity;
        int fullLvl = (height - level) / 16;
        int lastLvl = height - level - fullLvl * 16;
        for (i = 0; i < fullX; ++i) {
            for (int j = 0; j < fullY; ++j) {
                if (j < fullLvl) continue;
                this.drawCutIcon(icon, x + i * 16, y + j * 16, 16, 16, j == fullLvl ? lastLvl : 0);
            }
        }
        for (i = 0; i < fullX; ++i) {
            this.drawCutIcon(icon, x + i * 16, y + fullY * 16, 16, lastY, fullLvl == fullY ? lastLvl : 0);
        }
        for (i = 0; i < fullY; ++i) {
            if (i < fullLvl) continue;
            this.drawCutIcon(icon, x + fullX * 16, y + i * 16, lastX, 16, i == fullLvl ? lastLvl : 0);
        }
        this.drawCutIcon(icon, x + fullX * 16, y + fullY * 16, lastX, lastY, fullLvl == fullY ? lastLvl : 0);
    }

    public static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
    }

    private void drawCutIcon(IIcon icon, int x, int y, int width, int height, int cut) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78374_a((double)x, (double)(y + height), (double)this.field_73735_i, (double)icon.func_94209_e(), (double)icon.func_94207_b((double)height));
        tess.func_78374_a((double)(x + width), (double)(y + height), (double)this.field_73735_i, (double)icon.func_94214_a((double)width), (double)icon.func_94207_b((double)height));
        tess.func_78374_a((double)(x + width), (double)(y + cut), (double)this.field_73735_i, (double)icon.func_94214_a((double)width), (double)icon.func_94207_b((double)cut));
        tess.func_78374_a((double)x, (double)(y + cut), (double)this.field_73735_i, (double)icon.func_94209_e(), (double)icon.func_94207_b((double)cut));
        tess.func_78381_a();
    }
}

