/*
 * Decompiled with CFR 0.152.
 */
package net.einsteinsci.betterbeginnings.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import net.einsteinsci.betterbeginnings.gui.GuiDoubleWorkbench;
import net.einsteinsci.betterbeginnings.register.recipe.AdvancedCraftingHandler;
import net.einsteinsci.betterbeginnings.register.recipe.AdvancedRecipe;
import net.einsteinsci.betterbeginnings.register.recipe.OreRecipeElement;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class NEIAdvancedCraftingHandler
extends TemplateRecipeHandler {
    public void loadCraftingRecipes(ItemStack result) {
        for (AdvancedRecipe adv : AdvancedCraftingHandler.getRecipeList()) {
            if (adv.hideFromNEI || adv.getRecipeOutput().func_77973_b() != result.func_77973_b() || result.func_77960_j() != Short.MAX_VALUE && adv.getRecipeOutput().func_77960_j() != result.func_77960_j()) continue;
            this.arecipes.add(new AdvancedCachedRecipe(adv));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        ArrayList foundOutputs = new ArrayList();
        for (AdvancedRecipe adv : AdvancedCraftingHandler.getRecipeList()) {
            if (adv.hideFromNEI) continue;
            boolean found = false;
            OreRecipeElement[] inp = adv.recipeItems;
            for (int i = 0; i < inp.length; ++i) {
                OreRecipeElement ore = inp[i];
                if (ore == null || !ore.matches(ingredient)) continue;
                found = true;
                break;
            }
            if (found) {
                this.arecipes.add(new AdvancedCachedRecipe(adv));
            }
            found = false;
            OreRecipeElement[] ores = adv.getNeededMaterials();
            for (int i = 0; i < ores.length; ++i) {
                OreRecipeElement ore = ores[i];
                if (ore == null || !ore.matches(ingredient)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            this.arecipes.add(new AdvancedCachedRecipe(adv));
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiDoubleWorkbench.class;
    }

    public String getGuiTexture() {
        return "betterbeginnings:textures/gui/container/doubleWorkbench.png";
    }

    public String getRecipeName() {
        return I18n.func_135052_a((String)"container.craftingdouble", (Object[])new Object[0]);
    }

    public String getOverlayIdentifier() {
        return "doubleworkbench";
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)8, (int)20, (int)5, (int)4, (int)160, (int)75);
    }

    public class AdvancedCachedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack[] inputs;
        PositionedStack[] catalysts;
        PositionedStack output;

        public AdvancedCachedRecipe(AdvancedRecipe rec) {
            super((TemplateRecipeHandler)NEIAdvancedCraftingHandler.this);
            this.inputs = new PositionedStack[9];
            this.output = new PositionedStack((Object)rec.getRecipeOutput(), 132, 51);
            ItemStack[] grid = rec.getThreeByThree();
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    int i = y * 3 + x;
                    if (grid[i] == null) continue;
                    this.inputs[i] = new PositionedStack((Object)grid[i], 38 + x * 18, 33 + y * 18);
                }
            }
            this.catalysts = new PositionedStack[4];
            OreRecipeElement[] side = rec.getNeededMaterials();
            for (int i = 0; i < side.length; ++i) {
                if (side[i] == null) continue;
                this.catalysts[i] = new PositionedStack((Object)side[i].getFirst(), 11, 23 + i * 18);
            }
        }

        public List<PositionedStack> getIngredients() {
            int i;
            ArrayList<PositionedStack> buf = new ArrayList<PositionedStack>();
            for (i = 0; i < this.inputs.length; ++i) {
                if (this.inputs[i] == null) continue;
                buf.add(this.inputs[i]);
            }
            for (i = 0; i < this.catalysts.length; ++i) {
                if (this.catalysts[i] == null) continue;
                buf.add(this.catalysts[i]);
            }
            return this.getCycledIngredients(NEIAdvancedCraftingHandler.this.cycleticks / 48, buf);
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

