/*
 * Decompiled with CFR 0.152.
 */
package net.einsteinsci.betterbeginnings.nei;

import codechicken.nei.ItemList;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.einsteinsci.betterbeginnings.gui.GuiBrickOven;
import net.einsteinsci.betterbeginnings.register.recipe.BrickOvenRecipeHandler;
import net.einsteinsci.betterbeginnings.register.recipe.BrickOvenShapedRecipe;
import net.einsteinsci.betterbeginnings.register.recipe.BrickOvenShapelessRecipe;
import net.einsteinsci.betterbeginnings.register.recipe.IBrickOvenRecipe;
import net.einsteinsci.betterbeginnings.tileentity.TileEntityBrickOven;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class NEIBrickOvenRecipeHandler
extends TemplateRecipeHandler {
    public static ArrayList<FuelPair> afuels;

    public void loadCraftingRecipes(ItemStack result) {
        for (IBrickOvenRecipe ibr : BrickOvenRecipeHandler.getRecipeList()) {
            if (ibr.getRecipeOutput().func_77973_b() != result.func_77973_b() || result.func_77960_j() != Short.MAX_VALUE && ibr.getRecipeOutput().func_77960_j() != result.func_77960_j()) continue;
            this.arecipes.add(new BrickOvenCachedRecipe(ibr));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (IBrickOvenRecipe ibr : BrickOvenRecipeHandler.getRecipeList()) {
            boolean found = false;
            ItemStack[] inp = ibr.getInputs();
            for (int i = 0; i < inp.length; ++i) {
                ItemStack is = inp[i];
                if (is == null || is.func_77973_b() != ingredient.func_77973_b() || is.func_77960_j() != ingredient.func_77960_j() && ingredient.func_77960_j() != Short.MAX_VALUE) continue;
                found = true;
                break;
            }
            if (!found) continue;
            this.arecipes.add(new BrickOvenCachedRecipe(ibr));
        }
    }

    public TemplateRecipeHandler newInstance() {
        if (afuels == null || afuels.isEmpty()) {
            NEIBrickOvenRecipeHandler.findFuels();
        }
        return super.newInstance();
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiBrickOven.class;
    }

    public String getGuiTexture() {
        return "betterbeginnings:textures/gui/container/brickOven.png";
    }

    public String getRecipeName() {
        return I18n.func_135052_a((String)"container.brickoven", (Object[])new Object[0]);
    }

    public String getOverlayIdentifier() {
        return "brickoven";
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(87, 30, 176, 0, 14, 14, 48, 7);
        this.drawProgressBar(84, 9, 176, 14, 24, 16, 48, 0);
    }

    private static Set<Item> excludedFuels() {
        HashSet<Item> efuels = new HashSet<Item>();
        efuels.add(Item.func_150898_a((Block)Blocks.field_150338_P));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150337_Q));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150472_an));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150444_as));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150447_bR));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150357_h));
        return efuels;
    }

    private static void findFuels() {
        afuels = new ArrayList();
        Set<Item> efuels = NEIBrickOvenRecipeHandler.excludedFuels();
        for (ItemStack item : ItemList.items) {
            int burnTime;
            Block block = Block.func_149634_a((Item)item.func_77973_b());
            if (block instanceof BlockDoor || efuels.contains(item.func_77973_b()) || (burnTime = TileEntityBrickOven.getItemBurnTime(item)) <= 0) continue;
            afuels.add(new FuelPair(item.func_77946_l(), burnTime));
        }
    }

    public static class FuelPair {
        public PositionedStack stack;
        public int burnTime;

        public FuelPair(ItemStack ingred, int burnTime) {
            this.stack = new PositionedStack((Object)ingred, 87, 47, false);
            this.burnTime = burnTime;
        }
    }

    public class BrickOvenCachedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack[] inputs;
        PositionedStack output;

        public BrickOvenCachedRecipe(IBrickOvenRecipe ibr) {
            block5: {
                block4: {
                    super((TemplateRecipeHandler)NEIBrickOvenRecipeHandler.this);
                    this.inputs = new PositionedStack[9];
                    if (!(ibr instanceof BrickOvenShapedRecipe)) break block4;
                    BrickOvenShapedRecipe shaped = (BrickOvenShapedRecipe)ibr;
                    this.output = new PositionedStack((Object)shaped.getRecipeOutput(), 119, 10);
                    ItemStack[] grid = shaped.getThreeByThree();
                    for (int y = 0; y < 3; ++y) {
                        for (int x = 0; x < 3; ++x) {
                            int i = y * 3 + x;
                            if (grid[i] == null) continue;
                            this.inputs[i] = new PositionedStack((Object)grid[i], 25 + x * 18, 6 + y * 18);
                        }
                    }
                    break block5;
                }
                if (!(ibr instanceof BrickOvenShapelessRecipe)) break block5;
                BrickOvenShapelessRecipe shapeless = (BrickOvenShapelessRecipe)ibr;
                this.output = new PositionedStack((Object)shapeless.getRecipeOutput(), 119, 10);
                ItemStack[] stacks = shapeless.getInputs();
                for (int y = 0; y < 3; ++y) {
                    for (int x = 0; x < 3; ++x) {
                        int i = y * 3 + x;
                        if (stacks[i] == null) continue;
                        this.inputs[i] = new PositionedStack((Object)stacks[i], 25 + x * 18, 6 + y * 18);
                    }
                }
            }
        }

        public List<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> buf = new ArrayList<PositionedStack>();
            for (int i = 0; i < this.inputs.length; ++i) {
                if (this.inputs[i] == null) continue;
                buf.add(this.inputs[i]);
            }
            return this.getCycledIngredients(NEIBrickOvenRecipeHandler.this.cycleticks / 48, buf);
        }

        public PositionedStack getOtherStack() {
            return NEIBrickOvenRecipeHandler.afuels.get((int)(NEIBrickOvenRecipeHandler.this.cycleticks / 48 % NEIBrickOvenRecipeHandler.afuels.size())).stack;
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

