/*
 * Decompiled with CFR 0.152.
 */
package net.einsteinsci.betterbeginnings.nei;

import codechicken.nei.ItemList;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.einsteinsci.betterbeginnings.gui.GuiCampfire;
import net.einsteinsci.betterbeginnings.register.RegisterItems;
import net.einsteinsci.betterbeginnings.register.recipe.CampfirePanRecipes;
import net.einsteinsci.betterbeginnings.register.recipe.CampfireRecipes;
import net.einsteinsci.betterbeginnings.tileentity.TileEntityCampfire;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import scala.actors.threadpool.Arrays;

public class NEICampfireRecipeHandler
extends TemplateRecipeHandler {
    public static ArrayList<FuelPair> afuels;

    public TemplateRecipeHandler newInstance() {
        if (afuels == null || afuels.isEmpty()) {
            NEICampfireRecipeHandler.findFuels();
        }
        return super.newInstance();
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCampfire.class;
    }

    public String getGuiTexture() {
        return "betterbeginnings:textures/gui/container/campfire.png";
    }

    public String getRecipeName() {
        return I18n.func_135052_a((String)"container.campfire", (Object[])new Object[0]);
    }

    public void loadCraftingRecipes(ItemStack result) {
        ItemStack outp;
        ItemStack inp;
        Map.Entry entry;
        Map.Entry obj;
        Iterator i$ = CampfireRecipes.getSmeltingList().entrySet().iterator();
        while (i$.hasNext()) {
            entry = obj = i$.next();
            inp = (ItemStack)entry.getKey();
            outp = (ItemStack)entry.getValue();
            if (outp.func_77973_b() != result.func_77973_b() || result.func_77960_j() != Short.MAX_VALUE && outp.func_77960_j() != result.func_77960_j()) continue;
            this.arecipes.add(new CampfireCachedRecipe(inp, outp, false));
        }
        i$ = CampfirePanRecipes.getSmeltingList().entrySet().iterator();
        while (i$.hasNext()) {
            entry = obj = i$.next();
            inp = (ItemStack)entry.getKey();
            outp = (ItemStack)entry.getValue();
            if (outp.func_77973_b() != result.func_77973_b() || result.func_77960_j() != Short.MAX_VALUE && outp.func_77960_j() != result.func_77960_j()) continue;
            this.arecipes.add(new CampfireCachedRecipe(inp, outp, true));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        ItemStack outp;
        ItemStack inp;
        Map.Entry entry;
        Map.Entry obj;
        Iterator i$ = CampfireRecipes.getSmeltingList().entrySet().iterator();
        while (i$.hasNext()) {
            entry = obj = i$.next();
            inp = (ItemStack)entry.getKey();
            outp = (ItemStack)entry.getValue();
            if (inp.func_77973_b() != ingredient.func_77973_b() || inp.func_77960_j() != Short.MAX_VALUE && inp.func_77960_j() != ingredient.func_77960_j()) continue;
            this.arecipes.add(new CampfireCachedRecipe(inp, outp, false));
        }
        i$ = CampfirePanRecipes.getSmeltingList().entrySet().iterator();
        while (i$.hasNext()) {
            entry = obj = i$.next();
            inp = (ItemStack)entry.getKey();
            outp = (ItemStack)entry.getValue();
            if (inp.func_77973_b() != ingredient.func_77973_b() || inp.func_77960_j() != Short.MAX_VALUE && inp.func_77960_j() != ingredient.func_77960_j()) continue;
            this.arecipes.add(new CampfireCachedRecipe(inp, outp, true));
        }
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(53, 21, 176, 0, 14, 22, 48, 7);
        this.drawProgressBar(76, 22, 176, 22, 24, 16, 48, 0);
        this.drawProgressBar(72, 46, 176, 39, 3, 16, 48, 7);
    }

    public String getOverlayIdentifier() {
        return "campfire";
    }

    private static Set<Item> excludedFuels() {
        HashSet<Item> efuels = new HashSet<Item>();
        efuels.add(Item.func_150898_a((Block)Blocks.field_150338_P));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150337_Q));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150472_an));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150444_as));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150447_bR));
        return efuels;
    }

    private static void findFuels() {
        afuels = new ArrayList();
        Set<Item> efuels = NEICampfireRecipeHandler.excludedFuels();
        for (ItemStack item : ItemList.items) {
            int burnTime;
            Block block = Block.func_149634_a((Item)item.func_77973_b());
            if (block instanceof BlockDoor || efuels.contains(item.func_77973_b()) || (burnTime = TileEntityCampfire.getBurnTimeForFuel(item)) <= 0) continue;
            afuels.add(new FuelPair(item.func_77946_l(), burnTime));
        }
    }

    public static class FuelPair {
        public PositionedStack stack;
        public int burnTime;

        public FuelPair(ItemStack ingred, int burnTime) {
            this.stack = new PositionedStack((Object)ingred, 53, 46, false);
            this.burnTime = burnTime;
        }
    }

    public class CampfireCachedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack output;
        PositionedStack pan;

        public CampfireCachedRecipe(ItemStack _input, ItemStack _output, boolean _pan) {
            super((TemplateRecipeHandler)NEICampfireRecipeHandler.this);
            this.input = new PositionedStack((Object)_input, 53, 1);
            this.output = new PositionedStack((Object)_output, 113, 23);
            if (_pan) {
                this.pan = new PositionedStack((Object)new ItemStack(RegisterItems.pan), 27, 24);
            }
        }

        public List<PositionedStack> getIngredients() {
            if (this.pan != null) {
                return this.getCycledIngredients(NEICampfireRecipeHandler.this.cycleticks / 48, Arrays.asList((Object[])new Object[]{this.input, this.pan}));
            }
            return this.getCycledIngredients(NEICampfireRecipeHandler.this.cycleticks / 48, Collections.singletonList(this.input));
        }

        public PositionedStack getOtherStack() {
            return NEICampfireRecipeHandler.afuels.get((int)(NEICampfireRecipeHandler.this.cycleticks / 48 % NEICampfireRecipeHandler.afuels.size())).stack;
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

