/*
 * Decompiled with CFR 0.152.
 */
package net.einsteinsci.betterbeginnings.nei;

import codechicken.nei.ItemList;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.FurnaceRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.einsteinsci.betterbeginnings.gui.GuiKiln;
import net.einsteinsci.betterbeginnings.register.recipe.KilnRecipes;
import net.einsteinsci.betterbeginnings.tileentity.TileEntityKiln;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class NEIKilnRecipeHandler
extends TemplateRecipeHandler {
    public static ArrayList<FurnaceRecipeHandler.FuelPair> afuels;

    public TemplateRecipeHandler newInstance() {
        if (afuels == null || afuels.isEmpty()) {
            NEIKilnRecipeHandler.findFuels();
        }
        return super.newInstance();
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiKiln.class;
    }

    public String getGuiTexture() {
        return "minecraft:textures/gui/container/furnace.png";
    }

    public String getRecipeName() {
        return I18n.func_135052_a((String)"container.kiln", (Object[])new Object[0]);
    }

    public void loadCraftingRecipes(ItemStack result) {
        Iterator i$ = KilnRecipes.getSmeltingList().entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry obj;
            Map.Entry entry = obj = i$.next();
            ItemStack inp = (ItemStack)entry.getKey();
            ItemStack outp = (ItemStack)entry.getValue();
            if (outp.func_77973_b() != result.func_77973_b() || result.func_77960_j() != Short.MAX_VALUE && outp.func_77960_j() != result.func_77960_j()) continue;
            this.arecipes.add(new KilnCachedRecipe(inp, outp));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Iterator i$ = KilnRecipes.getSmeltingList().entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry obj;
            Map.Entry entry = obj = i$.next();
            ItemStack inp = (ItemStack)entry.getKey();
            ItemStack outp = (ItemStack)entry.getValue();
            if (inp.func_77973_b() != ingredient.func_77973_b() || inp.func_77960_j() != Short.MAX_VALUE && inp.func_77960_j() != ingredient.func_77960_j()) continue;
            this.arecipes.add(new KilnCachedRecipe(inp, outp));
        }
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(51, 25, 176, 0, 14, 14, 48, 7);
        this.drawProgressBar(74, 23, 176, 14, 24, 16, 48, 0);
    }

    public String getOverlayIdentifier() {
        return "kiln";
    }

    private static Set<Item> excludedFuels() {
        HashSet<Item> efuels = new HashSet<Item>();
        efuels.add(Item.func_150898_a((Block)Blocks.field_150338_P));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150337_Q));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150472_an));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150444_as));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150447_bR));
        return efuels;
    }

    private static void findFuels() {
        afuels = new ArrayList();
        Set<Item> efuels = NEIKilnRecipeHandler.excludedFuels();
        for (ItemStack item : ItemList.items) {
            int burnTime;
            Block block = Block.func_149634_a((Item)item.func_77973_b());
            if (block instanceof BlockDoor || efuels.contains(item.func_77973_b()) || (burnTime = TileEntityKiln.getItemBurnTime(item)) <= 0) continue;
            afuels.add(new FurnaceRecipeHandler.FuelPair(item.func_77946_l(), burnTime));
        }
    }

    public class KilnCachedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack output;

        public KilnCachedRecipe(ItemStack _input, ItemStack _output) {
            super((TemplateRecipeHandler)NEIKilnRecipeHandler.this);
            this.input = new PositionedStack((Object)_input, 51, 6);
            this.output = new PositionedStack((Object)_output, 111, 24);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIKilnRecipeHandler.this.cycleticks / 48, Collections.singletonList(this.input));
        }

        public PositionedStack getOtherStack() {
            return NEIKilnRecipeHandler.afuels.get((int)(NEIKilnRecipeHandler.this.cycleticks / 48 % NEIKilnRecipeHandler.afuels.size())).stack;
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

