/*
 * Decompiled with CFR 0.152.
 */
package net.einsteinsci.betterbeginnings.nei;

import codechicken.nei.ItemList;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.FurnaceRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.einsteinsci.betterbeginnings.gui.GuiSmelter;
import net.einsteinsci.betterbeginnings.register.recipe.SmelterRecipe;
import net.einsteinsci.betterbeginnings.register.recipe.SmelterRecipeHandler;
import net.einsteinsci.betterbeginnings.tileentity.TileEntitySmelter;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class NEISmelterRecipeHandler
extends TemplateRecipeHandler {
    public static ArrayList<FurnaceRecipeHandler.FuelPair> afuels;

    public TemplateRecipeHandler newInstance() {
        if (afuels == null || afuels.isEmpty()) {
            NEISmelterRecipeHandler.findFuels();
        }
        return super.newInstance();
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiSmelter.class;
    }

    public String getGuiTexture() {
        return "betterbeginnings:textures/gui/container/smelter.png";
    }

    public String getRecipeName() {
        return I18n.func_135052_a((String)"container.smelter", (Object[])new Object[0]);
    }

    public String getOverlayIdentifier() {
        return "smelter";
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (SmelterRecipe sr : SmelterRecipeHandler.getRecipes()) {
            if (sr.getOutput().func_77973_b() != result.func_77973_b() || result.func_77960_j() != Short.MAX_VALUE && sr.getOutput().func_77960_j() != result.func_77960_j()) continue;
            this.arecipes.add(new SmelterCachedRecipe(sr));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (ingredient.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150351_n)) {
            for (SmelterRecipe sr : SmelterRecipeHandler.getRecipes()) {
                this.arecipes.add(new SmelterCachedRecipe(sr));
            }
        } else {
            for (SmelterRecipe sr : SmelterRecipeHandler.getRecipes()) {
                if (sr.getInput().func_77973_b() != ingredient.func_77973_b() || sr.getInput().func_77960_j() != Short.MAX_VALUE && sr.getInput().func_77960_j() != ingredient.func_77960_j()) continue;
                this.arecipes.add(new SmelterCachedRecipe(sr));
            }
        }
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(51, 25, 176, 0, 14, 14, 48, 7);
        this.drawProgressBar(74, 23, 176, 14, 24, 16, 48, 0);
    }

    private static Set<Item> excludedFuels() {
        HashSet<Item> efuels = new HashSet<Item>();
        efuels.add(Item.func_150898_a((Block)Blocks.field_150338_P));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150337_Q));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150472_an));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150444_as));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150447_bR));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150357_h));
        return efuels;
    }

    private static void findFuels() {
        afuels = new ArrayList();
        Set<Item> efuels = NEISmelterRecipeHandler.excludedFuels();
        for (ItemStack item : ItemList.items) {
            int burnTime;
            Block block = Block.func_149634_a((Item)item.func_77973_b());
            if (block instanceof BlockDoor || efuels.contains(item.func_77973_b()) || (burnTime = TileEntitySmelter.getItemBurnTime(item)) <= 0) continue;
            afuels.add(new FurnaceRecipeHandler.FuelPair(item.func_77946_l(), burnTime));
        }
    }

    public class SmelterCachedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack output;
        PositionedStack gravel;

        public SmelterCachedRecipe(ItemStack _input, ItemStack _output, int _gravel) {
            super((TemplateRecipeHandler)NEISmelterRecipeHandler.this);
            this.input = new PositionedStack((Object)_input, 41, 6);
            this.output = new PositionedStack((Object)_output, 111, 24);
            this.gravel = new PositionedStack((Object)new ItemStack(Blocks.field_150351_n, _gravel), 61, 6);
        }

        public SmelterCachedRecipe(SmelterRecipe sr) {
            this(sr.getInput(), sr.getOutput(), sr.getGravel());
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEISmelterRecipeHandler.this.cycleticks / 48, Arrays.asList(this.input, this.gravel));
        }

        public PositionedStack getOtherStack() {
            return NEISmelterRecipeHandler.afuels.get((int)(NEISmelterRecipeHandler.this.cycleticks / 48 % NEISmelterRecipeHandler.afuels.size())).stack;
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

