/*
 * Decompiled with CFR 0.152.
 */
package net.einsteinsci.betterbeginnings.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.einsteinsci.betterbeginnings.ModMain;
import net.einsteinsci.betterbeginnings.tileentity.TileEntityNetherBrickOven;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class PacketNetherBrickOvenFuelLevel
implements IMessage {
    int xPos;
    int yPos;
    int zPos;
    FluidStack fluid;

    public PacketNetherBrickOvenFuelLevel() {
        this.xPos = 0;
        this.yPos = 0;
        this.zPos = 0;
        this.fluid = null;
    }

    public PacketNetherBrickOvenFuelLevel(int x, int y, int z, FluidStack fuel) {
        this.xPos = x;
        this.yPos = y;
        this.zPos = z;
        this.fluid = fuel;
    }

    public void fromBytes(ByteBuf buf) {
        this.xPos = buf.readInt();
        this.yPos = buf.readInt();
        this.zPos = buf.readInt();
        int fluidId = buf.readInt();
        int level = buf.readInt();
        this.fluid = level != 0 ? new FluidStack(FluidRegistry.getFluid((int)fluidId), level) : null;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.xPos);
        buf.writeInt(this.yPos);
        buf.writeInt(this.zPos);
        if (this.fluid != null) {
            buf.writeInt(this.fluid.getFluidID());
            buf.writeInt(this.fluid.amount);
        } else {
            buf.writeInt(0);
            buf.writeInt(0);
        }
    }

    public static class PacketHandler
    implements IMessageHandler<PacketNetherBrickOvenFuelLevel, IMessage> {
        public IMessage onMessage(PacketNetherBrickOvenFuelLevel message, MessageContext ctx) {
            EntityPlayer player = ModMain.proxy.getPlayerFromMessageContext(ctx);
            TileEntityNetherBrickOven oven = (TileEntityNetherBrickOven)player.field_70170_p.func_147438_o(message.xPos, message.yPos, message.zPos);
            oven.setFuelLevel(message.fluid);
            return null;
        }
    }
}

