/*
 * Decompiled with CFR 0.152.
 */
package net.einsteinsci.betterbeginnings.register;

import java.util.ArrayList;
import net.einsteinsci.betterbeginnings.inventory.InventoryInfusionRepair;
import net.einsteinsci.betterbeginnings.items.ItemBBCloth;
import net.einsteinsci.betterbeginnings.register.RegisterItems;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBook;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InfusionRepairUtil {
    public static boolean canRepair(InventoryInfusionRepair repairTable, EntityPlayer player) {
        boolean playerReady = player.field_71068_ca >= InfusionRepairUtil.getNeededLevels(repairTable) || player.field_71075_bZ.field_75098_d;
        return InfusionRepairUtil.canRepairIgnoreXp(repairTable) && playerReady;
    }

    public static boolean isDiffusionMode(InventoryInfusionRepair repair) {
        if (repair.func_70301_a(0) == null) {
            return false;
        }
        return repair.func_70301_a(0).func_77973_b() instanceof ItemBBCloth;
    }

    public static ItemStack getDiffusionTool(InventoryInfusionRepair repair) {
        for (int i = 1; i < repair.func_70302_i_(); ++i) {
            ItemStack stack = repair.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ItemTool) && !(stack.func_77973_b() instanceof ItemSword) && !(stack.func_77973_b() instanceof ItemArmor) || stack.func_77986_q() == null) continue;
            return stack;
        }
        return null;
    }

    public static boolean isDiffusionReady(InventoryInfusionRepair repair) {
        if (!InfusionRepairUtil.isDiffusionMode(repair)) {
            return false;
        }
        ItemStack tool = InfusionRepairUtil.getDiffusionTool(repair);
        if (tool == null) {
            return false;
        }
        for (int i = 1; i < repair.func_70302_i_(); ++i) {
            ItemStack stack = repair.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ItemBook)) continue;
            return true;
        }
        return false;
    }

    public static boolean canRepairIgnoreXp(InventoryInfusionRepair repairTable) {
        ArrayList<ItemStack> requiredItems = InfusionRepairUtil.getRequiredStacks(repairTable);
        if (repairTable.func_70301_a(0) == null) {
            return false;
        }
        if (!repairTable.func_70301_a(0).func_77984_f()) {
            return false;
        }
        for (ItemStack needed : requiredItems) {
            boolean foundIt = false;
            for (int j = 1; j < repairTable.func_70302_i_(); ++j) {
                ItemStack tested;
                if (repairTable.func_70301_a(j) == null || (tested = repairTable.func_70301_a(j)).func_77973_b() != needed.func_77973_b() || tested.func_77960_j() != needed.func_77960_j() && needed.func_77960_j() != Short.MAX_VALUE || tested.field_77994_a < needed.field_77994_a) continue;
                foundIt = true;
                break;
            }
            if (foundIt) continue;
            return false;
        }
        return true;
    }

    public static int getNeededLevels(InventoryInfusionRepair repairTable) {
        ItemStack infusedItem = repairTable.func_70301_a(0);
        if (infusedItem == null) {
            return 0;
        }
        if (infusedItem.func_77973_b() instanceof ItemBow) {
            return 10;
        }
        if (infusedItem.func_77973_b() == RegisterItems.noobWoodSword) {
            return 1;
        }
        if (infusedItem.func_77973_b() == RegisterItems.flintKnife || infusedItem.func_77973_b() == RegisterItems.flintHatchet) {
            return 1;
        }
        if (infusedItem.func_77973_b() == RegisterItems.boneKnife) {
            return 5;
        }
        if (infusedItem.func_77973_b() == RegisterItems.bonePickaxe) {
            return 1;
        }
        if (infusedItem.func_77973_b() instanceof ItemTool) {
            ItemTool tool = (ItemTool)infusedItem.func_77973_b();
            Item.ToolMaterial material = Item.ToolMaterial.valueOf((String)tool.func_77861_e());
            switch (material) {
                case WOOD: {
                    return 1;
                }
                case STONE: {
                    return 5;
                }
                case IRON: {
                    return 10;
                }
                case GOLD: {
                    return 20;
                }
                case EMERALD: {
                    return 20;
                }
            }
            return 20;
        }
        if (infusedItem.func_77973_b() instanceof ItemSword) {
            ItemSword sword = (ItemSword)infusedItem.func_77973_b();
            Item.ToolMaterial material = Item.ToolMaterial.valueOf((String)sword.func_150932_j());
            switch (material) {
                case WOOD: {
                    return 1;
                }
                case STONE: {
                    return 5;
                }
                case IRON: {
                    return 10;
                }
                case GOLD: {
                    return 20;
                }
                case EMERALD: {
                    return 20;
                }
            }
            if (material == RegisterItems.noobWood) {
                return 1;
            }
            return 20;
        }
        if (infusedItem.func_77973_b() instanceof ItemArmor) {
            ItemArmor armor = (ItemArmor)infusedItem.func_77973_b();
            switch (armor.func_82812_d()) {
                case CLOTH: {
                    return 1;
                }
                case CHAIN: {
                    return 5;
                }
                case IRON: {
                    return 10;
                }
                case GOLD: {
                    return 20;
                }
                case DIAMOND: {
                    return 20;
                }
            }
            return 20;
        }
        if (infusedItem.func_77973_b() == Items.field_151097_aZ) {
            return 5;
        }
        if (infusedItem.func_77973_b() == Items.field_151112_aM) {
            return 5;
        }
        if (infusedItem.func_77973_b() == Items.field_151033_d) {
            return 1;
        }
        return 0;
    }

    public static ArrayList<ItemStack> getRequiredStacks(InventoryInfusionRepair repairTable) {
        Item.ToolMaterial material;
        ArrayList<ItemStack> requiredItems = new ArrayList<ItemStack>();
        ItemStack repaired = repairTable.func_70301_a(0);
        if (repaired == null) {
            return requiredItems;
        }
        if (!repaired.func_77951_h()) {
            return requiredItems;
        }
        if (repaired.func_77973_b() instanceof ItemBow) {
            requiredItems.add(new ItemStack(Items.field_151055_y, 2));
            requiredItems.add(new ItemStack(Items.field_151007_F, 2));
        }
        if (repaired.func_77973_b() == RegisterItems.noobWoodSword) {
            requiredItems.add(new ItemStack(Blocks.field_150344_f, 1, Short.MAX_VALUE));
        } else if (repaired.func_77973_b() == RegisterItems.flintKnife || repaired.func_77973_b() == RegisterItems.flintHatchet) {
            requiredItems.add(new ItemStack(Items.field_151145_ak));
        } else if (repaired.func_77973_b() == RegisterItems.boneKnife) {
            requiredItems.add(new ItemStack(Items.field_151103_aS));
        } else if (repaired.func_77973_b() == RegisterItems.bonePickaxe) {
            requiredItems.add(new ItemStack(RegisterItems.boneShard));
        } else if (repaired.func_77973_b() instanceof ItemTool) {
            ItemTool tool = (ItemTool)repaired.func_77973_b();
            material = Item.ToolMaterial.valueOf((String)tool.func_77861_e());
            switch (material) {
                case WOOD: {
                    requiredItems.add(new ItemStack(Blocks.field_150344_f, 1, Short.MAX_VALUE));
                    break;
                }
                case STONE: {
                    requiredItems.add(new ItemStack(Blocks.field_150348_b, 1));
                    break;
                }
                case IRON: {
                    requiredItems.add(new ItemStack(Items.field_151042_j));
                    break;
                }
                case GOLD: {
                    requiredItems.add(new ItemStack(Items.field_151074_bl, 2));
                    break;
                }
                case EMERALD: {
                    requiredItems.add(new ItemStack(Items.field_151137_ax, 24));
                    break;
                }
                default: {
                    requiredItems.add(new ItemStack(Items.field_151166_bC, 4));
                    break;
                }
            }
        } else if (repaired.func_77973_b() instanceof ItemSword) {
            ItemSword sword = (ItemSword)repaired.func_77973_b();
            material = Item.ToolMaterial.valueOf((String)sword.func_150932_j());
            switch (material) {
                case WOOD: {
                    requiredItems.add(new ItemStack(Blocks.field_150344_f, 1, Short.MAX_VALUE));
                    break;
                }
                case STONE: {
                    requiredItems.add(new ItemStack(Blocks.field_150348_b, 1));
                }
                case IRON: {
                    requiredItems.add(new ItemStack(Items.field_151042_j));
                    break;
                }
                case GOLD: {
                    requiredItems.add(new ItemStack(Items.field_151074_bl, 2));
                    break;
                }
                case EMERALD: {
                    requiredItems.add(new ItemStack(Items.field_151137_ax, 16));
                    break;
                }
                default: {
                    if (material == RegisterItems.noobWood) {
                        requiredItems.add(new ItemStack(Blocks.field_150344_f, 1, Short.MAX_VALUE));
                        break;
                    }
                    requiredItems.add(new ItemStack(Items.field_151166_bC, 4));
                    break;
                }
            }
        } else if (repaired.func_77973_b() instanceof ItemArmor) {
            ItemArmor armor = (ItemArmor)repaired.func_77973_b();
            switch (armor.func_82812_d()) {
                case CLOTH: {
                    requiredItems.add(new ItemStack(Items.field_151116_aA));
                    break;
                }
                case CHAIN: {
                    requiredItems.add(new ItemStack(RegisterItems.ironNugget));
                    break;
                }
                case IRON: {
                    requiredItems.add(new ItemStack(Items.field_151042_j));
                }
                case GOLD: {
                    requiredItems.add(new ItemStack(Items.field_151074_bl, 2));
                }
                case DIAMOND: {
                    requiredItems.add(new ItemStack(Items.field_151137_ax, 24));
                }
                default: {
                    requiredItems.add(new ItemStack(Items.field_151166_bC, 4));
                    break;
                }
            }
        } else if (repaired.func_77973_b() == Items.field_151097_aZ) {
            requiredItems.add(new ItemStack(Items.field_151042_j));
        } else if (repaired.func_77973_b() == Items.field_151112_aM) {
            requiredItems.add(new ItemStack(Items.field_151007_F, 4));
        } else if (repaired.func_77973_b() == Items.field_151033_d) {
            requiredItems.add(new ItemStack(Items.field_151145_ak));
        }
        if (repaired.func_77948_v() && repaired.field_77990_d != null && repaired.field_77990_d.func_74781_a("ench") != null) {
            NBTTagList enchants = (NBTTagList)repaired.field_77990_d.func_74781_a("ench");
            block48: for (int i = 0; i < enchants.func_74745_c(); ++i) {
                NBTTagCompound enchant = enchants.func_150305_b(i);
                int enchId = enchant.func_74762_e("id");
                int level = enchant.func_74762_e("lvl");
                switch (enchId) {
                    case 0: {
                        requiredItems.add(new ItemStack(Blocks.field_150411_aY, 2 * level));
                        continue block48;
                    }
                    case 1: {
                        requiredItems.add(new ItemStack(Items.field_151133_ar, level));
                        continue block48;
                    }
                    case 2: {
                        requiredItems.add(new ItemStack(Items.field_151008_G, 2 * level));
                        continue block48;
                    }
                    case 3: {
                        requiredItems.add(new ItemStack(Blocks.field_150347_e, 8 * level));
                        continue block48;
                    }
                    case 4: {
                        requiredItems.add(new ItemStack(Items.field_151126_ay, 4 * level));
                        continue block48;
                    }
                    case 5: {
                        requiredItems.add(new ItemStack(Items.field_151069_bo, level));
                        continue block48;
                    }
                    case 6: {
                        requiredItems.add(new ItemStack(Blocks.field_150435_aG, level));
                        continue block48;
                    }
                    case 7: {
                        requiredItems.add(new ItemStack(Blocks.field_150434_aF, 4 * level));
                        continue block48;
                    }
                    case 8: {
                        continue block48;
                    }
                    case 16: {
                        requiredItems.add(new ItemStack(Items.field_151128_bU, 4 * level));
                        continue block48;
                    }
                    case 17: {
                        requiredItems.add(new ItemStack(Blocks.field_150425_aM, 2 * level));
                        continue block48;
                    }
                    case 18: {
                        requiredItems.add(new ItemStack(Items.field_151071_bq, level));
                        continue block48;
                    }
                    case 19: {
                        requiredItems.add(new ItemStack((Block)Blocks.field_150331_J, level));
                        continue block48;
                    }
                    case 20: {
                        requiredItems.add(new ItemStack(Items.field_151065_br, 2 * level));
                        continue block48;
                    }
                    case 21: {
                        requiredItems.add(new ItemStack(Items.field_151043_k, 2 * level));
                        continue block48;
                    }
                    case 32: {
                        requiredItems.add(new ItemStack(Items.field_151102_aT, 4 * level));
                        continue block48;
                    }
                    case 33: {
                        requiredItems.add(new ItemStack(RegisterItems.cloth, 8 * level));
                        continue block48;
                    }
                    case 34: {
                        requiredItems.add(new ItemStack(Blocks.field_150343_Z, level));
                        continue block48;
                    }
                    case 35: {
                        requiredItems.add(new ItemStack(Items.field_151100_aR, 4 * level, 4));
                        continue block48;
                    }
                    case 48: {
                        requiredItems.add(new ItemStack(RegisterItems.leatherStrip, level));
                        continue block48;
                    }
                    case 49: {
                        requiredItems.add(new ItemStack(Items.field_151016_H, level));
                        continue block48;
                    }
                    case 50: {
                        requiredItems.add(new ItemStack(Items.field_151059_bz, level));
                        continue block48;
                    }
                    case 51: {
                        requiredItems.add(new ItemStack(Items.field_151032_g, 16 * level));
                        continue block48;
                    }
                    case 61: {
                        requiredItems.add(new ItemStack(Blocks.field_150392_bi, level));
                        continue block48;
                    }
                    case 62: {
                        requiredItems.add(new ItemStack(Items.field_151115_aP, level, 3));
                    }
                }
            }
        }
        return requiredItems;
    }

    public static int getTakenLevels(InventoryInfusionRepair repairTable) {
        ItemStack infusedItem = repairTable.func_70301_a(0);
        if (infusedItem == null) {
            return 0;
        }
        if (infusedItem.func_77973_b() == RegisterItems.noobWoodSword) {
            return 1;
        }
        if (infusedItem.func_77973_b() == RegisterItems.flintKnife || infusedItem.func_77973_b() == RegisterItems.flintHatchet) {
            return 1;
        }
        if (infusedItem.func_77973_b() == RegisterItems.boneKnife) {
            return 2;
        }
        if (infusedItem.func_77973_b() == RegisterItems.bonePickaxe) {
            return 1;
        }
        if (infusedItem.func_77973_b() instanceof ItemTool) {
            ItemTool tool = (ItemTool)infusedItem.func_77973_b();
            Item.ToolMaterial material = Item.ToolMaterial.valueOf((String)tool.func_77861_e());
            switch (material) {
                case WOOD: {
                    return 1;
                }
                case STONE: {
                    return 5;
                }
                case IRON: {
                    return 5;
                }
                case GOLD: {
                    return 3;
                }
                case EMERALD: {
                    return 8;
                }
            }
            return 8;
        }
        if (infusedItem.func_77973_b() instanceof ItemSword) {
            ItemSword sword = (ItemSword)infusedItem.func_77973_b();
            Item.ToolMaterial material = Item.ToolMaterial.valueOf((String)sword.func_150932_j());
            switch (material) {
                case WOOD: {
                    return 1;
                }
                case STONE: {
                    return 2;
                }
                case IRON: {
                    return 5;
                }
                case GOLD: {
                    return 3;
                }
                case EMERALD: {
                    return 8;
                }
            }
            if (material == RegisterItems.noobWood) {
                return 1;
            }
            return 8;
        }
        if (infusedItem.func_77973_b() instanceof ItemArmor) {
            ItemArmor armor = (ItemArmor)infusedItem.func_77973_b();
            switch (armor.func_82812_d()) {
                case CLOTH: {
                    return 1;
                }
                case CHAIN: {
                    return 2;
                }
                case IRON: {
                    return 5;
                }
                case GOLD: {
                    return 3;
                }
                case DIAMOND: {
                    return 8;
                }
            }
            return 8;
        }
        if (infusedItem.func_77973_b() == Items.field_151097_aZ) {
            return 2;
        }
        if (infusedItem.func_77973_b() == Items.field_151112_aM) {
            return 2;
        }
        if (infusedItem.func_77973_b() == Items.field_151033_d) {
            return 1;
        }
        return 0;
    }
}

