/*
 * Decompiled with CFR 0.152.
 */
package net.einsteinsci.betterbeginnings.register.recipe;

import net.einsteinsci.betterbeginnings.inventory.InventoryWorkbenchAdditionalMaterials;
import net.einsteinsci.betterbeginnings.register.recipe.OreRecipeElement;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class AdvancedRecipe {
    public final int recipeWidth;
    public final int recipeHeight;
    public final OreRecipeElement[] recipeItems;
    private ItemStack recipeOutput;
    private OreRecipeElement[] addedMaterials;
    private boolean strangeFlag;
    public final boolean hideFromNEI;

    public AdvancedRecipe(int width, int height, OreRecipeElement[] items, ItemStack output, OreRecipeElement[] materials, boolean hide) {
        this.recipeWidth = width;
        this.recipeHeight = height;
        this.recipeItems = items;
        this.recipeOutput = output;
        this.addedMaterials = materials;
        this.hideFromNEI = hide;
    }

    public boolean matches(InventoryCrafting invCrafting, InventoryWorkbenchAdditionalMaterials materials, World world) {
        for (int i = 0; i <= 3 - this.recipeWidth; ++i) {
            for (int j = 0; j <= 3 - this.recipeHeight; ++j) {
                if (this.checkMatch(invCrafting, materials, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(invCrafting, materials, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting crafting, InventoryWorkbenchAdditionalMaterials materials, int width, int height, boolean flag4) {
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 3; ++l) {
                ItemStack craftingStackInQuestion;
                int i1 = k - width;
                int j1 = l - height;
                OreRecipeElement neededCraftingStack = null;
                if (i1 >= 0 && j1 >= 0 && i1 < this.recipeWidth && j1 < this.recipeHeight) {
                    neededCraftingStack = flag4 ? this.recipeItems[this.recipeWidth - i1 - 1 + j1 * this.recipeWidth] : this.recipeItems[i1 + j1 * this.recipeWidth];
                }
                if ((craftingStackInQuestion = crafting.func_70463_b(k, l)) != null || neededCraftingStack != null) {
                    if (craftingStackInQuestion == null && neededCraftingStack != null || craftingStackInQuestion != null && neededCraftingStack == null) {
                        return false;
                    }
                    if (!neededCraftingStack.matches(craftingStackInQuestion)) {
                        return false;
                    }
                }
                for (OreRecipeElement requiredMatStack : this.addedMaterials) {
                    boolean foundIt = false;
                    for (int i2 = 0; i2 < materials.func_70302_i_(); ++i2) {
                        ItemStack testedMatStack = materials.func_70301_a(i2);
                        if (testedMatStack != null) {
                            foundIt = requiredMatStack.matchesCheckSize(testedMatStack);
                        }
                        if (foundIt) break;
                    }
                    if (foundIt) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean matchesMostly(InventoryCrafting invCrafting, World world) {
        for (int i = 0; i <= 3 - this.recipeWidth; ++i) {
            for (int j = 0; j <= 3 - this.recipeHeight; ++j) {
                if (this.checkMatchMostly(invCrafting, i, j, true)) {
                    return true;
                }
                if (!this.checkMatchMostly(invCrafting, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkMatchMostly(InventoryCrafting crafting, int width, int height, boolean flag4) {
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 3; ++l) {
                ItemStack craftingStackInQuestion;
                int i1 = k - width;
                int j1 = l - height;
                OreRecipeElement neededCraftingStack = null;
                if (i1 >= 0 && j1 >= 0 && i1 < this.recipeWidth && j1 < this.recipeHeight) {
                    neededCraftingStack = flag4 ? this.recipeItems[this.recipeWidth - i1 - 1 + j1 * this.recipeWidth] : this.recipeItems[i1 + j1 * this.recipeWidth];
                }
                if ((craftingStackInQuestion = crafting.func_70463_b(k, l)) == null && neededCraftingStack == null) continue;
                if (craftingStackInQuestion == null || neededCraftingStack == null) {
                    return false;
                }
                if (neededCraftingStack.matches(craftingStackInQuestion)) continue;
                return false;
            }
        }
        return true;
    }

    public int getNeededMaterialCount(Item material) {
        for (OreRecipeElement stack : this.addedMaterials) {
            if (!stack.matches(new ItemStack(material))) continue;
            return stack.stackSize;
        }
        return 0;
    }

    public OreRecipeElement[] getNeededMaterials() {
        return this.addedMaterials;
    }

    public ItemStack getCraftingResult(InventoryCrafting crafting) {
        ItemStack itemstack = this.getRecipeOutput().func_77946_l();
        if (this.strangeFlag) {
            for (int i = 0; i < crafting.func_70302_i_(); ++i) {
                ItemStack itemstack1 = crafting.func_70301_a(i);
                if (itemstack1 == null || !itemstack1.func_77942_o()) continue;
                itemstack.func_77982_d((NBTTagCompound)itemstack1.field_77990_d.func_74737_b());
            }
        }
        return itemstack;
    }

    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    public int getRecipeSize() {
        return this.recipeWidth * this.recipeHeight;
    }

    public ItemStack[] getThreeByThree() {
        ItemStack[] res = new ItemStack[9];
        int y = 0;
        int x = 0;
        int v = 0;
        int u = 0;
        for (int i = 0; i < this.getRecipeSize(); ++i) {
            OreRecipeElement ore = this.recipeItems[u + v * this.recipeWidth];
            if (ore != null) {
                res[x + y * 3] = ore.getFirst();
            }
            if (++u >= this.recipeWidth) {
                u = 0;
            }
            x = u;
            y = ++v;
        }
        return res;
    }

    public AdvancedRecipe func_92100_c() {
        this.strangeFlag = true;
        return this;
    }

    public boolean hasMaterial(ItemStack stack) {
        for (OreRecipeElement s : this.addedMaterials) {
            if (!s.matches(stack)) continue;
            return true;
        }
        return false;
    }
}

