/*
 * Decompiled with CFR 0.152.
 */
package net.einsteinsci.betterbeginnings.register.recipe;

import java.util.ArrayList;
import net.einsteinsci.betterbeginnings.register.recipe.IBrickOvenRecipe;
import net.einsteinsci.betterbeginnings.tileentity.TileEntityBrickOven;
import net.einsteinsci.betterbeginnings.tileentity.TileEntityNetherBrickOven;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class BrickOvenShapedRecipe
implements IBrickOvenRecipe {
    public final int recipeWidth;
    public final int recipeHeight;
    public final ItemStack[] recipeItems;
    private ItemStack recipeOutput;
    private boolean strangeField;

    public BrickOvenShapedRecipe(int width, int height, ItemStack[] input, ItemStack output) {
        this.recipeWidth = width;
        this.recipeHeight = height;
        this.recipeItems = input;
        this.recipeOutput = output;
    }

    @Override
    public boolean matches(TileEntityBrickOven oven) {
        for (int i = 0; i <= 3 - this.recipeWidth; ++i) {
            for (int j = 0; j <= 3 - this.recipeHeight; ++j) {
                if (this.checkMatch(oven, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(oven, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean matches(TileEntityNetherBrickOven oven) {
        for (int i = 0; i <= 3 - this.recipeWidth; ++i) {
            for (int j = 0; j <= 3 - this.recipeHeight; ++j) {
                if (this.checkMatch(oven, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(oven, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(TileEntityNetherBrickOven oven, int width, int height, boolean flag4) {
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 3; ++l) {
                ItemStack itemstack1;
                int i1 = k - width;
                int j1 = l - height;
                ItemStack itemstack = null;
                if (i1 >= 0 && j1 >= 0 && i1 < this.recipeWidth && j1 < this.recipeHeight) {
                    itemstack = flag4 ? this.recipeItems[this.recipeWidth - i1 - 1 + j1 * this.recipeWidth] : this.recipeItems[i1 + j1 * this.recipeWidth];
                }
                if ((itemstack1 = oven.getStackInRowAndColumn(k, l)) == null && itemstack == null) continue;
                if (itemstack1 == null && itemstack != null || itemstack1 != null && itemstack == null) {
                    return false;
                }
                if (itemstack.func_77973_b() != itemstack1.func_77973_b()) {
                    return false;
                }
                if (itemstack.func_77960_j() == Short.MAX_VALUE || itemstack.func_77960_j() == itemstack1.func_77960_j()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public ItemStack getCraftingResult(TileEntityBrickOven oven) {
        ItemStack itemstack = this.getRecipeOutput().func_77946_l();
        if (this.strangeField) {
            for (int i = 0; i < oven.func_70302_i_(); ++i) {
                ItemStack itemstack1 = oven.func_70301_a(i);
                if (itemstack1 == null || !itemstack1.func_77942_o()) continue;
                itemstack.func_77982_d((NBTTagCompound)itemstack1.field_77990_d.func_74737_b());
            }
        }
        return itemstack;
    }

    @Override
    public ItemStack getCraftingResult(TileEntityNetherBrickOven oven) {
        ItemStack itemstack = this.getRecipeOutput().func_77946_l();
        if (this.strangeField) {
            for (int i = 0; i < oven.func_70302_i_(); ++i) {
                ItemStack itemstack1 = oven.func_70301_a(i);
                if (itemstack1 == null || !itemstack1.func_77942_o()) continue;
                itemstack.func_77982_d((NBTTagCompound)itemstack1.field_77990_d.func_74737_b());
            }
        }
        return itemstack;
    }

    @Override
    public int getRecipeSize() {
        return this.recipeWidth * this.recipeHeight;
    }

    @Override
    public boolean contains(ItemStack stack) {
        for (ItemStack s : this.recipeItems) {
            if (s == null || s.func_77973_b() != stack.func_77973_b()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    private boolean checkMatch(TileEntityBrickOven oven, int width, int height, boolean flag4) {
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 3; ++l) {
                ItemStack itemstack1;
                int i1 = k - width;
                int j1 = l - height;
                ItemStack itemstack = null;
                if (i1 >= 0 && j1 >= 0 && i1 < this.recipeWidth && j1 < this.recipeHeight) {
                    itemstack = flag4 ? this.recipeItems[this.recipeWidth - i1 - 1 + j1 * this.recipeWidth] : this.recipeItems[i1 + j1 * this.recipeWidth];
                }
                if ((itemstack1 = oven.getStackInRowAndColumn(k, l)) == null && itemstack == null) continue;
                if (itemstack1 == null && itemstack != null || itemstack1 != null && itemstack == null) {
                    return false;
                }
                if (itemstack.func_77973_b() != itemstack1.func_77973_b()) {
                    return false;
                }
                if (itemstack.func_77960_j() == Short.MAX_VALUE || itemstack.func_77960_j() == itemstack1.func_77960_j()) continue;
                return false;
            }
        }
        return true;
    }

    public BrickOvenShapedRecipe func_92100_c() {
        this.strangeField = true;
        return this;
    }

    @Override
    public ItemStack[] getInputs() {
        ArrayList<ItemStack> buf = new ArrayList<ItemStack>();
        for (ItemStack is : this.recipeItems) {
            if (is == null) continue;
            buf.add(is);
        }
        return buf.toArray(new ItemStack[0]);
    }

    public ItemStack[] getThreeByThree() {
        ItemStack[] res = new ItemStack[9];
        int y = 0;
        int x = 0;
        int v = 0;
        int u = 0;
        for (int i = 0; i < this.getRecipeSize(); ++i) {
            res[x + y * 3] = this.recipeItems[u + v * this.recipeWidth];
            if (++u >= this.recipeWidth) {
                u = 0;
            }
            x = u;
            y = ++v;
        }
        return res;
    }
}

