/*
 * Decompiled with CFR 0.152.
 */
package net.einsteinsci.betterbeginnings.register.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.einsteinsci.betterbeginnings.register.recipe.SmelterRecipe;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class SmelterRecipeHandler {
    private static final SmelterRecipeHandler SMELTINGBASE = new SmelterRecipeHandler();
    private Map experienceList = new HashMap();
    private List<SmelterRecipe> recipes = new ArrayList<SmelterRecipe>();

    private SmelterRecipeHandler() {
    }

    public static void addRecipe(Item input, ItemStack output, float experience, int gravel, int bonus, float chance) {
        SmelterRecipeHandler.smelting().addLists(input, output, experience, gravel, bonus, chance);
    }

    public void addLists(Item input, ItemStack output, float experience, int gravel, int bonus, float chance) {
        this.putLists(new ItemStack(input, 1, Short.MAX_VALUE), output, experience, gravel, bonus, chance);
    }

    public static SmelterRecipeHandler smelting() {
        return SMELTINGBASE;
    }

    public void putLists(ItemStack input, ItemStack output, float experience, int gravel, int bonus, float chance) {
        this.experienceList.put(output, Float.valueOf(experience));
        this.recipes.add(new SmelterRecipe(output, input, experience, gravel, bonus, chance));
    }

    public static void addRecipe(Block input, ItemStack output, float experience, int gravel, int bonus, float chance) {
        SmelterRecipeHandler.smelting().addLists(Item.func_150898_a((Block)input), output, experience, gravel, bonus, chance);
    }

    public static void addRecipe(ItemStack input, ItemStack output, float experience, int gravel, int bonus, float chance) {
        SmelterRecipeHandler.smelting().putLists(input, output, experience, gravel, bonus, chance);
    }

    public ItemStack getSmeltingResult(ItemStack input) {
        for (SmelterRecipe recipe : this.recipes) {
            if (recipe.getInput().func_77973_b() != input.func_77973_b()) continue;
            return recipe.getOutput();
        }
        return null;
    }

    public int getGravelCount(ItemStack stack) {
        for (SmelterRecipe recipe : this.recipes) {
            if (recipe.getInput() == null || recipe.getInput().func_77973_b() != stack.func_77973_b()) continue;
            return recipe.getGravel();
        }
        return -1;
    }

    public float giveExperience(ItemStack stack) {
        Map.Entry entry;
        Iterator iterator = this.experienceList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return 0.0f;
        } while (!this.canBeSmelted(stack, (ItemStack)(entry = iterator.next()).getKey()));
        if (stack.func_77973_b().getSmeltingExperience(stack) != -1.0f) {
            return stack.func_77973_b().getSmeltingExperience(stack);
        }
        return ((Float)entry.getValue()).floatValue();
    }

    private boolean canBeSmelted(ItemStack stack, ItemStack stack2) {
        return stack2.func_77973_b() == stack.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack.func_77960_j());
    }

    public int getBonus(ItemStack input) {
        for (SmelterRecipe recipe : this.recipes) {
            if (recipe.getInput().func_77973_b() != input.func_77973_b()) continue;
            return recipe.getBonus();
        }
        return 0;
    }

    public float getBonusChance(ItemStack input) {
        for (SmelterRecipe recipe : this.recipes) {
            if (recipe.getInput().func_77973_b() != input.func_77973_b()) continue;
            return recipe.getBonusChance();
        }
        return 0.0f;
    }

    public static List<SmelterRecipe> getRecipes() {
        return SmelterRecipeHandler.smelting().recipes;
    }
}

