/*
 * Decompiled with CFR 0.152.
 */
package net.einsteinsci.betterbeginnings.tileentity;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.einsteinsci.betterbeginnings.blocks.BlockBrickOven;
import net.einsteinsci.betterbeginnings.register.recipe.BrickOvenRecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileEntityBrickOven
extends TileEntity
implements ISidedInventory {
    public static final int FUEL = 0;
    private int[] slotsInput = new int[]{0};
    public static final int OUTPUT = 1;
    private int[] slotsOutput = new int[]{1};
    public static final int INPUTSTART = 2;
    public static final int COOKTIME = 120;
    public int ovenBurnTime;
    public int currentItemBurnLength;
    public int ovenCookTime;
    private ItemStack[] ovenStacks = new ItemStack[11];
    private String ovenName;

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        this.ovenStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTag = tagList.func_150305_b(i);
            byte slot = itemTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.ovenStacks.length) continue;
            this.ovenStacks[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
        }
        this.ovenBurnTime = tagCompound.func_74765_d("BurnTime");
        this.ovenCookTime = tagCompound.func_74765_d("CookTime");
        this.currentItemBurnLength = TileEntityBrickOven.getItemBurnTime(this.ovenStacks[1]);
        if (tagCompound.func_74764_b("CustomName")) {
            this.ovenName = tagCompound.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74777_a("BurnTime", (short)this.ovenBurnTime);
        tagCompound.func_74777_a("CookTime", (short)this.ovenCookTime);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.ovenStacks.length; ++i) {
            if (this.ovenStacks[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            this.ovenStacks[i].func_77955_b(itemTag);
            itemTag.func_74774_a("Slot", (byte)i);
            tagList.func_74742_a((NBTBase)itemTag);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tagList);
        if (this.func_145818_k_()) {
            tagCompound.func_74778_a("CustomName", this.ovenName);
        }
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            boolean flag = this.ovenBurnTime > 0;
            boolean flag1 = false;
            if (this.ovenBurnTime > 0) {
                --this.ovenBurnTime;
            }
            if (this.ovenBurnTime == 0 && this.canSmelt()) {
                this.currentItemBurnLength = this.ovenBurnTime = TileEntityBrickOven.getItemBurnTime(this.ovenStacks[0]);
                if (this.ovenBurnTime > 0) {
                    flag1 = true;
                    if (this.ovenStacks[0] != null) {
                        --this.ovenStacks[0].field_77994_a;
                        if (this.ovenStacks[0].field_77994_a == 0) {
                            this.ovenStacks[0] = this.ovenStacks[0].func_77973_b().getContainerItem(this.ovenStacks[0]);
                        }
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.ovenCookTime;
                if (this.ovenCookTime == 120) {
                    this.ovenCookTime = 0;
                    this.smeltItem();
                    flag1 = true;
                }
            } else {
                this.ovenCookTime = 0;
            }
            if (flag != this.ovenBurnTime > 0) {
                flag1 = true;
                BlockBrickOven.updateBlockState(this.ovenBurnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (flag1) {
                this.func_70296_d();
            }
        }
    }

    private boolean canSmelt() {
        boolean empty = true;
        for (int i = 2; i < this.ovenStacks.length; ++i) {
            if (this.ovenStacks[i] == null) continue;
            empty = false;
            break;
        }
        if (empty) {
            return false;
        }
        ItemStack stack = BrickOvenRecipeHandler.instance().findMatchingRecipe(this);
        if (stack == null) {
            return false;
        }
        if (this.ovenStacks[1] == null) {
            return true;
        }
        if (!this.ovenStacks[1].func_77969_a(stack)) {
            return false;
        }
        int result = this.ovenStacks[1].field_77994_a + stack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.ovenStacks[1].func_77976_d();
    }

    public boolean isBurning() {
        return this.ovenBurnTime > 0;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemStack = BrickOvenRecipeHandler.instance().findMatchingRecipe(this);
            if (this.ovenStacks[1] == null) {
                this.ovenStacks[1] = itemStack.func_77946_l();
            } else if (this.ovenStacks[1].func_77973_b() == itemStack.func_77973_b()) {
                this.ovenStacks[1].field_77994_a += itemStack.field_77994_a;
            }
            for (int i = 2; i < this.ovenStacks.length; ++i) {
                ItemStack stack = this.ovenStacks[i];
                if (stack == null) continue;
                ItemStack containerItem = null;
                if (this.ovenStacks[i].func_77973_b().hasContainerItem(this.ovenStacks[i])) {
                    containerItem = this.ovenStacks[i].func_77973_b().getContainerItem(this.ovenStacks[i]);
                }
                --this.ovenStacks[i].field_77994_a;
                if (this.ovenStacks[i].field_77994_a <= 0) {
                    this.ovenStacks[i] = null;
                }
                if (containerItem == null) continue;
                this.ovenStacks[i] = containerItem;
            }
        }
    }

    public int func_70302_i_() {
        return this.ovenStacks.length;
    }

    public static int getItemBurnTime(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 300;
            }
            if (block.func_149688_o() == Material.field_151575_d) {
                return 600;
            }
            if (block == Blocks.field_150402_ci) {
                return 32000;
            }
            if (block == Blocks.field_150357_h) {
                return Short.MAX_VALUE;
            }
        }
        if (item instanceof ItemTool && (((ItemTool)item).func_77861_e().equals("WOOD") || ((ItemTool)item).func_77861_e().equals("noobwood"))) {
            return 400;
        }
        if (item instanceof ItemSword && (((ItemSword)item).func_150932_j().equals("WOOD") || ((ItemSword)item).func_150932_j().equals("noobwood"))) {
            return 400;
        }
        if (item instanceof ItemHoe && (((ItemHoe)item).func_77842_f().equals("WOOD") || ((ItemHoe)item).func_77842_f().equals("noobwood"))) {
            return 400;
        }
        if (item == Items.field_151055_y) {
            return 200;
        }
        if (item == Items.field_151044_h) {
            return 3200;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 200;
        }
        if (item == Items.field_151072_bj) {
            return 0;
        }
        if (item == Items.field_151129_at) {
            return 0;
        }
        return GameRegistry.getFuelValue((ItemStack)itemStack);
    }

    public ItemStack func_70301_a(int i) {
        return this.ovenStacks[i];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.ovenStacks[slot] != null) {
            if (this.ovenStacks[slot].field_77994_a <= amount) {
                ItemStack stack = this.ovenStacks[slot];
                this.ovenStacks[slot] = null;
                return stack;
            }
            ItemStack stack = this.ovenStacks[slot].func_77979_a(amount);
            if (this.ovenStacks[slot].field_77994_a == 0) {
                this.ovenStacks[slot] = null;
            }
            return stack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.ovenStacks[slot] != null) {
            ItemStack stack = this.ovenStacks[slot];
            this.ovenStacks[slot] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.ovenStacks[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.ovenName : "container.brickoven";
    }

    public boolean func_145818_k_() {
        return this.ovenName != null && this.ovenName.length() > 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 1 ? false : (slot == 0 ? TileEntityBrickOven.isItemFuel(stack) : true);
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int progress) {
        return this.ovenCookTime * progress / 120;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int time) {
        if (this.currentItemBurnLength == 0) {
            this.currentItemBurnLength = 120;
        }
        return this.ovenBurnTime * time / this.currentItemBurnLength;
    }

    public void furnaceName(String displayName) {
        this.ovenName = displayName;
    }

    public int[] func_94128_d(int side) {
        if (side == 0) {
            return this.slotsOutput;
        }
        return this.slotsInput;
    }

    public boolean func_102007_a(int par1, ItemStack stack, int par3) {
        return this.func_94041_b(par1, stack);
    }

    public static boolean isItemFuel(ItemStack itemStack) {
        return TileEntityBrickOven.getItemBurnTime(itemStack) > 0;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return side == 0;
    }

    public ItemStack getStackInRowAndColumn(int row, int column) {
        return this.func_70301_a(2 + row + column * 3);
    }
}

