/*
 * Decompiled with CFR 0.152.
 */
package net.einsteinsci.betterbeginnings.tileentity;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.einsteinsci.betterbeginnings.ModMain;
import net.einsteinsci.betterbeginnings.blocks.BlockCampfire;
import net.einsteinsci.betterbeginnings.items.ItemBonePickaxe;
import net.einsteinsci.betterbeginnings.items.ItemFlintHatchet;
import net.einsteinsci.betterbeginnings.items.ItemKnifeFlint;
import net.einsteinsci.betterbeginnings.items.ItemPan;
import net.einsteinsci.betterbeginnings.network.PacketCampfireState;
import net.einsteinsci.betterbeginnings.register.recipe.CampfirePanRecipes;
import net.einsteinsci.betterbeginnings.register.recipe.CampfireRecipes;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityCampfire
extends TileEntity
implements IInventory {
    public static final int maxCookTime = 300;
    public static final int maxDecayTime = 400;
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_FUEL = 2;
    public static final int SLOT_OUTPUT = 1;
    public static final int SLOT_PAN = 3;
    public ItemStack[] stacks = new ItemStack[4];
    public int cookTime;
    public int burnTime;
    public int currentItemBurnTime;
    public int decayTime;
    public byte campfireState;
    public static final byte STATE_OFF = 0;
    public static final byte STATE_BURNING = 1;
    public static final byte STATE_DECAYING = 2;
    private String campfireName;

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        this.stacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTag = tagList.func_150305_b(i);
            byte slot = itemTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.stacks.length) continue;
            this.stacks[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
        }
        this.burnTime = tagCompound.func_74765_d("BurnTime");
        this.cookTime = tagCompound.func_74765_d("CookTime");
        this.currentItemBurnTime = TileEntityCampfire.getBurnTimeForFuel(this.stackFuel());
        this.decayTime = tagCompound.func_74765_d("DecayTime");
        this.campfireState = tagCompound.func_74771_c("CampfireState");
        if (tagCompound.func_150297_b("CustomName", 8)) {
            this.campfireName = tagCompound.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74777_a("BurnTime", (short)this.burnTime);
        tagCompound.func_74777_a("CookTime", (short)this.cookTime);
        tagCompound.func_74777_a("DecayTIme", (short)this.decayTime);
        tagCompound.func_74774_a("CampfireState", this.campfireState);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.stacks.length; ++i) {
            if (this.stacks[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            this.stacks[i].func_77955_b(itemTag);
            itemTag.func_74774_a("Slot", (byte)i);
            tagList.func_74742_a((NBTBase)itemTag);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tagList);
        if (this.func_145818_k_()) {
            tagCompound.func_74778_a("CustomName", this.campfireName);
        }
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            boolean burning = this.burnTime > 0;
            boolean dirty = false;
            if (burning) {
                --this.burnTime;
                this.decayTime = 400;
                this.campfireState = 1;
            } else {
                this.decayTime = Math.max(0, this.decayTime - 1);
                this.campfireState = this.decayTime > 0 ? (byte)2 : (byte)0;
            }
            if (this.burnTime == 0 && this.canCook() && this.campfireState != 0) {
                this.currentItemBurnTime = this.burnTime = TileEntityCampfire.getBurnTimeForFuel(this.stackFuel());
                if (this.burnTime > 0) {
                    this.decayTime = 400;
                    burning = true;
                }
                if (burning && this.stackFuel() != null) {
                    --this.stackFuel().field_77994_a;
                    if (this.stackFuel().field_77994_a == 0) {
                        this.stacks[2] = this.stackFuel().func_77973_b().getContainerItem(this.stackFuel());
                    }
                }
                dirty = true;
            }
            if (this.campfireState != 0 && this.canCook()) {
                ++this.cookTime;
                if (this.cookTime == 300) {
                    this.cookTime = 0;
                    this.cookItem();
                    dirty = true;
                }
            } else {
                this.cookTime = 0;
                dirty = true;
            }
            if (burning != this.decayTime > 0) {
                dirty = true;
            }
            BlockCampfire.updateBlockState(this.campfireState == 1, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (dirty) {
                this.func_70296_d();
            }
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 128.0);
            ModMain.network.sendToAllAround((IMessage)new PacketCampfireState(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.campfireState), point);
            if (this.campfireState == 1) {
                List idiots = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)));
                for (Object obj : idiots) {
                    if (!(obj instanceof EntityLivingBase)) continue;
                    EntityLivingBase idiot = (EntityLivingBase)obj;
                    idiot.func_70015_d(5);
                }
            }
        }
    }

    public boolean canCook() {
        if (this.stackInput() == null) {
            return false;
        }
        ItemStack potentialResult = CampfirePanRecipes.smelting().getSmeltingResult(this.stackInput());
        if (potentialResult == null || this.stackPan() == null) {
            potentialResult = CampfireRecipes.smelting().getSmeltingResult(this.stackInput());
        }
        if (potentialResult == null) {
            return false;
        }
        if (this.stackOutput() == null) {
            return true;
        }
        if (!this.stackOutput().func_77969_a(potentialResult)) {
            return false;
        }
        int resultSize = this.stackOutput().field_77994_a + potentialResult.field_77994_a;
        boolean canFit = resultSize <= this.func_70297_j_();
        boolean canFitWithItem = resultSize <= this.stackOutput().func_77976_d();
        return canFit && canFitWithItem;
    }

    public boolean isDecaying() {
        return this.decayTime > 0;
    }

    private void cookItem() {
        if (this.canCook()) {
            ItemStack potentialResult = CampfirePanRecipes.smelting().getSmeltingResult(this.stackInput());
            if (potentialResult == null || this.stackPan() == null) {
                potentialResult = CampfireRecipes.smelting().getSmeltingResult(this.stackInput());
            }
            if (this.stackOutput() == null) {
                this.stacks[1] = potentialResult.func_77946_l();
            } else if (this.stackOutput().func_77969_a(potentialResult)) {
                this.stackOutput().field_77994_a += potentialResult.field_77994_a;
            }
            --this.stackInput().field_77994_a;
            if (this.stackInput().field_77994_a <= 0) {
                this.stacks[0] = null;
            }
            if (this.stacks[3] != null && this.stacks[3].func_77973_b() instanceof ItemPan) {
                int damage = this.stacks[3].func_77960_j();
                this.stacks[3].func_77964_b(damage + 1);
                if (this.stacks[3].func_77960_j() >= this.stacks[3].func_77958_k()) {
                    this.stacks[3] = null;
                }
            }
        }
    }

    public ItemStack stackInput() {
        return this.stacks[0];
    }

    public ItemStack stackPan() {
        return this.stacks[3];
    }

    public ItemStack stackOutput() {
        return this.stacks[1];
    }

    public int func_70302_i_() {
        return this.stacks.length;
    }

    public static int getBurnTimeForFuel(ItemStack fuel) {
        if (fuel == null) {
            return 0;
        }
        Block block = Block.func_149634_a((Item)fuel.func_77973_b());
        Item item = fuel.func_77973_b();
        if (block != null) {
            if (block.func_149688_o() == Material.field_151575_d) {
                return 600;
            }
            if (block == Blocks.field_150376_bx) {
                return 300;
            }
            if (block == Blocks.field_150345_g) {
                return 200;
            }
        }
        if (item != null) {
            if (item instanceof ItemBonePickaxe || item instanceof ItemFlintHatchet || item instanceof ItemKnifeFlint) {
                return 0;
            }
            if (item instanceof ItemTool && (((ItemTool)item).func_77861_e().equals("WOOD") || ((ItemTool)item).func_77861_e().equals("noobwood"))) {
                return 400;
            }
            if (item instanceof ItemSword && (((ItemSword)item).func_150932_j().equals("WOOD") || ((ItemSword)item).func_150932_j().equals("noobwood"))) {
                return 400;
            }
            if (item instanceof ItemHoe && (((ItemHoe)item).func_77842_f().equals("WOOD") || ((ItemHoe)item).func_77842_f().equals("noobwood"))) {
                return 400;
            }
            if (item == Items.field_151055_y) {
                return 200;
            }
        }
        return 0;
    }

    public ItemStack stackFuel() {
        return this.stacks[2];
    }

    public ItemStack func_70301_a(int slot) {
        return this.stacks[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.stacks[slot] != null) {
            if (this.stacks[slot].field_77994_a <= amount) {
                ItemStack stack = this.stacks[slot];
                this.stacks[slot] = null;
                return stack;
            }
            ItemStack stack = this.stacks[slot].func_77979_a(amount);
            if (this.stacks[slot].field_77994_a == 0) {
                this.stacks[slot] = null;
            }
            return stack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.stacks[slot] == null) {
            return null;
        }
        ItemStack stack = this.stacks[slot].func_77946_l();
        this.stacks[slot] = null;
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.stacks[slot] = stack;
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.campfireName : "container.campfire";
    }

    public boolean func_145818_k_() {
        return this.campfireName != null && this.campfireName.length() > 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0 || slot == 3 && TileEntityCampfire.isPan(stack) || slot == 2 && TileEntityCampfire.isItemFuel(stack);
    }

    private static boolean isPan(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.func_77973_b() instanceof ItemPan;
    }

    public static boolean isItemFuel(ItemStack itemstack1) {
        return TileEntityCampfire.getBurnTimeForFuel(itemstack1) > 0;
    }

    public void lightFuel() {
        if (this.campfireState == 1) {
            return;
        }
        int maxBurn = TileEntityCampfire.getBurnTimeForFuel(this.stackFuel());
        if (maxBurn > 0 && this.canCook()) {
            this.burnTime = maxBurn;
            this.decayTime = 400;
            this.campfireState = 1;
            this.currentItemBurnTime = this.burnTime;
            if (this.stackFuel() != null) {
                --this.stackFuel().field_77994_a;
                if (this.stackFuel().field_77994_a == 0) {
                    this.stacks[2] = this.stackFuel().func_77973_b().getContainerItem(this.stackFuel());
                }
            }
        }
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int i) {
        return this.cookTime * i / 300;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int i) {
        if (this.currentItemBurnTime <= 0) {
            return 0;
        }
        return this.burnTime * i / this.currentItemBurnTime;
    }

    public int getDecayTimeRemainingScaled(int i) {
        return this.decayTime * i / 400;
    }
}

