/*
 * Decompiled with CFR 0.152.
 */
package net.einsteinsci.betterbeginnings.tileentity;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.einsteinsci.betterbeginnings.blocks.BlockEnderSmelter;
import net.einsteinsci.betterbeginnings.register.recipe.SmelterRecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileEntityEnderSmelter
extends TileEntity
implements ISidedInventory {
    public static final int smeltTime = 140;
    public static final int INPUT = 0;
    public static final int FUEL = 1;
    public static final int OUTPUT = 2;
    public static final int GRAVEL = 3;
    public static final Random random = new Random();
    private static final int[] slotsTop = new int[]{3, 0};
    private static final int[] slotsBottom = new int[]{2};
    private static final int[] slotsSides = new int[]{1, 3, 0};
    public int smelterBurnTime;
    public int currentItemBurnLength;
    public int smelterCookTime;
    public boolean oreDoubled = false;
    private ItemStack[] smelterStacks = new ItemStack[4];
    private String smelterName;

    public void furnaceName(String string) {
        this.smelterName = string;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int progress) {
        return this.smelterCookTime * progress / 140;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int time) {
        if (this.currentItemBurnLength == 0) {
            this.currentItemBurnLength = 140;
        }
        return this.smelterBurnTime * time / this.currentItemBurnLength;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        this.smelterStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTag = tagList.func_150305_b(i);
            byte slot = itemTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.smelterStacks.length) continue;
            this.smelterStacks[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
        }
        this.smelterBurnTime = tagCompound.func_74765_d("BurnTime");
        this.smelterCookTime = tagCompound.func_74765_d("CookTime");
        this.currentItemBurnLength = TileEntityEnderSmelter.getItemBurnTime(this.smelterStacks[1]);
        if (tagCompound.func_150297_b("CustomName", 8)) {
            this.smelterName = tagCompound.func_74779_i("CustomName");
        }
        this.oreDoubled = tagCompound.func_74771_c("oreDoubled") == 1;
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74777_a("BurnTime", (short)this.smelterBurnTime);
        tagCompound.func_74777_a("CookTime", (short)this.smelterCookTime);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.smelterStacks.length; ++i) {
            if (this.smelterStacks[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            this.smelterStacks[i].func_77955_b(itemTag);
            itemTag.func_74774_a("Slot", (byte)i);
            tagList.func_74742_a((NBTBase)itemTag);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tagList);
        if (this.func_145818_k_()) {
            tagCompound.func_74778_a("CustomName", this.smelterName);
        }
        tagCompound.func_74774_a("oreDoubled", this.oreDoubled ? (byte)1 : 0);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            boolean flag = this.smelterBurnTime > 0;
            boolean flag1 = false;
            if (this.smelterBurnTime > 0) {
                --this.smelterBurnTime;
            }
            if (this.smelterBurnTime == 0 && this.canSmelt()) {
                this.currentItemBurnLength = this.smelterBurnTime = TileEntityEnderSmelter.getItemBurnTime(this.smelterStacks[1]);
                if (this.smelterBurnTime > 0) {
                    flag1 = true;
                    if (this.smelterStacks[1] != null) {
                        --this.smelterStacks[1].field_77994_a;
                        if (this.smelterStacks[1].field_77994_a == 0) {
                            this.smelterStacks[1] = this.smelterStacks[1].func_77973_b().getContainerItem(this.smelterStacks[1]);
                        }
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.smelterCookTime;
                if (this.smelterCookTime == 140) {
                    this.smelterCookTime = 0;
                    this.smeltItem();
                    flag1 = true;
                }
            } else {
                this.smelterCookTime = 0;
            }
            if (flag != this.smelterBurnTime > 0) {
                flag1 = true;
                BlockEnderSmelter.updateBlockState(this.smelterBurnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (flag1) {
                this.func_70296_d();
            }
        }
    }

    private boolean canSmelt() {
        if (this.smelterStacks[0] == null || this.smelterStacks[3] == null) {
            return false;
        }
        ItemStack output = SmelterRecipeHandler.smelting().getSmeltingResult(this.smelterStacks[0]);
        int gravelNeeded = SmelterRecipeHandler.smelting().getGravelCount(this.smelterStacks[0]);
        int bonus = SmelterRecipeHandler.smelting().getBonus(this.smelterStacks[0]);
        if (output == null) {
            return false;
        }
        if (gravelNeeded > this.smelterStacks[3].field_77994_a) {
            return false;
        }
        if (this.smelterStacks[2] == null) {
            return true;
        }
        if (!this.smelterStacks[2].func_77969_a(output)) {
            return false;
        }
        int result = this.smelterStacks[2].field_77994_a + output.field_77994_a + bonus;
        return result <= this.func_70297_j_() && result <= this.smelterStacks[2].func_77976_d();
    }

    public boolean isBurning() {
        return this.smelterBurnTime > 0;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemStack = SmelterRecipeHandler.smelting().getSmeltingResult(this.smelterStacks[0]);
            int bonus = SmelterRecipeHandler.smelting().getBonus(this.smelterStacks[0]);
            float chance = SmelterRecipeHandler.smelting().getBonusChance(this.smelterStacks[0]);
            int resultSize = itemStack.field_77994_a;
            if (random.nextFloat() < chance) {
                resultSize += bonus;
                this.oreDoubled = true;
            }
            if (this.smelterStacks[2] == null) {
                this.smelterStacks[2] = itemStack.func_77946_l();
            } else if (this.smelterStacks[2].func_77973_b() == itemStack.func_77973_b()) {
                this.smelterStacks[2].field_77994_a += resultSize;
            }
            int gravelUsed = SmelterRecipeHandler.smelting().getGravelCount(this.smelterStacks[0]);
            --this.smelterStacks[0].field_77994_a;
            if (this.smelterStacks[0].field_77994_a <= 0) {
                this.smelterStacks[0] = null;
            }
            this.smelterStacks[3].field_77994_a -= gravelUsed;
            if (this.smelterStacks[3].field_77994_a <= 0) {
                this.smelterStacks[3] = null;
            }
        }
    }

    public int func_70302_i_() {
        return this.smelterStacks.length;
    }

    public static int getItemBurnTime(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
        }
        if (item == Items.field_151044_h && itemStack.func_77960_j() == 1) {
            return 1600;
        }
        if (item == Items.field_151072_bj) {
            return 600;
        }
        if (item == Items.field_151129_at) {
            return 7200;
        }
        if (item == Items.field_151079_bi) {
            return 1200;
        }
        if (item == Items.field_151061_bv) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)itemStack);
    }

    public ItemStack func_70301_a(int i) {
        return this.smelterStacks[i];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.smelterStacks[slot] != null) {
            if (this.smelterStacks[slot].field_77994_a <= amount) {
                ItemStack stack = this.smelterStacks[slot];
                this.smelterStacks[slot] = null;
                return stack;
            }
            ItemStack stack = this.smelterStacks[slot].func_77979_a(amount);
            if (this.smelterStacks[slot].field_77994_a == 0) {
                this.smelterStacks[slot] = null;
            }
            return stack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.smelterStacks[slot] != null) {
            ItemStack stack = this.smelterStacks[slot];
            this.smelterStacks[slot] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.smelterStacks[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.smelterName : "container.enderSmelter";
    }

    public boolean func_145818_k_() {
        return this.smelterName != null && this.smelterName.length() > 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack == null || slot == 2) {
            return false;
        }
        if (slot == 3 && stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150351_n)) {
            return true;
        }
        if (slot == 1 && TileEntityEnderSmelter.getItemBurnTime(stack) > 0) {
            return true;
        }
        return slot == 0;
    }

    public int[] func_94128_d(int side) {
        return side == 0 ? slotsBottom : (side == 1 ? slotsTop : slotsSides);
    }

    public boolean func_102007_a(int par1, ItemStack stack, int par3) {
        return this.func_94041_b(par1, stack);
    }

    public static boolean isItemFuel(ItemStack itemStack) {
        return TileEntityEnderSmelter.getItemBurnTime(itemStack) > 0;
    }

    public boolean func_102008_b(int par1, ItemStack stack, int par3) {
        return par3 != 0 || par1 != 1 || stack.func_77973_b() == Items.field_151133_ar;
    }
}

