/*
 * Decompiled with CFR 0.152.
 */
package net.einsteinsci.betterbeginnings.tileentity;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.einsteinsci.betterbeginnings.blocks.BlockKiln;
import net.einsteinsci.betterbeginnings.items.ItemBonePickaxe;
import net.einsteinsci.betterbeginnings.items.ItemFlintHatchet;
import net.einsteinsci.betterbeginnings.items.ItemKnifeFlint;
import net.einsteinsci.betterbeginnings.register.recipe.KilnRecipes;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileEntityKiln
extends TileEntity
implements ISidedInventory {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_FUEL = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int smeltTime = 250;
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{2};
    private static final int[] slotsSides = new int[]{1, 0};
    public ItemStack[] kilnStacks = new ItemStack[3];
    public int kilnBurnTime;
    public int currentBurnTime;
    public int kilnCookTime;
    private String kilnName;

    public void setKilnName(String string) {
        this.kilnName = string;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        this.kilnStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTag = tagList.func_150305_b(i);
            byte slot = itemTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.kilnStacks.length) continue;
            this.kilnStacks[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
        }
        this.kilnBurnTime = tagCompound.func_74765_d("BurnTime");
        this.kilnCookTime = tagCompound.func_74765_d("CookTime");
        this.currentBurnTime = TileEntityKiln.getItemBurnTime(this.kilnStacks[1]);
        if (tagCompound.func_150297_b("CustomName", 8)) {
            this.kilnName = tagCompound.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74777_a("BurnTime", (short)this.kilnBurnTime);
        tagCompound.func_74777_a("CookTime", (short)this.kilnCookTime);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.kilnStacks.length; ++i) {
            if (this.kilnStacks[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            this.kilnStacks[i].func_77955_b(itemTag);
            itemTag.func_74774_a("Slot", (byte)i);
            tagList.func_74742_a((NBTBase)itemTag);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tagList);
        if (this.func_145818_k_()) {
            tagCompound.func_74778_a("CustomName", this.kilnName);
        }
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            boolean flag = this.kilnBurnTime > 0;
            boolean flag1 = false;
            if (this.kilnBurnTime > 0) {
                --this.kilnBurnTime;
            }
            if (this.kilnBurnTime == 0 && this.canSmelt()) {
                this.currentBurnTime = this.kilnBurnTime = TileEntityKiln.getItemBurnTime(this.kilnStacks[1]);
                if (this.kilnBurnTime > 0) {
                    flag1 = true;
                    if (this.kilnStacks[1] != null) {
                        --this.kilnStacks[1].field_77994_a;
                        if (this.kilnStacks[1].field_77994_a == 0) {
                            this.kilnStacks[1] = this.kilnStacks[1].func_77973_b().getContainerItem(this.kilnStacks[1]);
                        }
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.kilnCookTime;
                if (this.kilnCookTime == 250) {
                    this.kilnCookTime = 0;
                    this.smeltItem();
                    flag1 = true;
                }
            } else {
                this.kilnCookTime = 0;
            }
            if (flag != this.kilnBurnTime > 0) {
                flag1 = true;
                BlockKiln.updateBlockState(this.kilnBurnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (flag1) {
                this.func_70296_d();
            }
        }
    }

    private boolean canSmelt() {
        if (this.kilnStacks[0] == null) {
            return false;
        }
        ItemStack stack = KilnRecipes.smelting().getSmeltingResult(this.kilnStacks[0]);
        if (stack == null) {
            return false;
        }
        if (this.kilnStacks[2] == null) {
            return true;
        }
        if (!this.kilnStacks[2].func_77969_a(stack)) {
            return false;
        }
        int result = this.kilnStacks[2].field_77994_a + stack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.kilnStacks[2].func_77976_d();
    }

    public boolean isBurning() {
        return this.kilnBurnTime > 0;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemStack = KilnRecipes.smelting().getSmeltingResult(this.kilnStacks[0]);
            if (this.kilnStacks[2] == null) {
                this.kilnStacks[2] = itemStack.func_77946_l();
            } else if (this.kilnStacks[2].func_77973_b() == itemStack.func_77973_b()) {
                this.kilnStacks[2].field_77994_a += itemStack.field_77994_a;
            }
            --this.kilnStacks[0].field_77994_a;
            if (this.kilnStacks[0].field_77994_a <= 0) {
                this.kilnStacks[0] = null;
            }
        }
    }

    public int func_70302_i_() {
        return this.kilnStacks.length;
    }

    public static int getItemBurnTime(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 150;
            }
            if (block.func_149688_o() == Material.field_151575_d) {
                return 300;
            }
            if (block == Blocks.field_150402_ci) {
                return 16000;
            }
        }
        if (item instanceof ItemKnifeFlint || item instanceof ItemBonePickaxe || item instanceof ItemFlintHatchet) {
            return 0;
        }
        if (item instanceof ItemTool && (((ItemTool)item).func_77861_e().equals("WOOD") || ((ItemTool)item).func_77861_e().equals("noobwood"))) {
            return 200;
        }
        if (item instanceof ItemSword && (((ItemSword)item).func_150932_j().equals("WOOD") || ((ItemSword)item).func_150932_j().equals("noobwood"))) {
            return 200;
        }
        if (item instanceof ItemHoe && (((ItemHoe)item).func_77842_f().equals("WOOD") || ((ItemHoe)item).func_77842_f().equals("noobwood"))) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        if (item == Items.field_151072_bj) {
            return 0;
        }
        if (item == Items.field_151129_at) {
            return 0;
        }
        return GameRegistry.getFuelValue((ItemStack)itemStack);
    }

    public ItemStack func_70301_a(int i) {
        return this.kilnStacks[i];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.kilnStacks[slot] != null) {
            if (this.kilnStacks[slot].field_77994_a <= amount) {
                ItemStack stack = this.kilnStacks[slot];
                this.kilnStacks[slot] = null;
                return stack;
            }
            ItemStack stack = this.kilnStacks[slot].func_77979_a(amount);
            if (this.kilnStacks[slot].field_77994_a == 0) {
                this.kilnStacks[slot] = null;
            }
            return stack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.kilnStacks[slot] != null) {
            ItemStack stack = this.kilnStacks[slot];
            this.kilnStacks[slot] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.kilnStacks[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.kilnName : "container.kiln";
    }

    public boolean func_145818_k_() {
        return this.kilnName != null && this.kilnName.length() > 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 2 && (slot != 1 || TileEntityKiln.isItemFuel(stack));
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int progress) {
        return this.kilnCookTime * progress / 250;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int time) {
        if (this.currentBurnTime <= 0) {
            this.currentBurnTime = 250;
        }
        return this.kilnBurnTime * time / this.currentBurnTime;
    }

    public int[] func_94128_d(int side) {
        return side == 0 ? slotsBottom : (side == 1 ? slotsTop : slotsSides);
    }

    public boolean func_102007_a(int par1, ItemStack stack, int par3) {
        return this.func_94041_b(par1, stack);
    }

    public static boolean isItemFuel(ItemStack itemStack) {
        return TileEntityKiln.getItemBurnTime(itemStack) > 0;
    }

    public boolean func_102008_b(int par1, ItemStack stack, int par3) {
        return par3 != 0 || par1 != 1 || stack.func_77973_b() == Items.field_151133_ar;
    }
}

