/*
 * Decompiled with CFR 0.152.
 */
package net.einsteinsci.betterbeginnings.tileentity;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.einsteinsci.betterbeginnings.ModMain;
import net.einsteinsci.betterbeginnings.blocks.BlockNetherBrickOven;
import net.einsteinsci.betterbeginnings.inventory.TankNetherBrickOvenFuel;
import net.einsteinsci.betterbeginnings.network.PacketNetherBrickOvenFuelLevel;
import net.einsteinsci.betterbeginnings.register.recipe.NetherBrickOvenRecipeHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityNetherBrickOven
extends TileEntity
implements ISidedInventory,
IFluidHandler {
    public static final int FUELINPUT = 0;
    public static final int OUTPUT = 1;
    public static final int INPUTSTART = 2;
    public static final int COOKTIME = 80;
    public static final float FUELFORLAVA = 8.0f;
    public static final int MINIMUMTEMPERATURE = 500;
    public int ovenCookTime;
    public TankNetherBrickOvenFuel fuelTank;
    private int[] slotsInput = new int[]{0};
    private int[] slotsOutput = new int[]{1};
    private ItemStack[] ovenStacks = new ItemStack[11];
    private String ovenName;

    public TileEntityNetherBrickOven() {
        this.fuelTank = new TankNetherBrickOvenFuel(this, 8000);
    }

    public FluidStack getFuelStack() {
        return this.fuelTank.getFluid();
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        this.ovenStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTag = tagList.func_150305_b(i);
            byte slot = itemTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.ovenStacks.length) continue;
            this.ovenStacks[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
        }
        this.ovenCookTime = tagCompound.func_74765_d("CookTime");
        this.fuelTank = (TankNetherBrickOvenFuel)this.fuelTank.readFromNBT(tagCompound);
        if (tagCompound.func_74764_b("CustomName")) {
            this.ovenName = tagCompound.func_74779_i("CustomName");
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int result = this.fuelTank.fill(resource, doFill);
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return result;
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74777_a("CookTime", (short)this.ovenCookTime);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.ovenStacks.length; ++i) {
            if (this.ovenStacks[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            this.ovenStacks[i].func_77955_b(itemTag);
            itemTag.func_74774_a("Slot", (byte)i);
            tagList.func_74742_a((NBTBase)itemTag);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tagList);
        this.fuelTank.writeToNBT(tagCompound);
        if (this.func_145818_k_()) {
            tagCompound.func_74778_a("CustomName", this.ovenName);
        }
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public void func_145845_h() {
        boolean flag = this.canSmelt();
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.canSmelt()) {
                ++this.ovenCookTime;
                if (this.ovenCookTime == 80) {
                    this.ovenCookTime = 0;
                    this.smeltItem();
                    flag1 = true;
                }
            } else {
                this.ovenCookTime = 0;
            }
            if (this.ovenStacks[0] != null && this.fuelTank.fillFromContainer(this.ovenStacks[0])) {
                this.ovenStacks[0] = this.ovenStacks[0].func_77973_b().getContainerItem(this.ovenStacks[0]);
                NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 16.0);
                ModMain.network.sendToAllAround((IMessage)new PacketNetherBrickOvenFuelLevel(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.fuelTank.getFluid()), point);
            }
        }
        if (flag != this.canSmelt()) {
            flag1 = true;
            BlockNetherBrickOven.updateBlockState(this.canSmelt(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public void onDataPacket(NetworkManager manager, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canSmelt() {
        if (this.fuelTank.getFluidAmount() <= 0 || this.getFuelNeededForSmelt() > this.fuelTank.getFluidAmount()) {
            return false;
        }
        boolean empty = true;
        for (int i = 2; i < this.ovenStacks.length; ++i) {
            if (this.ovenStacks[i] == null) continue;
            empty = false;
            break;
        }
        if (empty) {
            return false;
        }
        ItemStack stack = NetherBrickOvenRecipeHandler.instance().findMatchingRecipe(this);
        if (stack == null) {
            return false;
        }
        if (this.ovenStacks[1] == null) {
            return true;
        }
        if (!this.ovenStacks[1].func_77969_a(stack)) {
            return false;
        }
        int result = this.ovenStacks[1].field_77994_a + stack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.ovenStacks[1].func_77976_d();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo(this.fuelTank.getFluid(), this.fuelTank.getCapacity())};
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemStack = NetherBrickOvenRecipeHandler.instance().findMatchingRecipe(this);
            if (this.ovenStacks[1] == null) {
                this.ovenStacks[1] = itemStack.func_77946_l();
            } else if (this.ovenStacks[1].func_77973_b() == itemStack.func_77973_b()) {
                this.ovenStacks[1].field_77994_a += itemStack.field_77994_a;
            }
            for (int i = 2; i < this.ovenStacks.length; ++i) {
                ItemStack stack = this.ovenStacks[i];
                if (stack == null) continue;
                ItemStack containerItem = null;
                if (this.ovenStacks[i].func_77973_b().hasContainerItem(this.ovenStacks[i])) {
                    containerItem = this.ovenStacks[i].func_77973_b().getContainerItem(this.ovenStacks[i]);
                }
                --this.ovenStacks[i].field_77994_a;
                if (this.ovenStacks[i].field_77994_a <= 0) {
                    this.ovenStacks[i] = null;
                }
                if (containerItem == null) continue;
                this.ovenStacks[i] = containerItem;
            }
            this.fuelTank.getFluid().amount -= this.getFuelNeededForSmelt();
        }
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 16.0);
        ModMain.network.sendToAllAround((IMessage)new PacketNetherBrickOvenFuelLevel(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.fuelTank.getFluid()), point);
    }

    public int[] func_94128_d(int side) {
        if (side == 0) {
            return this.slotsOutput;
        }
        return this.slotsInput;
    }

    public int getFuelNeededForSmelt() {
        if (this.fuelTank.getFluid() == null) {
            return 0;
        }
        float temperature = this.fuelTank.getFluid().getFluid().getTemperature();
        float precise = 8.0f * (float)FluidRegistry.LAVA.getTemperature() / temperature;
        int result = (int)precise;
        if (result <= 0) {
            result = 1;
        }
        return result;
    }

    public boolean func_102007_a(int par1, ItemStack stack, int par3) {
        return this.func_94041_b(par1, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return side == 0;
    }

    public int func_70302_i_() {
        return this.ovenStacks.length;
    }

    public boolean isItemFuelContainer(ItemStack stack) {
        FluidStack fluid;
        if (FluidContainerRegistry.isContainer((ItemStack)stack) && (fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack)) != null) {
            return fluid.getFluid().getTemperature() > 500;
        }
        return false;
    }

    public ItemStack func_70301_a(int slot) {
        return this.ovenStacks[slot];
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int progress) {
        return this.ovenCookTime * progress / 80;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.ovenStacks[slot] != null) {
            if (this.ovenStacks[slot].field_77994_a <= amount) {
                ItemStack stack = this.ovenStacks[slot];
                this.ovenStacks[slot] = null;
                return stack;
            }
            ItemStack stack = this.ovenStacks[slot].func_77979_a(amount);
            if (this.ovenStacks[slot].field_77994_a == 0) {
                this.ovenStacks[slot] = null;
            }
            return stack;
        }
        return null;
    }

    public void furnaceName(String displayName) {
        this.ovenName = displayName;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.ovenStacks[slot] != null) {
            ItemStack stack = this.ovenStacks[slot];
            this.ovenStacks[slot] = null;
            return stack;
        }
        return null;
    }

    public ItemStack getStackInRowAndColumn(int row, int column) {
        return this.func_70301_a(2 + row + column * 3);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.ovenStacks[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public int getFuelLevelScaled(int maxLevel) {
        float levelAbs = this.getFuelLevel();
        float capacity = this.fuelTank.getCapacity();
        float level = levelAbs / capacity;
        float scaled = level * (float)maxLevel;
        return (int)scaled;
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.ovenName : "container.netherbrickoven";
    }

    public int getFuelLevel() {
        return this.fuelTank.getFluidAmount();
    }

    public boolean func_145818_k_() {
        return this.ovenName != null && this.ovenName.length() > 0;
    }

    public void setFuelLevel(FluidStack fluid) {
        this.fuelTank.setFluid(fluid);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 1 ? false : (slot == 0 ? this.isItemFuelContainer(stack) : true);
    }
}

