/*
 * Decompiled with CFR 0.152.
 */
package net.einsteinsci.betterbeginnings.util;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NBTUtil {
    public static final byte TAG_END = 0;
    public static final byte TAG_BYTE = 1;
    public static final byte TAG_SHORT = 2;
    public static final byte TAG_INT = 3;
    public static final byte TAG_LONG = 4;
    public static final byte TAG_FLOAT = 5;
    public static final byte TAG_DOUBLE = 6;
    public static final byte TAG_BYTE_ARRAY = 7;
    public static final byte TAG_STRING = 8;
    public static final byte TAG_LIST = 9;
    public static final byte TAG_COMPOUND = 10;
    public static final byte TAG_INT_ARRAY = 11;

    public static NBTBase makeByType(byte typeCode, Object data) {
        switch (typeCode) {
            case 0: {
                return new NBTTagEnd();
            }
            case 1: {
                return new NBTTagByte(((Byte)data).byteValue());
            }
            case 2: {
                return new NBTTagShort(((Short)data).shortValue());
            }
            case 3: {
                return new NBTTagInt(((Integer)data).intValue());
            }
            case 4: {
                return new NBTTagLong(((Long)data).longValue());
            }
            case 5: {
                return new NBTTagFloat(((Float)data).floatValue());
            }
            case 6: {
                return new NBTTagDouble(((Double)data).doubleValue());
            }
            case 7: {
                return new NBTTagByteArray((byte[])data);
            }
            case 8: {
                return new NBTTagString((String)data);
            }
            case 9: {
                return new NBTTagList();
            }
            case 10: {
                return new NBTTagCompound();
            }
            case 11: {
                return new NBTTagIntArray((int[])data);
            }
        }
        return null;
    }

    public static void addBookEnchantment(ItemStack result, short id, short lvl) {
        if (result.func_77978_p() == null) {
            result.func_77982_d(new NBTTagCompound());
        }
        if (!result.func_77978_p().func_74764_b("StoredEnchantments")) {
            result.func_77978_p().func_74782_a("StoredEnchantments", (NBTBase)new NBTTagList());
        }
        NBTTagList enchList = result.func_77978_p().func_150295_c("StoredEnchantments", 10);
        NBTTagCompound ench = new NBTTagCompound();
        ench.func_74777_a("id", id);
        ench.func_74777_a("lvl", lvl);
        enchList.func_74742_a((NBTBase)ench);
    }
}

