/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.dpu.common.container;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import me.superckl.dpu.ItemHandler;
import me.superckl.dpu.common.container.SlotDisplay;
import me.superckl.dpu.common.container.SlotSearch;
import me.superckl.dpu.common.reference.ModItems;
import me.superckl.dpu.common.utlilty.ItemStackHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ContainerExcludify
extends Container {
    private final EntityPlayer player;
    private InventoryBasic inventoryActive;
    @SideOnly(value=Side.CLIENT)
    private InventoryBasic inventoryCreative;
    private InventoryBasic activeInventory;
    private float currentScroll;
    public List<ItemStack> itemList;
    @SideOnly(value=Side.CLIENT)
    private final Minecraft mc = Minecraft.func_71410_x();

    public ContainerExcludify(EntityPlayer player) {
        this.player = player;
        this.refreshActiveList();
        this.addActiveSlots();
    }

    @SideOnly(value=Side.CLIENT)
    public void refreshCreativeList() {
        this.itemList = new ArrayList<ItemStack>();
        for (Item item : ItemHandler.getAllItems()) {
            item.func_150895_a(item, CreativeTabs.field_78027_g, this.itemList);
        }
    }

    public void refreshActiveList() {
        this.itemList = new ArrayList<ItemStack>();
        ItemStack stack = this.player.func_70694_bm();
        if (stack == null || stack.func_77973_b() != ModItems.excludifier) {
            this.player.func_71053_j();
            return;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74782_a("items", (NBTBase)new NBTTagList());
            return;
        }
        NBTTagList list = stack.func_77978_p().func_150295_c("items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.itemList.add(ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(i)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addSearchSlots() {
        if (this.inventoryCreative == null) {
            this.inventoryCreative = new InventoryBasic("tmpCreative", false, 72);
        }
        this.clearInventory((IInventory)this.inventoryCreative);
        this.activeInventory = this.inventoryCreative;
        this.field_75151_b.clear();
        this.refreshCreativeList();
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new SlotSearch((IInventory)this.inventoryCreative, i * 9 + j, j * 18 + 9, i * 18 + 18));
            }
        }
        this.scrollTo(0.0f);
    }

    private void bindPlayerInventoryAt(int x, int y) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, j + i * 9 + 9, x + j * 18, y + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, i, x + i * 18, y + 58));
        }
    }

    public void addActiveSlots() {
        if (this.inventoryActive == null) {
            this.inventoryActive = new InventoryBasic("tmpActive", false, 27);
        }
        this.clearInventory((IInventory)this.activeInventory);
        this.activeInventory = this.inventoryActive;
        this.field_75151_b.clear();
        this.refreshActiveList();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new SlotDisplay((IInventory)this.inventoryActive, i * 9 + j, j * 18 + 9, i * 18 + 18));
            }
        }
        this.bindPlayerInventoryAt(9, 86);
        this.scrollTo(0.0f);
    }

    public void clearInventory(IInventory inventory) {
        if (inventory == null) {
            return;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            inventory.func_70299_a(i, null);
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return player == this.player;
    }

    public void func_75141_a(int p_75141_1_, ItemStack p_75141_2_) {
    }

    public void scrollTo(float scroll) {
        if (this.activeInventory == null) {
            return;
        }
        ItemStack stack = this.player.func_70694_bm();
        if (stack == null || stack.func_77973_b() != ModItems.excludifier) {
            this.player.func_71053_j();
            return;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74782_a("items", (NBTBase)new NBTTagList());
            return;
        }
        NBTTagList list = stack.func_77978_p().func_150295_c("items", 10);
        List<ItemStack> items = ItemStackHelper.convert(list);
        int i = this.itemList.size() / 9 - (this.activeInventory == this.inventoryActive ? 3 : 8) + 1;
        int j = (int)((double)(scroll * (float)i) + 0.5);
        if (j < 0) {
            j = 0;
        }
        for (int k = 0; k < (this.activeInventory == this.inventoryActive ? 3 : 8); ++k) {
            for (int l = 0; l < 9; ++l) {
                int i1 = l + (k + j) * 9;
                if (i1 >= 0 && i1 < this.itemList.size()) {
                    Slot slot;
                    ItemStack stack1 = this.itemList.get(i1);
                    this.activeInventory.func_70299_a(l + k * 9, stack1);
                    int index = ItemStackHelper.contains(items, stack1);
                    if (index != -1 && (slot = this.func_75139_a(l + k * 9)) instanceof SlotSearch) {
                        ((SlotSearch)slot).setSelected(true);
                        ((SlotSearch)slot).setSelectedIndex(index);
                        continue;
                    }
                    slot = this.func_75139_a(l + k * 9);
                    if (!(slot instanceof SlotSearch)) continue;
                    ((SlotSearch)slot).setSelected(false);
                    continue;
                }
                this.activeInventory.func_70299_a(l + k * 9, (ItemStack)null);
            }
        }
    }

    public void onActiveItemChange(int index, boolean added) {
        if (this.activeInventory != this.inventoryActive && !added) {
            for (Object obj : this.field_75151_b) {
                SlotSearch slot;
                if (!(obj instanceof SlotSearch) || !(slot = (SlotSearch)((Object)obj)).isSelected() || slot.getSelectedIndex() <= index) continue;
                slot.setSelectedIndex(slot.getSelectedIndex() - 1);
            }
            return;
        }
        if (this.activeInventory == this.inventoryActive) {
            this.refreshActiveList();
            this.scrollTo(this.currentScroll);
        }
    }

    protected void func_75133_b(int p_75133_1_, int p_75133_2_, boolean p_75133_3_, EntityPlayer p_75133_4_) {
    }

    public ItemStack func_82846_b(EntityPlayer p_82846_1_, int p_82846_2_) {
        return null;
    }
}

