/*
 * Decompiled with CFR 0.152.
 */
package com.andy.staffmod.biomes;

import com.andy.staffmod.StuffInitialiser;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class DarkCastleWorldGen
extends WorldGenerator {
    public DarkCastleWorldGen() {
    }

    public DarkCastleWorldGen(boolean b) {
        super(b);
    }

    private void spawnWall(World theWorld, Random r, int xPos, int yPos, int zPos, int direction, Block blockToUse) {
        boolean hadwindow = false;
        theWorld.func_147449_b(xPos, yPos + 1, zPos, blockToUse);
        theWorld.func_147449_b(xPos, yPos + 2, zPos, blockToUse);
        if (r.nextDouble() > 0.05) {
            theWorld.func_147449_b(xPos, yPos + 3, zPos, blockToUse);
        } else {
            theWorld.func_147465_d(xPos, yPos + 3, zPos, Blocks.field_150429_aA, 5, 2);
            hadwindow = true;
        }
        theWorld.func_147449_b(xPos, yPos + 4, zPos, blockToUse);
        int xDir = 1;
        int zDir = 0;
        int lDir = 4;
        if (direction == 2) {
            xDir = 0;
            zDir = 1;
            lDir = 2;
        }
        if (direction == 3) {
            xDir = -1;
            zDir = 0;
            lDir = 5;
        }
        if (direction == 4) {
            xDir = 0;
            zDir = -1;
            lDir = 3;
        }
        theWorld.func_147449_b(xPos + xDir, yPos + 4, zPos + zDir, blockToUse);
        theWorld.func_147449_b(xPos + xDir, yPos + 5, zPos + zDir, blockToUse);
        double d = r.nextDouble();
        if (!hadwindow && d > 0.8) {
            theWorld.func_147465_d(xPos - xDir, yPos + 1, zPos - zDir, Blocks.field_150468_ap, lDir, 2);
            theWorld.func_147465_d(xPos - xDir, yPos + 2, zPos - zDir, Blocks.field_150468_ap, lDir, 2);
            theWorld.func_147465_d(xPos - xDir, yPos + 3, zPos - zDir, Blocks.field_150468_ap, lDir, 2);
            theWorld.func_147465_d(xPos - xDir, yPos + 4, zPos - zDir, Blocks.field_150468_ap, lDir, 2);
        } else if (!hadwindow && d < 0.075) {
            theWorld.func_147449_b(xPos - xDir, yPos + 4, zPos - zDir, blockToUse);
            int modMeta = 50 + r.nextInt(6);
            String modName = "Zombie";
            if (modMeta == 51) {
                modName = "Skeleton";
            }
            if (modMeta == 52) {
                modName = "Spider";
            }
            if (modMeta == 53 && yPos > 80) {
                modName = "Blaze";
            }
            if (modMeta == 54) {
                modName = "Creeper";
            }
            this.mobSpawner(theWorld, xPos - xDir, yPos + 1, zPos - zDir, modName);
        } else if (!hadwindow && d > 0.15 && d < 0.22) {
            theWorld.func_147449_b(xPos - xDir, yPos + 4, zPos - zDir, blockToUse);
            String modName = "Skeleton";
            this.mobSpawner(theWorld, xPos, yPos + 5, zPos, modName);
        } else {
            theWorld.func_147449_b(xPos - xDir, yPos + 4, zPos - zDir, blockToUse);
        }
        boolean cren = false;
        if (direction == 1 || direction == 3) {
            if (zPos % 2 == 0) {
                cren = true;
            }
        } else if (xPos % 2 == 0) {
            cren = true;
        }
        if (cren) {
            theWorld.func_147449_b(xPos + xDir, yPos + 6, zPos + zDir, blockToUse);
        }
    }

    private void mobSpawner(World theWorld, int x, int y, int z, String mobName) {
        theWorld.func_147465_d(x, y, z, Blocks.field_150474_ac, 51, 2);
        TileEntityMobSpawner ms = (TileEntityMobSpawner)theWorld.func_147438_o(x, y, z);
        ms.func_145881_a().func_98272_a(mobName);
        theWorld.func_147455_a(x, y, z, (TileEntity)ms);
    }

    private void spawnWalls(World theWorld, Random r, int minX, int maxX, int yPos, int minZ, int maxZ) {
        for (int x = minX; x < maxX; ++x) {
            this.spawnWall(theWorld, r, x, yPos, minZ, 4, StuffInitialiser.castlewallrock);
            this.spawnWall(theWorld, r, x, yPos, maxZ, 2, StuffInitialiser.castlewallrock);
        }
        for (int z = minZ; z < maxZ; ++z) {
            this.spawnWall(theWorld, r, minX, yPos, z, 3, StuffInitialiser.castlewallrock);
            this.spawnWall(theWorld, r, maxX, yPos, z, 1, StuffInitialiser.castlewallrock);
        }
    }

    private void spawnMoat(World theWorld, Random r, int minX, int maxX, int yPos, int minZ, int maxZ) {
        for (int x = minX - 1; x < maxX + 1; ++x) {
            theWorld.func_147449_b(x, yPos, minZ - 1, Blocks.field_150353_l);
            theWorld.func_147449_b(x, yPos, maxZ + 1, Blocks.field_150353_l);
        }
        for (int z = minZ - 1; z < maxZ + 1; ++z) {
            theWorld.func_147449_b(minX - 1, yPos, z, Blocks.field_150353_l);
            theWorld.func_147449_b(maxX + 1, yPos, z, Blocks.field_150353_l);
        }
    }

    private void spawnTowers(World theWorld, Random r, int minX, int maxX, int yPos, int minZ, int maxZ) {
        int i;
        int y;
        int[][] towerWallTopRight = new int[][]{{-2, 1}, {-2, 2}, {-2, 3}, {-1, 3}, {0, 3}, {1, 3}, {2, 3}, {2, 3}, {3, 3}, {3, 2}, {3, 1}, {3, 0}, {3, -1}, {3, -2}, {2, -2}, {1, -2}};
        int[][] towerWallTopLeft = new int[][]{{2, 1}, {2, 2}, {2, 3}, {1, 3}, {0, 3}, {-1, 3}, {-2, 3}, {-2, 3}, {-3, 3}, {-3, 2}, {-3, 1}, {-3, 0}, {-3, -1}, {-3, -2}, {-2, -2}, {-1, -2}};
        int[][] towerWallBottomRight = new int[][]{{-2, -1}, {-2, -2}, {-2, -3}, {-1, -3}, {0, -3}, {1, -3}, {2, -3}, {2, -3}, {3, -3}, {3, -2}, {3, -1}, {3, 0}, {3, 1}, {3, 2}, {2, 2}, {1, 2}};
        int[][] towerWallBottomLeft = new int[][]{{2, -1}, {2, -2}, {2, -3}, {1, -3}, {0, -3}, {-1, -3}, {-2, -3}, {-2, -3}, {-3, -3}, {-3, -2}, {-3, -1}, {-3, 0}, {-3, 1}, {-3, 2}, {-2, 2}, {-1, 2}};
        int maxY = yPos + 5 + r.nextInt(30);
        for (y = yPos; y < maxY; ++y) {
            for (i = 0; i < towerWallTopRight.length; ++i) {
                if (r.nextDouble() > 0.02 || i == 0) {
                    theWorld.func_147449_b(maxX + towerWallTopRight[i][0], y, maxZ + towerWallTopRight[i][1], StuffInitialiser.castlerock);
                    continue;
                }
                theWorld.func_147465_d(maxX + towerWallTopRight[i][0], y, maxZ + towerWallTopRight[i][1], Blocks.field_150429_aA, 5, 2);
            }
            theWorld.func_147465_d(maxX + towerWallTopRight[0][0] + 1, y, maxZ + towerWallTopRight[0][1], Blocks.field_150468_ap, 5, 2);
        }
        theWorld.func_147449_b(maxX, maxY - 2, maxZ + 1, StuffInitialiser.castlewallrock);
        theWorld.func_147449_b(maxX + 1, maxY - 2, maxZ, StuffInitialiser.castlewallrock);
        theWorld.func_147449_b(maxX + 1, maxY - 2, maxZ + 1, StuffInitialiser.castlewallrock);
        theWorld.func_147449_b(maxX + 2, maxY - 2, maxZ + 1, StuffInitialiser.castlewallrock);
        theWorld.func_147449_b(maxX + 1, maxY - 2, maxZ + 2, StuffInitialiser.castlewallrock);
        theWorld.func_147449_b(maxX + 2, maxY - 2, maxZ + 2, StuffInitialiser.castlewallrock);
        this.mobSpawner(theWorld, maxX + 1, maxY - 1, maxZ + 1, "Skeleton");
        maxY = yPos + 5 + r.nextInt(30);
        for (y = yPos; y < maxY; ++y) {
            for (i = 0; i < towerWallTopLeft.length; ++i) {
                if (r.nextDouble() > 0.02 || i == 0) {
                    theWorld.func_147449_b(minX + towerWallTopLeft[i][0], y, maxZ + towerWallTopLeft[i][1], StuffInitialiser.castlerock);
                    continue;
                }
                theWorld.func_147465_d(minX + towerWallTopLeft[i][0], y, maxZ + towerWallTopLeft[i][1], Blocks.field_150429_aA, 5, 2);
            }
            theWorld.func_147465_d(minX + towerWallTopLeft[0][0] - 1, y, maxZ + towerWallTopLeft[0][1], Blocks.field_150468_ap, 4, 2);
        }
        theWorld.func_147449_b(minX, maxY - 2, maxZ + 1, StuffInitialiser.castlewallrock);
        theWorld.func_147449_b(minX - 1, maxY - 2, maxZ, StuffInitialiser.castlewallrock);
        theWorld.func_147449_b(minX - 1, maxY - 2, maxZ + 1, StuffInitialiser.castlewallrock);
        theWorld.func_147449_b(minX - 2, maxY - 2, maxZ + 1, StuffInitialiser.castlewallrock);
        theWorld.func_147449_b(minX - 1, maxY - 2, maxZ + 2, StuffInitialiser.castlewallrock);
        theWorld.func_147449_b(minX - 2, maxY - 2, maxZ + 2, StuffInitialiser.castlewallrock);
        this.mobSpawner(theWorld, minX - 1, maxY - 1, maxZ + 1, "Skeleton");
        maxY = yPos + 5 + r.nextInt(30);
        for (y = yPos; y < maxY; ++y) {
            for (i = 0; i < towerWallBottomRight.length; ++i) {
                if (r.nextDouble() > 0.02 || i == 0) {
                    theWorld.func_147449_b(maxX + towerWallBottomRight[i][0], y, minZ + towerWallBottomRight[i][1], StuffInitialiser.castlerock);
                    continue;
                }
                theWorld.func_147465_d(maxX + towerWallBottomRight[i][0], y, minZ + towerWallBottomRight[i][1], Blocks.field_150429_aA, 5, 2);
            }
            theWorld.func_147465_d(maxX + towerWallBottomRight[0][0] + 1, y, minZ + towerWallBottomRight[0][1], Blocks.field_150468_ap, 5, 2);
        }
        theWorld.func_147449_b(maxX, maxY - 2, minZ - 1, StuffInitialiser.castlewallrock);
        theWorld.func_147449_b(maxX + 1, maxY - 2, minZ, StuffInitialiser.castlewallrock);
        theWorld.func_147449_b(maxX + 1, maxY - 2, minZ - 1, StuffInitialiser.castlewallrock);
        theWorld.func_147449_b(maxX + 2, maxY - 2, minZ - 1, StuffInitialiser.castlewallrock);
        theWorld.func_147449_b(maxX + 1, maxY - 2, minZ - 2, StuffInitialiser.castlewallrock);
        theWorld.func_147449_b(maxX + 2, maxY - 2, minZ - 2, StuffInitialiser.castlewallrock);
        this.mobSpawner(theWorld, maxX + 1, maxY - 1, minZ - 1, "Skeleton");
        maxY = yPos + 5 + r.nextInt(30);
        for (y = yPos; y < maxY; ++y) {
            for (i = 0; i < towerWallBottomLeft.length; ++i) {
                if (r.nextDouble() > 0.02 || i == 0) {
                    theWorld.func_147449_b(minX + towerWallBottomLeft[i][0], y, minZ + towerWallBottomLeft[i][1], StuffInitialiser.castlerock);
                    continue;
                }
                theWorld.func_147465_d(minX + towerWallBottomLeft[i][0], y, minZ + towerWallBottomLeft[i][1], Blocks.field_150429_aA, 5, 2);
            }
            theWorld.func_147465_d(minX + towerWallBottomLeft[0][0] - 1, y, minZ + towerWallBottomLeft[0][1], Blocks.field_150468_ap, 4, 2);
        }
        theWorld.func_147449_b(minX - 1, maxY - 2, minZ, StuffInitialiser.castlewallrock);
        theWorld.func_147449_b(minX, maxY - 2, minZ - 1, StuffInitialiser.castlewallrock);
        theWorld.func_147449_b(minX - 1, maxY - 2, minZ - 1, StuffInitialiser.castlewallrock);
        theWorld.func_147449_b(minX - 2, maxY - 2, minZ - 1, StuffInitialiser.castlewallrock);
        theWorld.func_147449_b(minX - 1, maxY - 2, minZ - 2, StuffInitialiser.castlewallrock);
        theWorld.func_147449_b(minX - 2, maxY - 2, minZ - 2, StuffInitialiser.castlewallrock);
        this.mobSpawner(theWorld, minX - 1, maxY - 1, minZ - 1, "Skeleton");
    }

    private void spawnChest(World theWorld, Random r, int x, int y, int z) {
        theWorld.func_147449_b(x, y, z, (Block)Blocks.field_150486_ae);
        TileEntityChest cs = (TileEntityChest)theWorld.func_147438_o(x, y, z);
        for (int pos = 0; pos < cs.func_70302_i_(); ++pos) {
            if (!(r.nextDouble() < 0.15)) continue;
            ItemStack theStack = new ItemStack(StuffInitialiser.wormwoodStaveItem, 10 + r.nextInt(10));
            switch (r.nextInt(8)) {
                case 0: {
                    theStack = new ItemStack(Items.field_151137_ax, 10 + r.nextInt(20));
                    break;
                }
                case 1: {
                    theStack = new ItemStack(Items.field_151043_k, 5 + r.nextInt(10));
                    break;
                }
                case 2: {
                    theStack = new ItemStack(Items.field_151042_j, 5 + r.nextInt(10));
                    break;
                }
                case 3: {
                    theStack = new ItemStack(Blocks.field_150335_W, 5 + r.nextInt(10));
                    break;
                }
                case 4: {
                    theStack = new ItemStack(Items.field_151133_ar, 5 + r.nextInt(10));
                    break;
                }
                case 5: {
                    theStack = new ItemStack(Blocks.field_150359_w, 5 + r.nextInt(10));
                    break;
                }
            }
            cs.func_70299_a(pos, theStack);
        }
        theWorld.func_147455_a(x, y, z, (TileEntity)cs);
    }

    private void spawnKeep(World theWorld, Random r, int minX, int maxX, int yPos, int minZ, int maxZ) {
        int numLevels = 2 + r.nextInt(10);
        for (int i = 0; i < numLevels; ++i) {
            int x;
            for (x = minX; x < maxX; ++x) {
                this.spawnWall(theWorld, r, x, yPos, minZ, 4, StuffInitialiser.castlerock);
                this.spawnWall(theWorld, r, x, yPos, maxZ, 2, StuffInitialiser.castlerock);
            }
            for (int z = minZ; z < maxZ; ++z) {
                this.spawnWall(theWorld, r, minX, yPos, z, 3, StuffInitialiser.castlerock);
                this.spawnWall(theWorld, r, maxX, yPos, z, 1, StuffInitialiser.castlerock);
            }
            for (x = minX + 2; x < maxX - 1; ++x) {
                for (int z = minZ + 2; z < maxZ - 1; ++z) {
                    theWorld.func_147449_b(x, yPos, z, StuffInitialiser.darkstaffwood);
                    if (r.nextInt(100) >= i) continue;
                    this.spawnChest(theWorld, r, x, yPos + 1, z);
                }
            }
            if (i == 0) {
                if (r.nextBoolean()) {
                    int zPos = minZ + (maxZ - minZ) / 2;
                    theWorld.func_147449_b(minX, yPos + 1, zPos, Blocks.field_150350_a);
                    theWorld.func_147449_b(minX, yPos + 2, zPos, Blocks.field_150350_a);
                    theWorld.func_147449_b(minX, yPos + 1, zPos + 1, Blocks.field_150350_a);
                    theWorld.func_147449_b(minX, yPos + 2, zPos + 1, Blocks.field_150350_a);
                } else {
                    int xPos = minX + (maxX - minX) / 2;
                    theWorld.func_147449_b(xPos, yPos + 1, minZ, Blocks.field_150350_a);
                    theWorld.func_147449_b(xPos, yPos + 2, minZ, Blocks.field_150350_a);
                    theWorld.func_147449_b(xPos + 1, yPos + 1, minZ, Blocks.field_150350_a);
                    theWorld.func_147449_b(xPos + 1, yPos + 2, minZ, Blocks.field_150350_a);
                }
            }
            yPos += 4;
        }
        yPos += 3;
        while (maxZ >= minZ && maxX >= minX) {
            for (int x = minX; x < maxX + 1; ++x) {
                theWorld.func_147449_b(x, yPos, minZ, Blocks.field_150385_bj);
                theWorld.func_147449_b(x, yPos, maxZ, Blocks.field_150385_bj);
            }
            for (int z = minZ; z < maxZ + 1; ++z) {
                theWorld.func_147449_b(minX, yPos, z, Blocks.field_150385_bj);
                theWorld.func_147449_b(maxX, yPos, z, Blocks.field_150385_bj);
            }
            ++minZ;
            --maxZ;
            ++minX;
            --maxX;
            if (!r.nextBoolean()) continue;
            ++yPos;
        }
    }

    public boolean func_76484_a(World theWorld, Random r, int xPos, int yPos, int zPos) {
        System.out.print("DarkCastleWorldGen My Mod..! xPos " + xPos + " yPos" + yPos + " zPos" + zPos + " \n");
        int xSize = 6 + r.nextInt(13);
        int zSize = 6 + r.nextInt(13);
        int minX = xPos - xSize;
        int maxX = xPos + xSize;
        int minZ = zPos - zSize;
        int maxZ = zPos + zSize;
        for (int x = xPos - xSize; x < xPos + xSize; ++x) {
            for (int z = zPos - zSize; z < zPos + zSize; ++z) {
                int y;
                theWorld.func_147449_b(x, yPos, z, Blocks.field_150343_Z);
                for (y = yPos - 1; y > 3; --y) {
                    if (theWorld.func_147439_a(x, y, z) == Blocks.field_150350_a) {
                        theWorld.func_147449_b(x, y, z, Blocks.field_150343_Z);
                        continue;
                    }
                    theWorld.func_147449_b(x, y, z, Blocks.field_150343_Z);
                    y = 0;
                }
                for (y = yPos + 1; y < 130; ++y) {
                    if (theWorld.func_147439_a(x, y, z) == Blocks.field_150350_a || theWorld.func_147439_a(x, y, z) == Blocks.field_150385_bj || theWorld.func_147439_a(x, y, z) == StuffInitialiser.castlerock || theWorld.func_147439_a(x, y, z) == StuffInitialiser.castlewallrock) continue;
                    theWorld.func_147449_b(x, y, z, Blocks.field_150350_a);
                }
            }
        }
        if (r.nextInt(5) == 3) {
            this.spawnMoat(theWorld, r, minX, maxX, yPos, minZ, maxZ);
        }
        this.spawnWalls(theWorld, r, minX, maxX, yPos, minZ, maxZ);
        if (r.nextBoolean()) {
            int zPos2 = minZ + (maxZ - minZ) / 2;
            theWorld.func_147449_b(minX, yPos + 1, zPos2, Blocks.field_150411_aY);
            theWorld.func_147449_b(minX, yPos + 2, zPos2, Blocks.field_150411_aY);
            theWorld.func_147449_b(minX, yPos + 1, zPos2 + 1, Blocks.field_150411_aY);
            theWorld.func_147449_b(minX, yPos + 2, zPos2 + 1, Blocks.field_150411_aY);
        } else {
            int xPos2 = minX + (maxX - minX) / 2;
            theWorld.func_147449_b(xPos2, yPos + 1, minZ, Blocks.field_150411_aY);
            theWorld.func_147449_b(xPos2, yPos + 2, minZ, Blocks.field_150411_aY);
            theWorld.func_147449_b(xPos2 + 1, yPos + 1, minZ, Blocks.field_150411_aY);
            theWorld.func_147449_b(xPos2 + 1, yPos + 2, minZ, Blocks.field_150411_aY);
        }
        this.spawnTowers(theWorld, r, minX, maxX, yPos, minZ, maxZ);
        int cspace = 4 + r.nextInt(3);
        if ((maxX -= cspace) - (minX += cspace) < 4 || (maxZ -= cspace) - (minZ += cspace) < 4) {
            return false;
        }
        this.spawnKeep(theWorld, r, minX, maxX, yPos, minZ, maxZ);
        return false;
    }
}

