/*
 * Decompiled with CFR 0.152.
 */
package com.andy.staffmod.biomes;

import com.andy.staffmod.StuffInitialiser;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class DarkShedWorldGen
extends WorldGenerator {
    public DarkShedWorldGen() {
    }

    public DarkShedWorldGen(boolean b) {
        super(b);
    }

    private void spawnShedWall(World theWorld, Random r, int xPos, int yPos, int zPos, int direction, Block blockToUse, boolean isdoor) {
        boolean hadwindow = false;
        if (!isdoor) {
            theWorld.func_147449_b(xPos, yPos + 1, zPos, blockToUse);
            theWorld.func_147449_b(xPos, yPos + 2, zPos, blockToUse);
        }
        if (r.nextDouble() > 0.07 || isdoor) {
            theWorld.func_147449_b(xPos, yPos + 3, zPos, blockToUse);
        } else {
            theWorld.func_147465_d(xPos, yPos + 3, zPos, Blocks.field_150429_aA, 5, 2);
            hadwindow = true;
        }
        theWorld.func_147449_b(xPos, yPos + 4, zPos, blockToUse);
        int xDir = 1;
        int zDir = 0;
        int lDir = 4;
        if (direction == 2) {
            xDir = 0;
            zDir = 1;
            lDir = 2;
        }
        if (direction == 3) {
            xDir = -1;
            zDir = 0;
            lDir = 5;
        }
        if (direction == 4) {
            xDir = 0;
            zDir = -1;
            lDir = 3;
        }
        theWorld.func_147449_b(xPos + xDir, yPos + 4, zPos + zDir, blockToUse);
        theWorld.func_147449_b(xPos + xDir, yPos + 5, zPos + zDir, blockToUse);
        double d = r.nextDouble();
        if (!hadwindow && d > 0.8) {
            theWorld.func_147465_d(xPos - xDir, yPos + 1, zPos - zDir, Blocks.field_150468_ap, lDir, 2);
            theWorld.func_147465_d(xPos - xDir, yPos + 2, zPos - zDir, Blocks.field_150468_ap, lDir, 2);
            theWorld.func_147465_d(xPos - xDir, yPos + 3, zPos - zDir, Blocks.field_150468_ap, lDir, 2);
            theWorld.func_147465_d(xPos - xDir, yPos + 4, zPos - zDir, Blocks.field_150468_ap, lDir, 2);
        } else if (!hadwindow && d < 0.05) {
            theWorld.func_147449_b(xPos - xDir, yPos + 4, zPos - zDir, blockToUse);
            int modMeta = r.nextInt(3);
            String mobName = "Zombie";
            if (modMeta == 1) {
                mobName = "Skeleton";
            }
            if (modMeta == 2) {
                mobName = "Creeper";
            }
            this.mobSpawner(theWorld, xPos - xDir, yPos + 1, zPos - zDir, mobName);
        } else {
            theWorld.func_147449_b(xPos - xDir, yPos + 4, zPos - zDir, blockToUse);
        }
        theWorld.func_147449_b(xPos + xDir, yPos + 5, zPos + zDir, Blocks.field_150343_Z);
    }

    private void mobSpawner(World theWorld, int x, int y, int z, String mobName) {
        theWorld.func_147465_d(x, y, z, Blocks.field_150474_ac, 51, 2);
        TileEntityMobSpawner ms = (TileEntityMobSpawner)theWorld.func_147438_o(x, y, z);
        ms.func_145881_a().func_98272_a(mobName);
        theWorld.func_147455_a(x, y, z, (TileEntity)ms);
    }

    private void spawnWalls(World theWorld, Random r, int minX, int maxX, int yPos, int minZ, int maxZ) {
        boolean hasdoor = false;
        for (int x = minX; x < maxX; ++x) {
            hasdoor = false;
            if (r.nextDouble() < 0.05) {
                hasdoor = true;
            }
            this.spawnShedWall(theWorld, r, x, yPos, minZ, 4, StuffInitialiser.castlewallrock, hasdoor);
            hasdoor = false;
            if (r.nextDouble() < 0.05) {
                hasdoor = true;
            }
            this.spawnShedWall(theWorld, r, x, yPos, maxZ, 2, StuffInitialiser.castlewallrock, hasdoor);
        }
        for (int z = minZ; z < maxZ; ++z) {
            hasdoor = false;
            if (r.nextDouble() < 0.05) {
                hasdoor = true;
            }
            this.spawnShedWall(theWorld, r, minX, yPos, z, 3, StuffInitialiser.castlewallrock, hasdoor);
            hasdoor = false;
            if (r.nextDouble() < 0.05) {
                hasdoor = true;
            }
            this.spawnShedWall(theWorld, r, maxX, yPos, z, 1, StuffInitialiser.castlewallrock, hasdoor);
        }
    }

    private void spawnChest(World theWorld, Random r, int x, int y, int z) {
        theWorld.func_147449_b(x, y, z, (Block)Blocks.field_150486_ae);
        TileEntityChest cs = (TileEntityChest)theWorld.func_147438_o(x, y, z);
        for (int pos = 0; pos < cs.func_70302_i_(); ++pos) {
            if (!(r.nextDouble() < 0.4)) continue;
            ItemStack theStack = new ItemStack(Items.field_151048_u);
            switch (r.nextInt(11)) {
                case 0: {
                    theStack = new ItemStack(Items.field_151048_u);
                    break;
                }
                case 1: {
                    theStack = new ItemStack(Items.field_151046_w);
                    break;
                }
                case 2: {
                    theStack = new ItemStack(Items.field_151033_d);
                    break;
                }
                case 3: {
                    theStack = new ItemStack(Blocks.field_150335_W, 5 + r.nextInt(20));
                    break;
                }
                case 4: {
                    theStack = new ItemStack((Item)Items.field_151175_af);
                    break;
                }
                case 5: {
                    theStack = new ItemStack((Item)Items.field_151163_ad);
                    break;
                }
                case 6: {
                    theStack = new ItemStack((Item)Items.field_151161_ac);
                    break;
                }
                case 7: {
                    theStack = new ItemStack((Item)Items.field_151173_ae);
                    break;
                }
                case 8: {
                    theStack = new ItemStack((Item)Items.field_151031_f);
                    break;
                }
                case 9: {
                    theStack = new ItemStack(Items.field_151032_g, 5 + r.nextInt(20));
                    break;
                }
                case 10: {
                    theStack = new ItemStack(Items.field_151012_L);
                    break;
                }
            }
            cs.func_70299_a(pos, theStack);
        }
        theWorld.func_147455_a(x, y, z, (TileEntity)cs);
    }

    private void spawnRoof(World theWorld, Random r, int minX, int maxX, int yPos, int minZ, int maxZ) {
        yPos += 6;
        while (maxZ >= minZ && maxX >= minX) {
            for (int x = minX; x < maxX + 1; ++x) {
                theWorld.func_147449_b(x, yPos, minZ, Blocks.field_150385_bj);
                theWorld.func_147449_b(x, yPos, maxZ, Blocks.field_150385_bj);
            }
            for (int z = minZ; z < maxZ + 1; ++z) {
                theWorld.func_147449_b(minX, yPos, z, Blocks.field_150385_bj);
                theWorld.func_147449_b(maxX, yPos, z, Blocks.field_150385_bj);
            }
            ++minZ;
            --maxZ;
            ++minX;
            --maxX;
            if (!r.nextBoolean()) continue;
            ++yPos;
        }
    }

    public boolean func_76484_a(World theWorld, Random r, int xPos, int yPos, int zPos) {
        System.out.print("DarkPitWorldGen My Mod..! xPos " + xPos + " yPos" + yPos + " zPos" + zPos + " \n");
        int xSize = 5;
        int zSize = 5;
        int minX = xPos - xSize;
        int maxX = xPos + xSize;
        int minZ = zPos - zSize;
        int maxZ = zPos + zSize;
        for (int x = xPos - xSize; x < xPos + xSize; ++x) {
            for (int z = zPos - zSize; z < zPos + zSize; ++z) {
                int y;
                theWorld.func_147449_b(x, yPos, z, Blocks.field_150343_Z);
                for (y = yPos - 1; y > 3; --y) {
                    if (theWorld.func_147439_a(x, y, z) == Blocks.field_150350_a) {
                        theWorld.func_147449_b(x, y, z, Blocks.field_150343_Z);
                        continue;
                    }
                    theWorld.func_147449_b(x, y, z, Blocks.field_150343_Z);
                    y = 0;
                }
                for (y = yPos + 1; y < 130; ++y) {
                    if (theWorld.func_147439_a(x, y, z) == Blocks.field_150350_a || theWorld.func_147439_a(x, y, z) == Blocks.field_150385_bj || theWorld.func_147439_a(x, y, z) == StuffInitialiser.castlerock || theWorld.func_147439_a(x, y, z) == StuffInitialiser.castlewallrock) continue;
                    theWorld.func_147449_b(x, y, z, Blocks.field_150350_a);
                }
            }
        }
        this.spawnWalls(theWorld, r, minX, maxX, yPos, minZ, maxZ);
        this.spawnRoof(theWorld, r, minX, maxX, yPos, minZ, maxZ);
        this.spawnChest(theWorld, r, minX + 2, yPos + 1, minZ + 2);
        return false;
    }
}

