/*
 * Decompiled with CFR 0.152.
 */
package squeek.quakemovement;

import api.player.client.ClientPlayerAPI;
import api.player.client.ClientPlayerBase;
import cpw.mods.fml.common.Loader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import squeek.quakemovement.ModConfig;

public class QuakeClientPlayer
extends ClientPlayerBase {
    public boolean didJumpThisTick = false;
    List<float[]> baseVelocities = new ArrayList<float[]>();
    private static Class<?> hudSpeedometer = null;
    private static Method setDidJumpThisTick = null;
    private static Method setIsJumping = null;

    public QuakeClientPlayer(ClientPlayerAPI playerapi) {
        super(playerapi);
    }

    public void moveEntityWithHeading(float sidemove, float forwardmove) {
        double d0 = this.player.field_70165_t;
        double d1 = this.player.field_70163_u;
        double d2 = this.player.field_70161_v;
        if (this.player.field_71075_bZ.field_75100_b && this.player.field_70154_o == null) {
            super.moveEntityWithHeading(sidemove, forwardmove);
        } else {
            this.quake_moveEntityWithHeading(sidemove, forwardmove);
        }
        this.player.func_71000_j(this.player.field_70165_t - d0, this.player.field_70163_u - d1, this.player.field_70161_v - d2);
    }

    public void beforeOnLivingUpdate() {
        this.didJumpThisTick = false;
        if (setDidJumpThisTick != null) {
            try {
                setDidJumpThisTick.invoke(null, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.baseVelocities.isEmpty()) {
            this.baseVelocities.clear();
        }
        super.beforeOnLivingUpdate();
    }

    public void onLivingUpdate() {
        if (setIsJumping != null) {
            try {
                setIsJumping.invoke(null, this.playerAPI.getIsJumpingField());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.onLivingUpdate();
    }

    public void moveFlying(float sidemove, float forwardmove, float wishspeed) {
        if (this.player.field_71075_bZ.field_75100_b && this.player.field_70154_o == null || this.player.func_70090_H()) {
            super.moveFlying(sidemove, forwardmove, wishspeed);
            return;
        }
        float[] wishdir = this.getMovementDirection(sidemove, forwardmove);
        float[] wishvel = new float[]{wishdir[0] * (wishspeed *= 2.15f), wishdir[1] * wishspeed};
        this.baseVelocities.add(wishvel);
    }

    public void jump() {
        super.jump();
        if (this.player.func_70051_ag()) {
            float f = this.player.field_70177_z * ((float)Math.PI / 180);
            this.player.field_70159_w += (double)(MathHelper.func_76126_a((float)f) * 0.2f);
            this.player.field_70179_y -= (double)(MathHelper.func_76134_b((float)f) * 0.2f);
        }
        this.quake_Jump();
        this.didJumpThisTick = true;
        if (setDidJumpThisTick != null) {
            try {
                setDidJumpThisTick.invoke(null, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public double getSpeed() {
        return MathHelper.func_76133_a((double)(this.player.field_70159_w * this.player.field_70159_w + this.player.field_70179_y * this.player.field_70179_y));
    }

    public float getSurfaceFriction() {
        float f2 = 1.0f;
        if (this.player.field_70122_E) {
            Block ground = this.player.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.player.field_70165_t), MathHelper.func_76128_c((double)this.player.field_70121_D.field_72338_b) - 1, MathHelper.func_76128_c((double)this.player.field_70161_v));
            f2 = 1.0f - ground.field_149765_K;
        }
        return f2;
    }

    public float getSlipperiness() {
        float f2 = 0.91f;
        if (this.player.field_70122_E) {
            f2 = 0.54600006f;
            Block ground = this.player.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.player.field_70165_t), MathHelper.func_76128_c((double)this.player.field_70121_D.field_72338_b) - 1, MathHelper.func_76128_c((double)this.player.field_70161_v));
            if (ground != null) {
                f2 = ground.field_149765_K * 0.91f;
            }
        }
        return f2;
    }

    public float minecraft_getMoveSpeed() {
        float f2 = this.getSlipperiness();
        float f3 = 0.16277136f / (f2 * f2 * f2);
        return this.player.func_70689_ay() * f3;
    }

    public float[] getMovementDirection(float sidemove, float forwardmove) {
        float f3 = sidemove * sidemove + forwardmove * forwardmove;
        float[] dir = new float[]{0.0f, 0.0f};
        if (f3 >= 1.0E-4f) {
            if ((f3 = MathHelper.func_76129_c((float)f3)) < 1.0f) {
                f3 = 1.0f;
            }
            f3 = 1.0f / f3;
            float f4 = MathHelper.func_76126_a((float)(this.player.field_70177_z * (float)Math.PI / 180.0f));
            float f5 = MathHelper.func_76134_b((float)(this.player.field_70177_z * (float)Math.PI / 180.0f));
            dir[0] = (sidemove *= f3) * f5 - (forwardmove *= f3) * f4;
            dir[1] = forwardmove * f5 + sidemove * f4;
        }
        return dir;
    }

    public float quake_getMoveSpeed() {
        float baseSpeed = this.player.func_70689_ay();
        return !this.player.func_70093_af() ? baseSpeed * 2.15f : baseSpeed * 1.11f;
    }

    public float quake_getMaxMoveSpeed() {
        float baseSpeed = this.player.func_70689_ay();
        return baseSpeed * 2.15f;
    }

    private void spawnBunnyhopParticles(int numParticles) {
        int k;
        int i;
        int j = MathHelper.func_76128_c((double)this.player.field_70165_t);
        Block ground = this.player.field_70170_p.func_147439_a(j, i = MathHelper.func_76128_c((double)(this.player.field_70163_u - (double)0.2f - (double)this.player.field_70129_M)), k = MathHelper.func_76128_c((double)this.player.field_70161_v));
        if (ground != null && ground.func_149688_o() != Material.field_151579_a) {
            for (int iParticle = 0; iParticle < numParticles; ++iParticle) {
                this.player.field_70170_p.func_72869_a("blockcrack_" + Block.func_149682_b((Block)ground) + "_" + this.player.field_70170_p.func_72805_g(j, i, k), this.player.field_70165_t + ((double)this.playerAPI.getRandField().nextFloat() - 0.5) * (double)this.player.field_70130_N, this.player.field_70121_D.field_72338_b + 0.1, this.player.field_70161_v + ((double)this.playerAPI.getRandField().nextFloat() - 0.5) * (double)this.player.field_70130_N, -this.player.field_70159_w * 4.0, 1.5, -this.player.field_70179_y * 4.0);
            }
        }
    }

    public boolean isJumping() {
        return this.playerAPI.getIsJumpingField();
    }

    private void minecraft_ApplyGravity() {
        this.player.field_70181_x = !(!this.player.field_70170_p.field_72995_K || this.player.field_70170_p.func_72899_e((int)this.player.field_70165_t, 0, (int)this.player.field_70161_v) && this.player.field_70170_p.func_72938_d((int)((int)this.player.field_70165_t), (int)((int)this.player.field_70161_v)).field_76636_d) ? (this.player.field_70163_u > 0.0 ? -0.1 : 0.0) : (this.player.field_70181_x -= 0.08);
        this.player.field_70181_x *= (double)0.98f;
    }

    private void minecraft_ApplyFriction(float momentumRetention) {
        this.player.field_70159_w *= (double)momentumRetention;
        this.player.field_70179_y *= (double)momentumRetention;
    }

    private void minecraft_ApplyLadderPhysics() {
        if (this.player.func_70617_f_()) {
            boolean flag;
            float f5 = 0.15f;
            if (this.player.field_70159_w < (double)(-f5)) {
                this.player.field_70159_w = -f5;
            }
            if (this.player.field_70159_w > (double)f5) {
                this.player.field_70159_w = f5;
            }
            if (this.player.field_70179_y < (double)(-f5)) {
                this.player.field_70179_y = -f5;
            }
            if (this.player.field_70179_y > (double)f5) {
                this.player.field_70179_y = f5;
            }
            this.player.field_70143_R = 0.0f;
            if (this.player.field_70181_x < -0.15) {
                this.player.field_70181_x = -0.15;
            }
            if ((flag = this.player.func_70093_af()) && this.player.field_70181_x < 0.0) {
                this.player.field_70181_x = 0.0;
            }
        }
    }

    private void minecraft_ClimbLadder() {
        if (this.player.field_70123_F && this.player.func_70617_f_()) {
            this.player.field_70181_x = 0.2;
        }
    }

    private void minecraft_SwingLimbsBasedOnMovement() {
        this.player.field_70722_aY = this.player.field_70721_aZ;
        double d0 = this.player.field_70165_t - this.player.field_70169_q;
        double d1 = this.player.field_70161_v - this.player.field_70166_s;
        float f6 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1)) * 4.0f;
        if (f6 > 1.0f) {
            f6 = 1.0f;
        }
        this.player.field_70721_aZ += (f6 - this.player.field_70721_aZ) * 0.4f;
        this.player.field_70754_ba += this.player.field_70721_aZ;
    }

    private void minecraft_WaterMove(float sidemove, float forwardmove) {
        double d0 = this.player.field_70163_u;
        this.player.func_70060_a(sidemove, forwardmove, 0.04f);
        this.player.func_70091_d(this.player.field_70159_w, this.player.field_70181_x, this.player.field_70179_y);
        this.player.field_70159_w *= (double)0.8f;
        this.player.field_70181_x *= (double)0.8f;
        this.player.field_70179_y *= (double)0.8f;
        this.player.field_70181_x -= 0.02;
        if (this.player.field_70123_F && this.player.func_70038_c(this.player.field_70159_w, this.player.field_70181_x + (double)0.6f - this.player.field_70163_u + d0, this.player.field_70179_y)) {
            this.player.field_70181_x = 0.3f;
        }
    }

    public void minecraft_moveEntityWithHeading(float sidemove, float forwardmove) {
        if (this.player.func_70090_H() && !this.player.field_71075_bZ.field_75100_b || this.player.func_70058_J() && !this.player.field_71075_bZ.field_75100_b) {
            super.moveEntityWithHeading(sidemove, forwardmove);
        } else {
            float momentumRetention = this.getSlipperiness();
            this.player.func_70060_a(sidemove, forwardmove, this.minecraft_getMoveSpeed());
            this.minecraft_ApplyLadderPhysics();
            this.player.func_70091_d(this.player.field_70159_w, this.player.field_70181_x, this.player.field_70179_y);
            this.minecraft_ClimbLadder();
            this.minecraft_ApplyGravity();
            this.minecraft_ApplyFriction(momentumRetention);
            this.minecraft_SwingLimbsBasedOnMovement();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void quake_moveEntityWithHeading(float sidemove, float forwardmove) {
        if (this.player.func_70058_J() && !this.player.field_71075_bZ.field_75100_b) {
            super.moveEntityWithHeading(sidemove, forwardmove);
            return;
        }
        if (this.player.func_70090_H() && !this.player.field_71075_bZ.field_75100_b) {
            if (!ModConfig.SHARKING_ENABLED) {
                super.moveEntityWithHeading(sidemove, forwardmove);
                return;
            }
            this.quake_WaterMove(sidemove, forwardmove);
        } else {
            float wishspeed = sidemove != 0.0f || forwardmove != 0.0f ? this.quake_getMoveSpeed() : 0.0f;
            float[] wishdir = this.getMovementDirection(sidemove, forwardmove);
            boolean onGroundForReal = this.player.field_70122_E && !this.isJumping();
            float momentumRetention = this.getSlipperiness();
            if (onGroundForReal) {
                this.minecraft_ApplyFriction(momentumRetention);
                double sv_accelerate = ModConfig.ACCELERATE;
                if (wishspeed != 0.0f) {
                    this.quake_Accelerate(wishspeed, wishdir[0], wishdir[1], sv_accelerate *= (double)(this.minecraft_getMoveSpeed() * 2.15f / wishspeed));
                }
                if (!this.baseVelocities.isEmpty()) {
                    float speedMod = wishspeed / this.quake_getMaxMoveSpeed();
                    for (float[] baseVel : this.baseVelocities) {
                        this.player.field_70159_w += (double)(baseVel[0] * speedMod);
                        this.player.field_70179_y += (double)(baseVel[1] * speedMod);
                    }
                }
            } else {
                AxisAlignedBB axisalignedbb;
                boolean isFallingIntoWater;
                double sv_airaccelerate = ModConfig.AIR_ACCELERATE;
                this.quake_AirAccelerate(wishspeed, wishdir[0], wishdir[1], sv_airaccelerate);
                if (ModConfig.SHARKING_ENABLED && ModConfig.SHARKING_SURFACE_TENSION > 0.0 && this.playerAPI.getIsJumpingField() && this.player.field_70181_x < 0.0 && (isFallingIntoWater = this.player.field_70170_p.func_72953_d(axisalignedbb = this.player.field_70121_D.func_72325_c(this.player.field_70159_w, this.player.field_70181_x, this.player.field_70179_y)))) {
                    this.player.field_70181_x *= ModConfig.SHARKING_SURFACE_TENSION;
                }
            }
            this.minecraft_ApplyLadderPhysics();
            this.player.func_70091_d(this.player.field_70159_w, this.player.field_70181_x, this.player.field_70179_y);
            this.minecraft_ClimbLadder();
            this.minecraft_ApplyGravity();
        }
        this.minecraft_SwingLimbsBasedOnMovement();
    }

    private void quake_Jump() {
        this.quake_ApplySoftCap(this.quake_getMaxMoveSpeed());
        boolean didTrimp = this.quake_DoTrimp();
        if (!didTrimp) {
            this.quake_ApplyHardCap(this.quake_getMaxMoveSpeed());
        }
    }

    private boolean quake_DoTrimp() {
        float movespeed;
        double curspeed;
        if (ModConfig.TRIMPING_ENABLED && this.player.func_70093_af() && (curspeed = this.getSpeed()) > (double)(movespeed = this.quake_getMaxMoveSpeed())) {
            double speedbonus = curspeed / (double)movespeed * 0.5;
            if (speedbonus > 1.0) {
                speedbonus = 1.0;
            }
            this.player.field_70181_x += speedbonus * curspeed * (double)ModConfig.TRIMP_MULTIPLIER;
            if (ModConfig.TRIMP_MULTIPLIER > 0.0f) {
                float mult = 1.0f / ModConfig.TRIMP_MULTIPLIER;
                this.player.field_70159_w *= (double)mult;
                this.player.field_70179_y *= (double)mult;
            }
            this.spawnBunnyhopParticles(30);
            return true;
        }
        return false;
    }

    private void quake_ApplyWaterFriction(double friction) {
        this.player.field_70159_w *= friction;
        this.player.field_70181_x *= friction;
        this.player.field_70179_y *= friction;
    }

    private void quake_WaterAccelerate(float wishspeed, float speed, double wishX, double wishZ, double accel) {
        float addspeed = wishspeed - speed;
        if (addspeed > 0.0f) {
            float accelspeed = (float)(accel * (double)wishspeed * (double)0.05f);
            if (accelspeed > addspeed) {
                accelspeed = addspeed;
            }
            this.player.field_70159_w += (double)accelspeed * wishX;
            this.player.field_70179_y += (double)accelspeed * wishZ;
        }
    }

    private void quake_WaterMove(float sidemove, float forwardmove) {
        double lastPosY = this.player.field_70163_u;
        float wishspeed = sidemove != 0.0f || forwardmove != 0.0f ? this.quake_getMaxMoveSpeed() : 0.0f;
        float[] wishdir = this.getMovementDirection(sidemove, forwardmove);
        boolean isSharking = this.isJumping() && this.player.func_70038_c(0.0, 1.0, 0.0);
        double curspeed = this.getSpeed();
        if (!isSharking || curspeed < (double)0.078f) {
            this.minecraft_WaterMove(sidemove, forwardmove);
        } else {
            if (curspeed > 0.09) {
                this.quake_ApplyWaterFriction(ModConfig.SHARKING_WATER_FRICTION);
            }
            if (curspeed > 0.098) {
                this.quake_AirAccelerate(wishspeed, wishdir[0], wishdir[1], ModConfig.ACCELERATE);
            } else {
                this.quake_Accelerate(0.098f, wishdir[0], wishdir[1], ModConfig.ACCELERATE);
            }
            this.player.func_70091_d(this.player.field_70159_w, this.player.field_70181_x, this.player.field_70179_y);
            this.player.field_70181_x = 0.0;
        }
        if (this.player.field_70123_F && this.player.func_70038_c(this.player.field_70159_w, this.player.field_70181_x + (double)0.6f - this.player.field_70163_u + lastPosY, this.player.field_70179_y)) {
            this.player.field_70181_x = 0.3f;
        }
        if (!this.baseVelocities.isEmpty()) {
            float speedMod = wishspeed / this.quake_getMaxMoveSpeed();
            for (float[] baseVel : this.baseVelocities) {
                this.player.field_70159_w += (double)(baseVel[0] * speedMod);
                this.player.field_70179_y += (double)(baseVel[1] * speedMod);
            }
        }
    }

    private void quake_Accelerate(float wishspeed, double wishX, double wishZ, double accel) {
        double currentspeed = this.player.field_70159_w * wishX + this.player.field_70179_y * wishZ;
        double addspeed = (double)wishspeed - currentspeed;
        if (addspeed <= 0.0) {
            return;
        }
        double accelspeed = accel * (double)wishspeed / (double)this.getSlipperiness() * (double)0.05f;
        if (accelspeed > addspeed) {
            accelspeed = addspeed;
        }
        this.player.field_70159_w += accelspeed * wishX;
        this.player.field_70179_y += accelspeed * wishZ;
    }

    private void quake_AirAccelerate(float wishspeed, double wishX, double wishZ, double accel) {
        double currentspeed;
        double addspeed;
        float wishspd = wishspeed;
        float maxAirAcceleration = (float)ModConfig.MAX_AIR_ACCEL_PER_TICK;
        if (wishspd > maxAirAcceleration) {
            wishspd = maxAirAcceleration;
        }
        if ((addspeed = (double)wishspd - (currentspeed = this.player.field_70159_w * wishX + this.player.field_70179_y * wishZ)) <= 0.0) {
            return;
        }
        double accelspeed = accel * (double)wishspeed * (double)0.05f;
        if (accelspeed > addspeed) {
            accelspeed = addspeed;
        }
        this.player.field_70159_w += accelspeed * wishX;
        this.player.field_70179_y += accelspeed * wishZ;
    }

    private void quake_Friction() {
        float surfaceFriction;
        float sv_friction;
        float friction;
        double speed = this.getSpeed();
        if (speed <= 0.0) {
            return;
        }
        float drop = 0.0f;
        float sv_stopspeed = 0.005f;
        double control = speed < (double)sv_stopspeed ? (double)sv_stopspeed : speed;
        double newspeed = speed - (double)(drop = (float)((double)drop + control * (double)(friction = (sv_friction = 1.0f) * (surfaceFriction = this.getSurfaceFriction())) * (double)0.05f));
        if (newspeed < 0.0) {
            newspeed = 0.0;
        }
        if (newspeed != speed) {
            this.player.field_70159_w *= (newspeed /= speed);
            this.player.field_70179_y *= newspeed;
        }
    }

    private void quake_ApplySoftCap(float movespeed) {
        float softCap;
        float speed;
        float softCapPercent = ModConfig.SOFT_CAP;
        float softCapDegen = ModConfig.SOFT_CAP_DEGEN;
        if (ModConfig.UNCAPPED_BUNNYHOP_ENABLED) {
            softCapPercent = 1.0f;
            softCapDegen = 1.0f;
        }
        if ((speed = (float)this.getSpeed()) > (softCap = movespeed * softCapPercent)) {
            if (softCapDegen != 1.0f) {
                float applied_cap = (speed - softCap) * softCapDegen + softCap;
                float multi = applied_cap / speed;
                this.player.field_70159_w *= (double)multi;
                this.player.field_70179_y *= (double)multi;
            }
            this.spawnBunnyhopParticles(10);
        }
    }

    private void quake_ApplyHardCap(float movespeed) {
        float hardCap;
        if (ModConfig.UNCAPPED_BUNNYHOP_ENABLED) {
            return;
        }
        float hardCapPercent = ModConfig.HARD_CAP;
        float speed = (float)this.getSpeed();
        if (speed > (hardCap = movespeed * hardCapPercent) && hardCap != 0.0f) {
            float multi = hardCap / speed;
            this.player.field_70159_w *= (double)multi;
            this.player.field_70179_y *= (double)multi;
            this.spawnBunnyhopParticles(30);
        }
    }

    private void quake_OnLivingUpdate() {
        this.didJumpThisTick = false;
    }

    static {
        try {
            if (Loader.isModLoaded((String)"Squeedometer")) {
                hudSpeedometer = Class.forName("squeek.speedometer.HudSpeedometer");
                setDidJumpThisTick = hudSpeedometer.getDeclaredMethod("setDidJumpThisTick", Boolean.TYPE);
                setIsJumping = hudSpeedometer.getDeclaredMethod("setIsJumping", Boolean.TYPE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

