/*
 * Decompiled with CFR 0.152.
 */
package squeek.quakemovement;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ModConfig {
    private static final String CATEGORY_MOVEMENT = "movement";
    public static float TRIMP_MULTIPLIER;
    private static final String TRIMP_MULTIPLIER_NAME = "trimpMultiplier";
    private static final double TRIMP_MULTIPLIER_DEFAULT = 1.4;
    public static float HARD_CAP;
    private static final String HARD_CAP_NAME = "hardCapThreshold";
    private static final double HARD_CAP_DEFAULT = 2.0;
    public static float SOFT_CAP;
    private static final String SOFT_CAP_NAME = "softCapThreshold";
    private static final double SOFT_CAP_DEFAULT = 1.4;
    public static float SOFT_CAP_DEGEN;
    private static final String SOFT_CAP_DEGEN_NAME = "softCapDegen";
    private static final double SOFT_CAP_DEGEN_DEFAULT = 0.65;
    public static boolean SHARKING_ENABLED;
    private static final String SHARKING_ENABLED_NAME = "sharkingEnabled";
    private static final boolean SHARKING_ENABLED_DEFAULT = true;
    public static double SHARKING_SURFACE_TENSION;
    private static final String SHARKING_SURFACE_TENSION_NAME = "sharkingSurfaceTension";
    private static final double SHARKING_SURFACE_TENSION_DEFAULT = 0.2;
    public static double SHARKING_WATER_FRICTION;
    private static final String SHARKING_WATER_FRICTION_NAME = "sharkingWaterFriction";
    private static final double SHARKING_WATER_FRICTION_DEFAULT = 0.1;
    public static double ACCELERATE;
    private static final String ACCELERATE_NAME = "groundAccelerate";
    private static final double ACCELERATE_DEFAULT = 10.0;
    public static double AIR_ACCELERATE;
    private static final String AIR_ACCELERATE_NAME = "airAccelerate";
    private static final double AIR_ACCELERATE_DEFAULT = 14.0;
    public static boolean UNCAPPED_BUNNYHOP_ENABLED;
    private static final String UNCAPPED_BUNNYHOP_ENABLED_NAME = "uncappedBunnyhopEnabled";
    private static final boolean UNCAPPED_BUNNYHOP_ENABLED_DEFAULT = true;
    public static boolean TRIMPING_ENABLED;
    private static final String TRIMPING_ENABLED_NAME = "trimpEnabled";
    private static final boolean TRIMPING_ENABLED_DEFAULT = true;
    public static double INCREASED_FALL_DISTANCE;
    private static final String INCREASED_FALL_DISTANCE_NAME = "fallDistanceThresholdIncrease";
    private static final double INCREASED_FALL_DISTANCE_DEFAULT = 0.0;
    public static double MAX_AIR_ACCEL_PER_TICK;
    private static final String MAX_AIR_ACCEL_PER_TICK_NAME = "maxAirAccelerationPerTick";
    private static final double MAX_AIR_ACCEL_PER_TICK_DEFAULT = 0.045;
    private static Configuration config;

    public static void init(File file) {
        config = new Configuration(file);
        ModConfig.load();
        UNCAPPED_BUNNYHOP_ENABLED = config.get(CATEGORY_MOVEMENT, UNCAPPED_BUNNYHOP_ENABLED_NAME, true, "if enabled, the soft and hard caps will not be applied at all").getBoolean(true);
        AIR_ACCELERATE = config.get(CATEGORY_MOVEMENT, AIR_ACCELERATE_NAME, 14.0, "a higher value means you can turn more sharply in the air without losing speed").getDouble(14.0);
        MAX_AIR_ACCEL_PER_TICK = config.get(CATEGORY_MOVEMENT, MAX_AIR_ACCEL_PER_TICK_NAME, 0.045, "a higher value means faster air acceleration").getDouble(0.045);
        ACCELERATE = config.get(CATEGORY_MOVEMENT, ACCELERATE_NAME, 10.0, "a higher value means you accelerate faster on the ground").getDouble(10.0);
        HARD_CAP = (float)config.get(CATEGORY_MOVEMENT, HARD_CAP_NAME, 2.0, "see uncappedBunnyhopEnabled; if you ever jump while above the hard cap speed (moveSpeed*hardCapThreshold), your speed is set to the hard cap speed").getDouble(2.0);
        SOFT_CAP = (float)config.get(CATEGORY_MOVEMENT, SOFT_CAP_NAME, 1.4, "see uncappedBunnyhopEnabled and softCapDegen; soft cap speed = (moveSpeed*softCapThreshold)").getDouble(1.4);
        SOFT_CAP_DEGEN = (float)config.get(CATEGORY_MOVEMENT, SOFT_CAP_DEGEN_NAME, 0.65, "the modifier used to calculate speed lost when jumping above the soft cap").getDouble(0.65);
        SHARKING_ENABLED = config.get(CATEGORY_MOVEMENT, SHARKING_ENABLED_NAME, true, "if enabled, holding jump while swimming at the surface of water allows you to glide").getBoolean(true);
        SHARKING_WATER_FRICTION = 1.0 - config.get(CATEGORY_MOVEMENT, SHARKING_WATER_FRICTION_NAME, 0.1, "amount of friction while sharking (between 0 and 1)").getDouble(0.1) * 0.05;
        SHARKING_SURFACE_TENSION = 1.0 - config.get(CATEGORY_MOVEMENT, SHARKING_SURFACE_TENSION_NAME, 0.2, "amount of downward momentum you lose while entering water, a higher value means that you are able to shark after hitting the water from higher up").getDouble(0.2);
        TRIMPING_ENABLED = config.get(CATEGORY_MOVEMENT, TRIMPING_ENABLED_NAME, true, "if enabled, holding sneak while jumping will convert your horizontal speed into vertical speed").getBoolean(true);
        TRIMP_MULTIPLIER = (float)config.get(CATEGORY_MOVEMENT, TRIMP_MULTIPLIER_NAME, 1.4, "a lower value means less horizontal speed converted to vertical speed and vice versa").getDouble(1.4);
        INCREASED_FALL_DISTANCE = (float)config.get(CATEGORY_MOVEMENT, INCREASED_FALL_DISTANCE_NAME, 0.0, "increases the distance needed to fall in order to take fall damage; this is a server-side setting").getDouble(0.0);
        ModConfig.save();
    }

    public static void save() {
        config.save();
    }

    public static void load() {
        config.load();
    }
}

