/*
 * Decompiled with CFR 0.152.
 */
package myrathi.flatsigns.event;

import com.google.common.collect.Lists;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import myrathi.flatsigns.FlatSigns;
import myrathi.flatsigns.item.ItemSpongeWipe;
import myrathi.flatsigns.tileentity.TileEntityFlatSign;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C08PacketPlayerBlockPlacement;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class EventHandlers {
    public static ArrayList<Item> _sponges = null;
    private static List<EntityItem> _entityItems = Lists.newArrayList();
    private static ItemStack _yellowWool = new ItemStack(Blocks.field_150325_L, 1, 4);

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack item = event.entityPlayer.func_70694_bm();
        if (item == null) {
            return;
        }
        if (_sponges == null) {
            _sponges = new ArrayList<Item>(Arrays.asList(new Item[]{Item.func_150898_a((Block)Blocks.field_150360_v), FlatSigns.itemSpongeWipe}));
        }
        if (item.func_77973_b() == Items.field_151155_ap) {
            this.onPlayerInteract_Sign(event);
        } else if (_sponges.contains(item.func_77973_b()) && !event.entityPlayer.func_70093_af()) {
            this.onPlayerInteract_Sponge(event);
        }
    }

    private void onPlayerInteract_Sign(PlayerInteractEvent event) {
        if (event.face != ForgeDirection.UP.ordinal() && event.face != ForgeDirection.DOWN.ordinal()) {
            return;
        }
        if (event.face == ForgeDirection.UP.ordinal() && !event.entityPlayer.func_70093_af()) {
            return;
        }
        World world = event.entityPlayer.field_70170_p;
        ForgeDirection dir = ForgeDirection.getOrientation((int)event.face);
        int x = event.x;
        int y = event.y;
        int z = event.z;
        ItemStack item = event.entityPlayer.func_70694_bm();
        if (!event.entityPlayer.func_82247_a(x, y, z, event.face, item)) {
            event.setCanceled(true);
            return;
        }
        if (world.func_147437_c(x, y, z) || !world.func_147439_a(x, y, z).func_149688_o().func_76220_a()) {
            event.setCanceled(true);
            return;
        }
        if (!FlatSigns.blockFlatSign.func_149742_c(world, x += dir.offsetX, y += dir.offsetY, z += dir.offsetZ)) {
            event.setCanceled(true);
            return;
        }
        int meta = MathHelper.func_76128_c((double)((event.entityPlayer.field_70177_z + 360.0f + 45.0f) / 90.0f)) % 4;
        world.func_147465_d(x, y, z, (Block)FlatSigns.blockFlatSign, dir.getOpposite().ordinal() + (meta << 1), 2);
        if (!event.entityPlayer.field_71075_bZ.field_75098_d) {
            --item.field_77994_a;
        }
        TileEntityFlatSign tefs = (TileEntityFlatSign)world.func_147438_o(x, y, z);
        tefs.func_145912_a(event.entityPlayer);
        if (tefs != null && world.field_72995_K) {
            FlatSigns._proxy.displayGuiScreen(tefs);
        }
        event.entityPlayer.func_71064_a(StatList.field_75929_E[Item.func_150891_b((Item)item.func_77973_b())], 1);
        event.setCanceled(!world.field_72995_K);
    }

    private void onPlayerInteract_Sponge(PlayerInteractEvent event) {
        World world = event.entityPlayer.field_70170_p;
        int x = event.x;
        int y = event.y;
        int z = event.z;
        ForgeDirection dir = ForgeDirection.getOrientation((int)event.face);
        ItemStack item = event.entityPlayer.func_70694_bm();
        if (!event.entityPlayer.func_82247_a(x, y, z, event.face, item)) {
            event.setCanceled(true);
            return;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null || !(te instanceof TileEntityFlatSign) && !(te instanceof TileEntitySign)) {
            return;
        }
        if (!event.entityPlayer.field_71075_bZ.field_75098_d) {
            if (item.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v)) {
                --item.field_77994_a;
            } else {
                ItemSpongeWipe.damageItem(item, (EntityLivingBase)event.entityPlayer);
            }
        }
        ReflectionHelper.setPrivateValue(TileEntitySign.class, (Object)((TileEntitySign)te), (Object)event.entityPlayer, (String[])new String[]{"player", "field_145917_k", "k"});
        ReflectionHelper.setPrivateValue(TileEntitySign.class, (Object)((TileEntitySign)te), (Object)true, (String[])new String[]{"isEditable", "field_145916_j", "j"});
        event.setCanceled(true);
        if (world.field_72995_K) {
            event.entityPlayer.func_71038_i();
            FMLClientHandler.instance().getClient().func_147114_u().func_147297_a((Packet)new C08PacketPlayerBlockPlacement(x, y, z, event.face, item, 0.5f, 0.5f, 0.5f));
            if (te instanceof TileEntityFlatSign) {
                FlatSigns._proxy.displayGuiScreen((TileEntityFlatSign)te);
            } else if (te instanceof TileEntitySign) {
                event.entityPlayer.func_146100_a(te);
            }
            return;
        }
    }

    @SubscribeEvent
    public void onItemTossed(ItemTossEvent event) {
        if (event.entityItem.func_92059_d().func_77969_a(_yellowWool)) {
            EventHandlers.trackEntityItem(event.entityItem);
        }
    }

    @SubscribeEvent
    public void onServerTickEvent(TickEvent.ServerTickEvent event) {
        if (!event.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        if (_entityItems.isEmpty()) {
            return;
        }
        Iterator<EntityItem> iter = _entityItems.iterator();
        while (iter.hasNext()) {
            EntityItem entity = iter.next();
            if (!entity.field_70175_ag) {
                iter.remove();
                continue;
            }
            if (entity.field_70128_L) {
                iter.remove();
                continue;
            }
            if (!entity.func_70026_G() && !entity.func_70055_a(Material.field_151586_h)) continue;
            iter.remove();
            int stackSize = entity.func_92059_d().field_77994_a;
            entity.func_92058_a(new ItemStack(Blocks.field_150360_v, stackSize));
        }
    }

    private static void trackEntityItem(EntityItem entityItem) {
        if (_entityItems.contains(entityItem)) {
            return;
        }
        _entityItems.add(entityItem);
    }
}

