/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenDeadBush;
import net.minecraft.world.gen.feature.WorldGenShrub;
import rwg.biomes.base.BaseBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoBlob;
import rwg.deco.DecoCacti;
import rwg.util.CellNoise;
import rwg.util.CliffCalculator;
import rwg.util.PerlinNoise;

public class RealisticBiomeDesert
extends RealisticBiomeBase {
    public RealisticBiomeDesert(int sub) {
        super(sub, BaseBiomes.baseHotDesert);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength) {
        int i20;
        int i17;
        int i15;
        int j23;
        int k21;
        int k18;
        int j1;
        int i1;
        int k1;
        if (rand.nextInt((int)(2.0f / strength)) == 0 && (k1 = world.func_72976_f(i1 = chunkX + rand.nextInt(16) + 8, j1 = chunkY + rand.nextInt(16) + 8)) < 85) {
            new DecoBlob(Blocks.field_150347_e, 0).func_76484_a(world, rand, i1, k1, j1);
        }
        if (this.subID == 0 || this.subID == 2) {
            k18 = 0;
            while ((float)k18 < 12.0f * strength) {
                k21 = chunkX + rand.nextInt(16) + 8;
                j23 = rand.nextInt(160);
                int k24 = chunkY + rand.nextInt(16) + 8;
                new DecoCacti(false).func_76484_a(world, rand, k21, j23, k24);
                ++k18;
            }
            i15 = 0;
            while ((float)i15 < 3.0f * strength) {
                i17 = chunkX + rand.nextInt(16) + 8;
                i20 = rand.nextInt(160);
                int l22 = chunkY + rand.nextInt(16) + 8;
                new WorldGenDeadBush((Block)Blocks.field_150330_I).func_76484_a(world, rand, i17, i20, l22);
                ++i15;
            }
        } else {
            int b1 = 0;
            while ((float)b1 < 6.0f * strength) {
                int k10;
                int j6 = chunkX + rand.nextInt(16) + 8;
                int z52 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
                if (z52 < 68) {
                    WorldGenShrub worldgenerator = new WorldGenShrub(0, 0);
                    worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                }
                ++b1;
            }
            k18 = 0;
            while ((float)k18 < 35.0f * strength) {
                k21 = chunkX + rand.nextInt(16) + 8;
                j23 = rand.nextInt(160);
                int k24 = chunkY + rand.nextInt(16) + 8;
                if (j23 < 80 || rand.nextInt(10) == 0) {
                    new DecoCacti(false).func_76484_a(world, rand, k21, j23, k24);
                }
                ++k18;
            }
            i15 = 0;
            while ((float)i15 < 6.0f * strength) {
                i17 = chunkX + rand.nextInt(16) + 8;
                i20 = rand.nextInt(160);
                int l22 = chunkY + rand.nextInt(16) + 8;
                if (i20 < 80 || rand.nextInt(6) == 0) {
                    new WorldGenDeadBush((Block)Blocks.field_150330_I).func_76484_a(world, rand, i17, i20, l22);
                }
                ++i15;
            }
        }
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border) {
        if (this.subID == 0) {
            float h = (perlin.noise2((float)x / 300.0f, (float)y / 300.0f) + 0.25f) * 65.0f;
            h = h < 1.0f ? 1.0f : h;
            h += cell.noise((double)x / 50.0, (double)y / 50.0, 1.0) * h * 2.0f;
            h += perlin.noise2((float)x / 40.0f, (float)y / 40.0f) * 8.0f;
            return 80.0f + (h += perlin.noise2((float)x / 14.0f, (float)y / 14.0f) * 2.0f);
        }
        if (this.subID == 1) {
            float h = perlin.noise2((float)x / 200.0f, (float)y / 200.0f) * 120.0f;
            float f = h = h < 0.0f ? h / 4.5f : h;
            if (h > 0.0f) {
                float st = h * 1.5f > 15.0f ? 15.0f : h * 1.5f;
                h += cell.noise((double)x / 70.0, (double)y / 70.0, 1.0) * st;
            }
            h += perlin.noise2((float)x / 50.0f, (float)y / 50.0f) * 8.0f;
            h += perlin.noise2((float)x / 20.0f, (float)y / 20.0f) * 4.0f;
            return 74.0f + (h += perlin.noise2((float)x / 10.0f, (float)y / 10.0f) * 2.0f);
        }
        float st = (perlin.noise2((float)x / 160.0f, (float)y / 160.0f) + 0.38f) * 35.0f;
        st = st < 0.2f ? 0.2f : st;
        float h = perlin.noise2((float)x / 60.0f, (float)y / 60.0f) * st * 2.0f;
        h = h > 0.0f ? -h : h;
        h += st;
        h *= h / 50.0f;
        if ((h += st) < 10.0f) {
            float d = (h - 10.0f) / 2.0f;
            d = d > 4.0f ? 4.0f : d;
            h += cell.noise((double)x / 25.0, (double)y / 25.0, 1.0) * d;
            h += perlin.noise2((float)x / 30.0f, (float)y / 30.0f) * d;
            h += perlin.noise2((float)x / 14.0f, (float)y / 14.0f) * d * 0.5f;
        }
        return 70.0f + h;
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise) {
        if (this.subID == 0 || this.subID == 2) {
            for (int k = 255; k > -1; --k) {
                Block b = blocks[(y * 16 + x) * 256 + k];
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth < 7) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
                    continue;
                }
                if (depth >= 10) continue;
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150322_A;
            }
        } else {
            float c = CliffCalculator.calc(x, y, noise);
            boolean cliff = false;
            boolean grass = false;
            for (int k = 255; k > -1; --k) {
                Block b = blocks[(y * 16 + x) * 256 + k];
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (k < 62 && ++depth < 10) {
                    if (depth < 4) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                    }
                    if (depth < 7) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150322_A;
                    continue;
                }
                if (depth >= 10) continue;
                if (depth == 0) {
                    float c2 = 1.4f - ((float)k - 60.0f) / 60.0f + perlin.noise2((float)i / 8.0f, (float)j / 8.0f) * 0.5f;
                    if (c > c2 && c2 > 0.4f) {
                        cliff = true;
                    } else if (k < 67 && perlin.noise2((float)x / 5.0f, (float)y / 5.0f) - (float)(k - 63) / 5.0f > 0.0f) {
                        grass = true;
                    }
                }
                if (cliff && depth < 2) {
                    blocks[(y * 16 + x) * 256 + k] = rand.nextInt(3) == 0 ? Blocks.field_150347_e : Blocks.field_150348_b;
                    continue;
                }
                if (grass) {
                    if (depth == 0) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                        continue;
                    }
                    if (depth < 3) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                        continue;
                    }
                    if (depth < 7) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
                        continue;
                    }
                    if (depth >= 10) continue;
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150322_A;
                    continue;
                }
                if (depth < 7) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
                    continue;
                }
                if (depth >= 10) continue;
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150322_A;
            }
        }
    }
}

