/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenForest;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenTrees;
import rwg.biomes.base.BaseBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoBlob;
import rwg.deco.DecoFlowers;
import rwg.deco.DecoGrass;
import rwg.deco.DecoWildWheat;
import rwg.util.CellNoise;
import rwg.util.CliffCalculator;
import rwg.util.PerlinNoise;

public class RealisticBiomePlains
extends RealisticBiomeBase {
    public RealisticBiomePlains(int sub) {
        super(sub, BaseBiomes.basePlains);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength) {
        if (this.subID == 0) {
            float h;
            int j1;
            int i1;
            int k1;
            if (rand.nextInt((int)(2.0f / strength)) == 0 && (k1 = world.func_72976_f(i1 = chunkX + rand.nextInt(16) + 8, j1 = chunkY + rand.nextInt(16) + 8)) < 85) {
                new DecoBlob(Blocks.field_150347_e, 0).func_76484_a(world, rand, i1, k1, j1);
            }
            if (rand.nextInt((int)(22.0f / strength)) == 0) {
                int j16 = chunkX + rand.nextInt(16) + 8;
                int j18 = rand.nextInt(128);
                int j21 = chunkY + rand.nextInt(16) + 8;
                new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
            }
            if (rand.nextInt((int)(3.0f / strength)) == 0) {
                int i18 = chunkX + rand.nextInt(16) + 8;
                int i23 = chunkY + rand.nextInt(16) + 8;
                new WorldGenReed().func_76484_a(world, rand, i18, 60 + rand.nextInt(8), i23);
            }
            int f23 = 0;
            while ((float)f23 < 3.0f * strength) {
                int j15 = chunkX + rand.nextInt(16) + 8;
                int j17 = rand.nextInt(128);
                int j20 = chunkY + rand.nextInt(16) + 8;
                new DecoFlowers(new int[]{4, 5, 6, 7, 3, 3, 8, 10, 9, 9, 11}).func_76484_a(world, rand, j15, j17, j20);
                ++f23;
            }
            if (rand.nextInt((int)(100.0f / strength)) == 0) {
                int k21 = chunkX + rand.nextInt(16) + 8;
                int j23 = rand.nextInt(60) + 60;
                int k24 = chunkY + rand.nextInt(16) + 8;
                new DecoWildWheat(rand.nextInt(3)).func_76484_a(world, rand, k21, j23, k24);
            }
            if ((h = perlin.noise2((float)(chunkX + 8) / 200.0f, (float)(chunkY + 8) / 200.0f) * 28.0f) < -2.0f) {
                int b1 = 0;
                while ((float)b1 < 5.0f * strength) {
                    int j6 = chunkX + rand.nextInt(16) + 8;
                    int k10 = chunkY + rand.nextInt(16) + 8;
                    int z52 = world.func_72976_f(j6, k10);
                    WorldGenShrub worldgenerator = rand.nextBoolean() ? new WorldGenShrub(0, 0) : (rand.nextInt(7) == 0 ? new WorldGenForest(false, false) : (rand.nextInt(10) == 0 ? new WorldGenBigTree(false) : new WorldGenTrees(false)));
                    worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                    ++b1;
                }
            }
            int l14 = 0;
            while ((float)l14 < 7.0f * strength) {
                int l19 = chunkX + rand.nextInt(16) + 8;
                int k22 = 60 + rand.nextInt(40);
                int j24 = chunkY + rand.nextInt(16) + 8;
                if (rand.nextInt(5) == 0) {
                    new DecoGrass((Block)Blocks.field_150398_cm, 2).func_76484_a(world, rand, l19, k22, j24);
                } else {
                    new DecoGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
                }
                ++l14;
            }
        } else {
            int j1;
            int i1;
            int k1;
            float a = perlin.noise2((float)chunkX / 90.0f, (float)chunkY / 90.0f) * 35.0f - 5.0f;
            int b1 = 0;
            while ((float)b1 < a * strength) {
                int k10;
                int j6 = chunkX + rand.nextInt(16) + 8;
                int z52 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
                if (z52 < 80) {
                    WorldGenShrub worldgenerator = rand.nextBoolean() ? new WorldGenShrub(0, 0) : (rand.nextInt(10) == 0 ? new WorldGenBigTree(false) : new WorldGenTrees(false));
                    worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                }
                ++b1;
            }
            if (rand.nextInt((int)(2.0f / strength)) == 0 && (k1 = world.func_72976_f(i1 = chunkX + rand.nextInt(16) + 8, j1 = chunkY + rand.nextInt(16) + 8)) < 85) {
                new DecoBlob(Blocks.field_150347_e, 0).func_76484_a(world, rand, i1, k1, j1);
            }
            if (rand.nextInt((int)(22.0f / strength)) == 0) {
                int j16 = chunkX + rand.nextInt(16) + 8;
                int j18 = rand.nextInt(128);
                int j21 = chunkY + rand.nextInt(16) + 8;
                new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
            }
            if (rand.nextInt((int)(3.0f / strength)) == 0) {
                int i18 = chunkX + rand.nextInt(16) + 8;
                int i23 = chunkY + rand.nextInt(16) + 8;
                new WorldGenReed().func_76484_a(world, rand, i18, 60 + rand.nextInt(8), i23);
            }
            int f23 = 0;
            while ((float)f23 < 3.0f * strength) {
                int j15 = chunkX + rand.nextInt(16) + 8;
                int j17 = rand.nextInt(128);
                int j20 = chunkY + rand.nextInt(16) + 8;
                new DecoFlowers(new int[]{0, 3}).func_76484_a(world, rand, j15, j17, j20);
                ++f23;
            }
            if (rand.nextInt((int)(100.0f / strength)) == 0) {
                int k21 = chunkX + rand.nextInt(16) + 8;
                int j23 = rand.nextInt(60) + 60;
                int k24 = chunkY + rand.nextInt(16) + 8;
                new DecoWildWheat(rand.nextInt(3)).func_76484_a(world, rand, k21, j23, k24);
            }
            int l14 = 0;
            while ((float)l14 < 12.0f * strength) {
                int l19 = chunkX + rand.nextInt(16) + 8;
                int k22 = 60 + rand.nextInt(120);
                int j24 = chunkY + rand.nextInt(16) + 8;
                if (rand.nextInt(3) == 0) {
                    new DecoGrass((Block)Blocks.field_150398_cm, 2).func_76484_a(world, rand, l19, k22, j24);
                } else {
                    new DecoGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
                }
                ++l14;
            }
        }
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border) {
        if (this.subID == 0) {
            float h = perlin.noise2((float)x / 200.0f, (float)y / 200.0f) * 34.0f;
            h += cell.noise((float)x / 50.0f, (float)y / 50.0f, 1.0) * 15.0f;
            h += perlin.noise2((float)x / 50.0f, (float)y / 50.0f) * 10.0f;
            return 70.0f + (h += perlin.noise2((float)x / 15.0f, (float)y / 15.0f) * 4.0f);
        }
        float h = perlin.noise2((float)x / 200.0f, (float)y / 200.0f) * 120.0f;
        float f = h = h < 0.0f ? h / 4.5f : h;
        if (h > 0.0f) {
            float st = h * 1.5f > 15.0f ? 15.0f : h * 1.5f;
            h += cell.noise((double)x / 70.0, (double)y / 70.0, 1.0) * st;
        }
        h += perlin.noise2((float)x / 50.0f, (float)y / 50.0f) * 8.0f;
        h += perlin.noise2((float)x / 20.0f, (float)y / 20.0f) * 4.0f;
        return 72.0f + (h += perlin.noise2((float)x / 10.0f, (float)y / 10.0f) * 2.0f);
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise) {
        if (this.subID == 0) {
            boolean sand = false;
            for (int k = 255; k > -1; --k) {
                Block b = blocks[(y * 16 + x) * 256 + k];
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth == 0) {
                    if (k < 63) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
                        sand = true;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                    continue;
                }
                if (depth >= 6) continue;
                if (sand) {
                    if (depth < 4) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150322_A;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
            }
        } else {
            float c = CliffCalculator.calc(x, y, noise);
            boolean cliff = false;
            boolean gravel = false;
            for (int k = 255; k > -1; --k) {
                Block b = blocks[(y * 16 + x) * 256 + k];
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth == 0) {
                    float c2 = 1.4f - ((float)k - 60.0f) / 60.0f + perlin.noise2((float)i / 8.0f, (float)j / 8.0f) * 0.5f;
                    if (c > c2 && c2 > 0.4f) {
                        cliff = true;
                        blocks[(y * 16 + x) * 256 + k] = rand.nextInt(3) == 0 ? Blocks.field_150347_e : Blocks.field_150348_b;
                        continue;
                    }
                    if (k < 63) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150351_n;
                        gravel = true;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                    continue;
                }
                if (depth >= 6 || cliff) continue;
                blocks[(y * 16 + x) * 256 + k] = gravel ? Blocks.field_150351_n : Blocks.field_150346_d;
            }
        }
    }
}

