/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import rwg.biomes.base.BaseBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.util.CellNoise;
import rwg.util.PerlinNoise;
import rwg.util.SnowheightCalculator;

public class RealisticBiomePolar
extends RealisticBiomeBase {
    public RealisticBiomePolar(int sub) {
        super(sub, BaseBiomes.baseSnowDesert);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength) {
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border) {
        if (this.subID == 0) {
            float st = (perlin.noise2((float)x / 160.0f, (float)y / 160.0f) + 0.38f) * 35.0f;
            st = st < 0.2f ? 0.2f : st;
            float h = perlin.noise2((float)x / 60.0f, (float)y / 60.0f) * st * 2.0f;
            h = h > 0.0f ? -h : h;
            h += st;
            h *= h / 50.0f;
            return 70.0f + (h += st);
        }
        float st = (perlin.noise2((float)x / 160.0f, (float)y / 160.0f) + 0.38f) * 35.0f;
        st = st < 0.2f ? 0.2f : st;
        float h = perlin.noise2((float)x / 60.0f, (float)y / 60.0f) * st * 2.0f;
        h = h > 0.0f ? -h : h;
        h += st;
        h *= h / 50.0f;
        return 50.0f + (h += st);
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise) {
        boolean water = false;
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b == Blocks.field_150348_b) {
                if (++depth <= -1 || depth >= 9) continue;
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150433_aE;
                if (depth != 0 || k <= 61 || k >= 254) continue;
                SnowheightCalculator.calc(x, y, k, blocks, metadata, noise);
                continue;
            }
            if (water || b != Blocks.field_150355_j) continue;
            blocks[(y * 16 + x) * 256 + k] = Blocks.field_150432_aD;
            water = true;
        }
    }
}

