/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenerator;
import rwg.biomes.base.BaseBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoBlob;
import rwg.deco.DecoFlowers;
import rwg.deco.DecoGrass;
import rwg.deco.trees.DecoShrub;
import rwg.deco.trees.DecoSmallPine;
import rwg.deco.trees.DecoSmallSpruce;
import rwg.util.CellNoise;
import rwg.util.CliffCalculator;
import rwg.util.PerlinNoise;

public class RealisticBiomeSnow
extends RealisticBiomeBase {
    public RealisticBiomeSnow(int sub) {
        super(sub, BaseBiomes.baseSnowForest);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength) {
        block25: {
            int j1;
            int i1;
            int b;
            int k10;
            int j6;
            int b1;
            block26: {
                block24: {
                    int l = 0;
                    while ((float)l < 6.0f * strength) {
                        int j12;
                        int i12 = chunkX + rand.nextInt(16) + 8;
                        int k1 = world.func_72976_f(i12, j12 = chunkY + rand.nextInt(16) + 8);
                        if (k1 < 95 && (k1 < 64 || rand.nextInt(15) == 0)) {
                            new DecoBlob(Blocks.field_150341_Y, 0).func_76484_a(world, rand, i12, k1, j12);
                        }
                        ++l;
                    }
                    if (rand.nextInt((int)(25.0f / strength)) == 0) {
                        int j16 = chunkX + rand.nextInt(16) + 8;
                        int j18 = rand.nextInt(128);
                        int j21 = chunkY + rand.nextInt(16) + 8;
                        new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
                    }
                    int f23 = 0;
                    while ((float)f23 < 2.0f * strength) {
                        int j15 = chunkX + rand.nextInt(16) + 8;
                        int j17 = rand.nextInt(128);
                        int j20 = chunkY + rand.nextInt(16) + 8;
                        new DecoFlowers(new int[]{9, 0, 3}).func_76484_a(world, rand, j15, j17, j20);
                        ++f23;
                    }
                    int l14 = 0;
                    while ((float)l14 < 3.0f * strength) {
                        int l19 = chunkX + rand.nextInt(16) + 8;
                        int k22 = rand.nextInt(128);
                        int j24 = chunkY + rand.nextInt(16) + 8;
                        new DecoGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
                        ++l14;
                    }
                    if (this.subID != 0) break block24;
                    float l2 = perlin.noise2((float)chunkX / 100.0f, (float)chunkY / 100.0f) * 5.0f - 0.5f;
                    b1 = 0;
                    while ((float)b1 < l2 * 2.0f * strength) {
                        WorldGenerator worldgenerator;
                        j6 = chunkX + rand.nextInt(16) + 8;
                        int z52 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
                        if (z52 < 85) {
                            worldgenerator = rand.nextInt(8) != 0 ? new DecoSmallSpruce(1 + rand.nextInt(2)) : new DecoSmallPine(1 + rand.nextInt(3), 2 + rand.nextInt(4));
                            worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                            worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                        } else if (z52 < 130) {
                            worldgenerator = rand.nextInt(4) != 0 ? new DecoSmallSpruce(rand.nextInt(2)) : new DecoSmallPine(2 + rand.nextInt(2), 4 + rand.nextInt(5));
                            worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                            worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                        }
                        ++b1;
                    }
                    if (!(l2 > -0.4f)) break block25;
                    b = 0;
                    while ((float)b < 2.0f * strength) {
                        i1 = chunkX + rand.nextInt(16) + 8;
                        j1 = chunkY + rand.nextInt(16) + 8;
                        int k1 = world.func_72976_f(i1, j1);
                        if (rand.nextInt(10) == 0) {
                            new DecoShrub(rand.nextInt(5) + 4, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
                        } else {
                            new DecoShrub(rand.nextInt(4) + 1, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
                        }
                        ++b;
                    }
                    break block25;
                }
                if (this.subID != 1) break block26;
                float l = perlin.noise2((float)chunkX / 120.0f, (float)chunkY / 120.0f) * 8.0f - 1.0f;
                b1 = 0;
                while ((float)b1 < l * 2.0f * strength) {
                    WorldGenerator worldgenerator;
                    j6 = chunkX + rand.nextInt(16) + 8;
                    int z52 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
                    if (z52 < 85) {
                        worldgenerator = rand.nextInt(8) != 0 ? new DecoSmallSpruce(1 + rand.nextInt(2)) : new DecoSmallPine(1 + rand.nextInt(3), 2 + rand.nextInt(4));
                        worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                        worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                    } else if (z52 < 130) {
                        worldgenerator = rand.nextInt(4) != 0 ? new DecoSmallSpruce(rand.nextInt(2)) : new DecoSmallPine(2 + rand.nextInt(2), 4 + rand.nextInt(5));
                        worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                        worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                    }
                    ++b1;
                }
                if (!(l > -0.4f)) break block25;
                b = 0;
                while ((float)b < 2.0f * strength) {
                    i1 = chunkX + rand.nextInt(16) + 8;
                    j1 = chunkY + rand.nextInt(16) + 8;
                    int k1 = world.func_72976_f(i1, j1);
                    if (rand.nextInt(10) == 0) {
                        new DecoShrub(rand.nextInt(5) + 4, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
                    } else {
                        new DecoShrub(rand.nextInt(4) + 1, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
                    }
                    ++b;
                }
                break block25;
            }
            if (this.subID == 2) {
                float l = perlin.noise2((float)chunkX / 100.0f, (float)chunkY / 100.0f) * 6.0f + 0.8f;
                b1 = 0;
                while ((float)b1 < l * 2.0f * strength) {
                    j6 = chunkX + rand.nextInt(16) + 8;
                    k10 = chunkY + rand.nextInt(16) + 8;
                    int z52 = world.func_72976_f(j6, k10);
                    WorldGenerator worldgenerator = rand.nextInt(4) == 0 ? new DecoSmallSpruce(1 + rand.nextInt(2)) : (rand.nextInt(6) == 0 ? new DecoSmallPine(1 + rand.nextInt(3), 4 + rand.nextInt(4)) : new DecoSmallPine(4 + rand.nextInt(6), 5 + rand.nextInt(10)));
                    worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                    ++b1;
                }
                b = 0;
                while ((float)b < 2.0f * strength) {
                    i1 = chunkX + rand.nextInt(16) + 8;
                    j1 = chunkY + rand.nextInt(16) + 8;
                    int k1 = world.func_72976_f(i1, j1);
                    if (rand.nextInt(10) == 0) {
                        new DecoShrub(rand.nextInt(5) + 4, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
                    } else {
                        new DecoShrub(rand.nextInt(4) + 1, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
                    }
                    ++b;
                }
            }
        }
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border) {
        if (this.subID == 0) {
            float h = perlin.noise2((float)x / 300.0f, (float)y / 300.0f) * (35.0f + 100.0f * border);
            h = (h *= h / 32.0f) > 150.0f ? 150.0f : h;
            float bn = 0.0f;
            if (h < 1.0f) {
                bn = 1.0f - h;
                for (int i = 0; i < 3; ++i) {
                    bn *= bn * 1.25f;
                }
                float f = bn = bn > 3.0f ? 3.0f : bn;
            }
            if (h < 3.0f) {
                h += perlin.noise2((float)x / 13.0f, (float)y / 13.0f) * (bn + 3.0f - h) * 0.8f;
            }
            if (h > 2.0f) {
                float d = (h - 2.0f) / 2.0f > 8.0f ? 8.0f : (h - 2.0f) / 2.0f;
                h += perlin.noise2((float)x / 18.0f, (float)y / 18.0f) * d;
                if ((h += perlin.noise2((float)x / 50.0f, (float)y / 50.0f) * d * 0.5f) > 60.0f) {
                    float d2 = (h - 60.0f) / 1.5f > 35.0f ? 35.0f : (h - 60.0f) / 1.5f;
                    h += cell.noise((double)x / 25.0, (double)y / 25.0, 1.0) * d2;
                }
            }
            return h + 63.0f - bn;
        }
        if (this.subID == 1) {
            float h = perlin.noise2((float)x / 300.0f, (float)y / 300.0f) * (35.0f + 95.0f * border);
            h = h < 0.0f ? 0.0f : h;
            h *= h / 32.0f;
            float f = h = h > 200.0f ? 200.0f : h;
            if (h > 2.0f) {
                float d = (h - 2.0f) / 2.0f > 8.0f ? 8.0f : (h - 2.0f) / 2.0f;
                h += perlin.noise2((float)x / 18.0f, (float)y / 18.0f) * d;
                if ((h += perlin.noise2((float)x / 50.0f, (float)y / 50.0f) * d * 0.5f) > 60.0f) {
                    float d2 = (h - 60.0f) / 1.5f > 35.0f ? 35.0f : (h - 60.0f) / 1.5f;
                    h += cell.noise((double)x / 25.0, (double)y / 25.0, 1.0) * d2;
                }
            }
            h += perlin.noise2((float)x / 120.0f, (float)y / 120.0f) * 8.0f;
            h += perlin.noise2((float)x / 34.0f, (float)y / 34.0f) * 4.0f;
            return (h += perlin.noise2((float)x / 17.0f, (float)y / 17.0f) * 2.0f) + 70.0f;
        }
        float h = perlin.noise2((float)x / 300.0f, (float)y / 300.0f) * 40.0f;
        h = h > 3.0f ? 3.0f + (h - 3.0f) / 2.0f : h;
        h += perlin.noise2((float)x / 50.0f, (float)y / 50.0f) * (12.0f - h) * 0.4f;
        h += perlin.noise2((float)x / 15.0f, (float)y / 15.0f) * (12.0f - h) * 0.15f;
        return 65.0f + h;
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise) {
        float c = CliffCalculator.calc(x, y, noise);
        int cliff = 0;
        float p = perlin.noise2((float)i / 8.0f, (float)j / 8.0f) * 0.5f;
        boolean gravel = false;
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            if (++depth == 0) {
                if (k < 63) {
                    gravel = true;
                }
                if (c > 0.45f && c > 1.5f - ((float)k - 60.0f) / 65.0f + p) {
                    cliff = 1;
                }
                if (c > 1.4f) {
                    cliff = 2;
                }
                if (c < 0.3f + ((float)k - 80.0f) / 40.0f + p && this.subID != 2) {
                    cliff = 3;
                }
                if (cliff == 1) {
                    blocks[(y * 16 + x) * 256 + k] = rand.nextInt(3) == 0 ? Blocks.field_150347_e : Blocks.field_150348_b;
                    continue;
                }
                if (cliff == 2) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150406_ce;
                    metadata[(y * 16 + x) * 256 + k] = 9;
                    continue;
                }
                if (cliff == 3) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150433_aE;
                    continue;
                }
                if (k < 63) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150351_n;
                    gravel = true;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                continue;
            }
            if (depth >= 6) continue;
            if (cliff == 1) {
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150348_b;
                continue;
            }
            if (cliff == 2) {
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150406_ce;
                metadata[(y * 16 + x) * 256 + k] = 9;
                continue;
            }
            if (cliff == 3) {
                if (depth > 3 && k < 100) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150348_b;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150433_aE;
                continue;
            }
            blocks[(y * 16 + x) * 256 + k] = gravel ? Blocks.field_150351_n : Blocks.field_150346_d;
        }
    }
}

