/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenerator;
import rwg.biomes.base.BaseBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoBlob;
import rwg.deco.DecoFlowers;
import rwg.deco.DecoGrass;
import rwg.deco.trees.DecoShrub;
import rwg.deco.trees.DecoSmallPine;
import rwg.deco.trees.DecoSmallSpruce;
import rwg.util.CellNoise;
import rwg.util.CliffCalculator;
import rwg.util.PerlinNoise;

public class RealisticBiomeSnowPlains
extends RealisticBiomeBase {
    public RealisticBiomeSnowPlains(int sub) {
        super(sub, BaseBiomes.baseSnowForest);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength) {
        int i8;
        int i2;
        int l4;
        if (rand.nextInt((int)(15.0f / strength)) == 0 && (l4 = world.func_72976_f(i2 = chunkX + rand.nextInt(16) + 8, i8 = chunkY + rand.nextInt(16) + 8)) > 63 && l4 < 105) {
            new WorldGenLakes(Blocks.field_150355_j).func_76484_a(world, rand, i2, l4, i8);
        }
        int l = 0;
        while ((float)l < 6.0f * strength) {
            int j1;
            int i1 = chunkX + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
            if (k1 < 95 && (k1 < 64 || rand.nextInt(15) == 0)) {
                new DecoBlob(Blocks.field_150341_Y, 0).func_76484_a(world, rand, i1, k1, j1);
            }
            ++l;
        }
        if (rand.nextInt((int)(25.0f / strength)) == 0) {
            int j16 = chunkX + rand.nextInt(16) + 8;
            int j18 = rand.nextInt(128);
            int j21 = chunkY + rand.nextInt(16) + 8;
            new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
        }
        int f23 = 0;
        while ((float)f23 < 2.0f * strength) {
            int j15 = chunkX + rand.nextInt(16) + 8;
            int j17 = rand.nextInt(128);
            int j20 = chunkY + rand.nextInt(16) + 8;
            new DecoFlowers(new int[]{9, 0, 3}).func_76484_a(world, rand, j15, j17, j20);
            ++f23;
        }
        int l14 = 0;
        while ((float)l14 < 3.0f * strength) {
            int l19 = chunkX + rand.nextInt(16) + 8;
            int k22 = rand.nextInt(128);
            int j24 = chunkY + rand.nextInt(16) + 8;
            new DecoGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
            ++l14;
        }
        float l2 = perlin.noise2((float)chunkX / 100.0f, (float)chunkY / 100.0f) * 5.0f;
        int b1 = 0;
        while ((float)b1 < l2 * 2.0f * strength) {
            int k10;
            int j6 = chunkX + rand.nextInt(16) + 8;
            int z52 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
            if (z52 < 100) {
                WorldGenerator worldgenerator;
                if (l2 > 1.0f) {
                    worldgenerator = rand.nextInt(8) != 0 ? new DecoSmallSpruce(1 + rand.nextInt(2)) : new DecoSmallPine(1 + rand.nextInt(3), 2 + rand.nextInt(4));
                    worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                } else if (l2 > 0.0f) {
                    worldgenerator = rand.nextInt(4) != 0 ? new DecoSmallSpruce(rand.nextInt(2)) : new DecoSmallPine(2 + rand.nextInt(2), 4 + rand.nextInt(5));
                    worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                }
            }
            ++b1;
        }
        if (l2 > -0.4f) {
            int b = 0;
            while ((float)b < 2.0f * strength) {
                int j1;
                int i1 = chunkX + rand.nextInt(16) + 8;
                int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
                if (k1 < 100) {
                    if (rand.nextInt(10) == 0) {
                        new DecoShrub(rand.nextInt(5) + 4, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
                    } else {
                        new DecoShrub(rand.nextInt(4) + 1, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
                    }
                }
                ++b;
            }
        }
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border) {
        float h = perlin.noise2((float)x / 300.0f, (float)y / 300.0f) * 40.0f;
        h = h > 3.0f ? 3.0f + (h - 3.0f) / 2.0f : h;
        h += perlin.noise2((float)x / 28.0f, (float)y / 28.0f) * 4.0f;
        h += perlin.noise2((float)x / 18.0f, (float)y / 18.0f) * 2.0f;
        return 66.0f + (h += perlin.noise2((float)x / 8.0f, (float)y / 8.0f) * 2.0f);
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise) {
        float c = CliffCalculator.calc(x, y, noise);
        int cliff = 0;
        boolean gravel = false;
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            if (++depth == 0) {
                if (k < 63) {
                    gravel = true;
                }
                if (c > 1.4f) {
                    cliff = 1;
                }
                if (c > 1.9f) {
                    cliff = 2;
                }
                if (cliff == 1) {
                    blocks[(y * 16 + x) * 256 + k] = rand.nextInt(3) == 0 ? Blocks.field_150347_e : Blocks.field_150348_b;
                    continue;
                }
                if (cliff == 2) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150406_ce;
                    metadata[(y * 16 + x) * 256 + k] = 9;
                    continue;
                }
                if (k < 63) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150351_n;
                    gravel = true;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                continue;
            }
            if (depth >= 6) continue;
            if (cliff == 1) {
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150348_b;
                continue;
            }
            if (cliff == 2) {
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150406_ce;
                metadata[(y * 16 + x) * 256 + k] = 9;
                continue;
            }
            blocks[(y * 16 + x) * 256 + k] = gravel ? Blocks.field_150351_n : Blocks.field_150346_d;
        }
    }
}

