/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenForest;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraft.world.gen.feature.WorldGenTrees;
import rwg.biomes.base.BaseBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoBlob;
import rwg.deco.DecoFlowers;
import rwg.deco.DecoGrass;
import rwg.deco.DecoLog;
import rwg.deco.DecoWildWheat;
import rwg.deco.trees.DecoPineTree;
import rwg.deco.trees.DecoShrub;
import rwg.deco.trees.DecoSmallPine;
import rwg.deco.trees.DecoSmallSpruce;
import rwg.util.CellNoise;
import rwg.util.CliffCalculator;
import rwg.util.PerlinNoise;

public class RealisticBiomeTaigaPlains
extends RealisticBiomeBase {
    public RealisticBiomeTaigaPlains(int sub) {
        super(sub, BaseBiomes.baseColdForest);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength) {
        if (this.subID == 0) {
            int i8;
            int i2;
            int l4;
            if (rand.nextInt((int)(15.0f / strength)) == 0 && (l4 = world.func_72976_f(i2 = chunkX + rand.nextInt(16) + 8, i8 = chunkY + rand.nextInt(16) + 8)) > 63 && l4 < 105) {
                new WorldGenLakes(Blocks.field_150355_j).func_76484_a(world, rand, i2, l4, i8);
            }
            int l = 0;
            while ((float)l < 1.0f * strength) {
                int j1;
                int i1 = chunkX + rand.nextInt(16) + 8;
                int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
                if (k1 < 95) {
                    new DecoBlob(Blocks.field_150347_e, 0).func_76484_a(world, rand, i1, k1, j1);
                }
                ++l;
            }
            float l2 = perlin.noise2((float)chunkX / 100.0f, (float)chunkY / 100.0f) * 5.0f + 2.0f;
            int b1 = 0;
            while ((float)b1 < l2 * strength) {
                int j6 = chunkX + rand.nextInt(16) + 8;
                int k10 = chunkY + rand.nextInt(16) + 8;
                int z52 = world.func_72976_f(j6, k10);
                Object worldgenerator = rand.nextInt(6) != 0 ? new DecoPineTree(4, rand.nextInt(2)) : (rand.nextInt(3) != 0 ? new DecoSmallPine(3 + rand.nextInt(6), 6 + rand.nextInt(8), 0) : new DecoSmallSpruce(1 + rand.nextInt(2)));
                worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                ++b1;
            }
            int f24 = 0;
            while ((float)f24 < 3.0f * strength) {
                int j1;
                int i1 = chunkX + rand.nextInt(16) + 8;
                int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
                if (k1 < 110) {
                    new DecoShrub(rand.nextInt(4) + 1, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
                }
                ++f24;
            }
            if (rand.nextInt((int)(150.0f / strength)) == 0) {
                int k21 = chunkX + rand.nextInt(16) + 8;
                int j23 = rand.nextInt(60) + 60;
                int k24 = chunkY + rand.nextInt(16) + 8;
                new DecoWildWheat(rand.nextInt(3)).func_76484_a(world, rand, k21, j23, k24);
            }
            if (rand.nextInt((int)(20.0f / strength)) == 0) {
                int j16 = chunkX + rand.nextInt(16) + 8;
                int j18 = rand.nextInt(100);
                int j21 = chunkY + rand.nextInt(16) + 8;
                new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
            }
            int f23 = 0;
            while ((float)f23 < 4.0f * strength) {
                int j15 = chunkX + rand.nextInt(16) + 8;
                int j17 = rand.nextInt(128);
                int j20 = chunkY + rand.nextInt(16) + 8;
                new DecoFlowers(new int[]{9, 0, 3}).func_76484_a(world, rand, j15, j17, j20);
                ++f23;
            }
            int l14 = 0;
            while ((float)l14 < 8.0f * strength) {
                int l19 = chunkX + rand.nextInt(16) + 8;
                int k22 = rand.nextInt(128);
                int j24 = chunkY + rand.nextInt(16) + 8;
                new DecoGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
                ++l14;
            }
        } else if (this.subID == 1) {
            int z22;
            int x22;
            int y22;
            int i8;
            int i2;
            int l4;
            if (rand.nextInt((int)(15.0f / strength)) == 0 && (l4 = world.func_72976_f(i2 = chunkX + rand.nextInt(16) + 8, i8 = chunkY + rand.nextInt(16) + 8)) > 63 && l4 < 105) {
                new WorldGenLakes(Blocks.field_150355_j).func_76484_a(world, rand, i2, l4, i8);
            }
            l = 0;
            while ((float)l < 1.0f * strength) {
                int j1;
                int i1 = chunkX + rand.nextInt(16) + 8;
                int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
                if (k1 < 95 && rand.nextInt(2) == 0) {
                    new DecoBlob(Blocks.field_150341_Y, 0).func_76484_a(world, rand, i1, k1, j1);
                }
                ++l;
            }
            float l3 = perlin.noise2((float)chunkX / 100.0f, (float)chunkY / 100.0f) * 10.0f + 3.0f;
            int b1 = 0;
            while ((float)b1 < l3 * strength) {
                Object worldgenerator;
                int k10;
                int j6 = chunkX + rand.nextInt(16) + 8;
                int z52 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
                if (z52 < 90) {
                    worldgenerator = rand.nextInt(12) == 0 ? new WorldGenBigTree(false) : (rand.nextInt(3) != 0 ? new DecoPineTree(4, rand.nextInt(4) == 0 ? 1 : 0) : (rand.nextInt(5) == 0 ? new DecoSmallPine(3 + rand.nextInt(6), 6 + rand.nextInt(8), 0) : (rand.nextInt(6) != 0 ? new WorldGenTrees(false) : new WorldGenForest(false, false))));
                    worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                } else if (z52 < 120) {
                    worldgenerator = rand.nextInt(3) != 0 ? new DecoSmallPine(2 + rand.nextInt(3), 4 + rand.nextInt(5), 0) : (rand.nextInt(6) != 0 ? new WorldGenTrees(false) : new WorldGenForest(false, false));
                    worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                }
                ++b1;
            }
            if (rand.nextInt((int)(3.0f / strength)) == 0 && (y22 = world.func_72976_f(x22 = chunkX + rand.nextInt(16) + 8, z22 = chunkY + rand.nextInt(16) + 8)) < 100) {
                new DecoLog(1, 3 + rand.nextInt(4), false).func_76484_a(world, rand, x22, y22, z22);
            }
            int f24 = 0;
            while ((float)f24 < 4.0f * strength) {
                int j1;
                int i1 = chunkX + rand.nextInt(16) + 8;
                int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
                if (k1 < 110) {
                    new DecoShrub(rand.nextInt(4) + 1, 0, rand.nextBoolean() ? 0 : 2).func_76484_a(world, rand, i1, k1, j1);
                }
                ++f24;
            }
            if (rand.nextInt((int)(150.0f / strength)) == 0) {
                int k21 = chunkX + rand.nextInt(16) + 8;
                int j23 = rand.nextInt(60) + 60;
                int k24 = chunkY + rand.nextInt(16) + 8;
                new DecoWildWheat(rand.nextInt(3)).func_76484_a(world, rand, k21, j23, k24);
            }
            if (rand.nextInt((int)(20.0f / strength)) == 0) {
                int j16 = chunkX + rand.nextInt(16) + 8;
                int j18 = rand.nextInt(100);
                int j21 = chunkY + rand.nextInt(16) + 8;
                new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
            }
            int f23 = 0;
            while ((float)f23 < 4.0f * strength) {
                int j15 = chunkX + rand.nextInt(16) + 8;
                int j17 = rand.nextInt(128);
                int j20 = chunkY + rand.nextInt(16) + 8;
                new DecoFlowers(new int[]{9, 0, 3, 8, 10}).func_76484_a(world, rand, j15, j17, j20);
                ++f23;
            }
            int l14 = 0;
            while ((float)l14 < 12.0f * strength) {
                int l19 = chunkX + rand.nextInt(16) + 8;
                int k22 = rand.nextInt(128);
                int j24 = chunkY + rand.nextInt(16) + 8;
                new DecoGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
                ++l14;
            }
            if (rand.nextInt((int)(2.0f / strength)) == 0) {
                int i18 = chunkX + rand.nextInt(16) + 8;
                int i23 = chunkY + rand.nextInt(16) + 8;
                new WorldGenReed().func_76484_a(world, rand, i18, 60 + rand.nextInt(8), i23);
            }
        }
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border) {
        if (this.subID == 0) {
            float h = perlin.noise2((float)x / 200.0f, (float)y / 200.0f) * 42.0f;
            h = h > 5.0f ? 5.0f : h;
            h += perlin.noise2((float)x / 50.0f, (float)y / 50.0f) * (12.0f - h) * 0.4f;
            h += perlin.noise2((float)x / 15.0f, (float)y / 15.0f) * (12.0f - h) * 0.15f;
            return 67.0f + h;
        }
        float h = perlin.noise2((float)x / 200.0f, (float)y / 200.0f) * 42.0f;
        h = h > 5.0f ? 5.0f : h;
        h += perlin.noise2((float)x / 50.0f, (float)y / 50.0f) * (12.0f - h) * 0.4f;
        h += perlin.noise2((float)x / 15.0f, (float)y / 15.0f) * (12.0f - h) * 0.15f;
        return 67.0f + h;
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise) {
        float p = perlin.noise2((float)i / 8.0f, (float)j / 8.0f) * 0.5f;
        float c = CliffCalculator.calc(x, y, noise);
        boolean cliff = false;
        boolean gravel = false;
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            if (++depth == 0) {
                if (k < 63 || k < 64 && this.subID == 1) {
                    gravel = true;
                }
                if (this.subID == 0 && p > 0.05f || c > 0.45f && c > 1.5f - ((float)k - 60.0f) / 65.0f + p) {
                    cliff = true;
                }
                if (cliff) {
                    blocks[(y * 16 + x) * 256 + k] = rand.nextInt(3) == 0 ? Blocks.field_150347_e : Blocks.field_150348_b;
                    continue;
                }
                if (perlin.noise2((float)i / 50.0f, (float)j / 50.0f) + p * 0.6f > 0.24f) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                    metadata[(y * 16 + x) * 256 + k] = 2;
                    continue;
                }
                if (k < 63 || k < 64 && this.subID == 1) {
                    blocks[(y * 16 + x) * 256 + k] = this.subID == 1 ? Blocks.field_150354_m : Blocks.field_150351_n;
                    gravel = true;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                continue;
            }
            if (depth >= 6) continue;
            blocks[(y * 16 + x) * 256 + k] = cliff ? Blocks.field_150348_b : (gravel ? (this.subID == 1 ? Blocks.field_150354_m : Blocks.field_150351_n) : Blocks.field_150346_d);
        }
    }
}

