/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenTrees;
import rwg.biomes.base.BaseBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoBlob;
import rwg.deco.DecoFlowers;
import rwg.deco.DecoGrass;
import rwg.deco.trees.DecoShrub;
import rwg.deco.trees.DecoSmallPine;
import rwg.util.CellNoise;
import rwg.util.CliffCalculator;
import rwg.util.PerlinNoise;

public class RealisticBiomeTundra
extends RealisticBiomeBase {
    public RealisticBiomeTundra(int sub) {
        super(sub, BaseBiomes.baseColdPlains);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength) {
        int j21;
        int j18;
        int j16;
        int k22;
        int l19;
        int l14;
        int j17;
        int j15;
        int f23;
        int k10;
        int j6;
        int z52;
        int k1;
        int j1;
        int i1;
        int l = 0;
        while ((float)l < 3.0f * strength) {
            int j12;
            int i12 = chunkX + rand.nextInt(16) + 8;
            int k12 = world.func_72976_f(i12, j12 = chunkY + rand.nextInt(16) + 8);
            if (k12 < 85 && (k12 < 64 || rand.nextInt(5) == 0)) {
                new DecoBlob(Blocks.field_150347_e, 0).func_76484_a(world, rand, i12, k12, j12);
            }
            ++l;
        }
        if (this.subID == 0) {
            if (rand.nextInt((int)(1.0f / strength)) == 0) {
                i1 = chunkX + rand.nextInt(16) + 8;
                j1 = chunkY + rand.nextInt(16) + 8;
                k1 = world.func_72976_f(i1, j1);
                if (rand.nextInt(10) == 0) {
                    new DecoShrub(rand.nextInt(5) + 4, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
                } else {
                    new DecoShrub(rand.nextInt(4) + 1, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
                }
            }
            if (rand.nextInt((int)(3.0f / strength)) == 0 && (z52 = world.func_72976_f(j6 = chunkX + rand.nextInt(16) + 8, k10 = chunkY + rand.nextInt(16) + 8)) < 69) {
                DecoSmallPine worldgenerator = new DecoSmallPine(1 + rand.nextInt(2), 4 + rand.nextInt(4));
                worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                worldgenerator.func_76484_a(world, rand, j6, z52, k10);
            }
            f23 = 0;
            while ((float)f23 < 2.0f * strength) {
                j15 = chunkX + rand.nextInt(16) + 8;
                j17 = rand.nextInt(128);
                int j20 = chunkY + rand.nextInt(16) + 8;
                new DecoFlowers(new int[]{0}).func_76484_a(world, rand, j15, j17, j20);
                ++f23;
            }
            l14 = 0;
            while ((float)l14 < 4.0f * strength) {
                l19 = chunkX + rand.nextInt(16) + 8;
                k22 = rand.nextInt(128);
                int j24 = chunkY + rand.nextInt(16) + 8;
                new DecoGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
                ++l14;
            }
        } else if (this.subID == 1) {
            if (rand.nextInt((int)(1.0f / strength)) == 0) {
                i1 = chunkX + rand.nextInt(16) + 8;
                j1 = chunkY + rand.nextInt(16) + 8;
                k1 = world.func_72976_f(i1, j1);
                if (rand.nextInt(10) == 0) {
                    new DecoShrub(rand.nextInt(5) + 4, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
                } else {
                    new DecoShrub(rand.nextInt(4) + 1, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
                }
            }
            if (rand.nextInt((int)(3.0f / strength)) == 0 && (z52 = world.func_72976_f(j6 = chunkX + rand.nextInt(16) + 8, k10 = chunkY + rand.nextInt(16) + 8)) < 68) {
                DecoSmallPine worldgenerator = new DecoSmallPine(1 + rand.nextInt(2), 4 + rand.nextInt(4));
                worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                worldgenerator.func_76484_a(world, rand, j6, z52, k10);
            }
            if (rand.nextInt((int)(30.0f / strength)) == 0) {
                j16 = chunkX + rand.nextInt(16) + 8;
                j18 = rand.nextInt(128);
                j21 = chunkY + rand.nextInt(16) + 8;
                new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
            }
            f23 = 0;
            while ((float)f23 < 2.0f * strength) {
                j15 = chunkX + rand.nextInt(16) + 8;
                j17 = rand.nextInt(128);
                int j20 = chunkY + rand.nextInt(16) + 8;
                new DecoFlowers(new int[]{0}).func_76484_a(world, rand, j15, j17, j20);
                ++f23;
            }
            l14 = 0;
            while ((float)l14 < 5.0f * strength) {
                l19 = chunkX + rand.nextInt(16) + 8;
                k22 = rand.nextInt(128);
                int j24 = chunkY + rand.nextInt(16) + 8;
                new DecoGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
                ++l14;
            }
        } else {
            if (rand.nextInt((int)(1.0f / strength)) == 0) {
                i1 = chunkX + rand.nextInt(16) + 8;
                j1 = chunkY + rand.nextInt(16) + 8;
                k1 = world.func_72976_f(i1, j1);
                if (rand.nextInt(10) == 0) {
                    new DecoShrub(rand.nextInt(5) + 4, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
                } else {
                    new DecoShrub(rand.nextInt(4) + 1, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
                }
            }
            if (rand.nextInt((int)(1.0f / strength)) == 0 && ((z52 = world.func_72976_f(j6 = chunkX + rand.nextInt(16) + 8, k10 = chunkY + rand.nextInt(16) + 8)) < 65 || z52 < 70 && rand.nextInt(3) == 0)) {
                Object worldgenerator = rand.nextBoolean() ? new WorldGenTrees(false) : new DecoSmallPine(1 + rand.nextInt(2), 4 + rand.nextInt(4));
                worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                worldgenerator.func_76484_a(world, rand, j6, z52, k10);
            }
            if (rand.nextInt((int)(30.0f / strength)) == 0) {
                j16 = chunkX + rand.nextInt(16) + 8;
                j18 = rand.nextInt(128);
                j21 = chunkY + rand.nextInt(16) + 8;
                new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
            }
            f23 = 0;
            while ((float)f23 < 3.0f * strength) {
                j15 = chunkX + rand.nextInt(16) + 8;
                j17 = rand.nextInt(128);
                int j20 = chunkY + rand.nextInt(16) + 8;
                new DecoFlowers(new int[]{0, 0, 0, 3, 3, 9}).func_76484_a(world, rand, j15, j17, j20);
                ++f23;
            }
            l14 = 0;
            while ((float)l14 < 8.0f * strength) {
                l19 = chunkX + rand.nextInt(16) + 8;
                k22 = rand.nextInt(128);
                int j24 = chunkY + rand.nextInt(16) + 8;
                new DecoGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
                ++l14;
            }
        }
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border) {
        if (this.subID == 0) {
            float h = perlin.noise2((float)x / 300.0f, (float)y / 300.0f) * 125.0f;
            float f = h = (h *= h / 32.0f) > 200.0f ? 200.0f : h;
            if (h > 2.0f) {
                float d = (h - 2.0f) / 2.0f > 8.0f ? 8.0f : (h - 2.0f) / 2.0f;
                h += perlin.noise2((float)x / 18.0f, (float)y / 18.0f) * d;
                if ((h += perlin.noise2((float)x / 50.0f, (float)y / 50.0f) * d * 0.5f) > 60.0f) {
                    float d2 = (h - 60.0f) / 1.5f > 35.0f ? 35.0f : (h - 60.0f) / 1.5f;
                    h += cell.noise((double)x / 25.0, (double)y / 25.0, 1.0) * d2;
                }
            }
            h += perlin.noise2((float)x / 18.0f, (float)y / 18.0f) * 4.0f;
            return (h += perlin.noise2((float)x / 8.0f, (float)y / 8.0f) * 2.0f) + 67.0f;
        }
        if (this.subID == 1) {
            float h = perlin.noise2((float)x / 300.0f, (float)y / 300.0f) * 40.0f;
            h = h > 3.0f ? 3.0f : h;
            h += perlin.noise2((float)x / 50.0f, (float)y / 50.0f) * (12.0f - h) * 0.4f;
            h += perlin.noise2((float)x / 15.0f, (float)y / 15.0f) * (12.0f - h) * 0.15f;
            return 65.0f + h;
        }
        float h = perlin.noise2((float)x / 300.0f, (float)y / 300.0f) * 35.0f;
        h = h > 5.0f ? 5.0f : h;
        h += perlin.noise2((float)x / 50.0f, (float)y / 50.0f) * (12.0f - h) * 0.4f;
        h += perlin.noise2((float)x / 15.0f, (float)y / 15.0f) * (12.0f - h) * 0.15f;
        return 65.0f + h;
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise) {
        if (this.subID == 0) {
            float p = perlin.noise2((float)i / 8.0f, (float)j / 8.0f) * 0.5f;
            float c = CliffCalculator.calc(x, y, noise);
            int cliff = 0;
            boolean gravel = false;
            for (int k = 255; k > -1; --k) {
                Block b = blocks[(y * 16 + x) * 256 + k];
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth == 0) {
                    if (k < 63) {
                        gravel = true;
                    }
                    if (c > 0.45f && c > 1.5f - ((float)k - 60.0f) / 65.0f + p) {
                        cliff = 1;
                    }
                    if (c > 1.5f) {
                        cliff = 2;
                    }
                    if (c < 0.3f + ((float)k - 100.0f) / 50.0f + p) {
                        cliff = 3;
                    }
                    if (cliff == 1) {
                        blocks[(y * 16 + x) * 256 + k] = rand.nextInt(3) == 0 ? Blocks.field_150347_e : Blocks.field_150348_b;
                        continue;
                    }
                    if (cliff == 2) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150406_ce;
                        metadata[(y * 16 + x) * 256 + k] = 9;
                        continue;
                    }
                    if (cliff == 3) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150433_aE;
                        continue;
                    }
                    if (perlin.noise2((float)i / 50.0f, (float)j / 50.0f) + p * 0.6f > 0.24f) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                        metadata[(y * 16 + x) * 256 + k] = 2;
                        continue;
                    }
                    if (k < 63) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150351_n;
                        gravel = true;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                    continue;
                }
                if (depth >= 6) continue;
                if (cliff == 1) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150348_b;
                    continue;
                }
                if (cliff == 2) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150406_ce;
                    metadata[(y * 16 + x) * 256 + k] = 9;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = cliff == 3 ? Blocks.field_150433_aE : (gravel ? Blocks.field_150351_n : Blocks.field_150346_d);
            }
        } else if (this.subID == 1) {
            float p = perlin.noise2((float)i / 8.0f, (float)j / 8.0f) * 0.5f;
            float c = CliffCalculator.calc(x, y, noise);
            boolean grass = false;
            boolean snow = false;
            for (int k = 255; k > -1; --k) {
                Block b = blocks[(y * 16 + x) * 256 + k];
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b || ++depth >= 5) continue;
                if (depth == 0) {
                    if (k <= 61) continue;
                    if (perlin.noise2((float)i / 50.0f, (float)j / 50.0f) + p * 0.6f > 0.24f) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                        metadata[(y * 16 + x) * 256 + k] = 2;
                        continue;
                    }
                    if (p < 0.0f) {
                        grass = true;
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = rand.nextInt(3) == 0 ? Blocks.field_150347_e : Blocks.field_150348_b;
                    continue;
                }
                if (snow) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150433_aE;
                    continue;
                }
                if (!grass) continue;
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
            }
        } else {
            float c = CliffCalculator.calc(x, y, noise);
            boolean cliff = c > 1.1f;
            boolean clay = c > 1.5f;
            boolean stone = false;
            float m = perlin.noise2((float)i / 12.0f, (float)j / 12.0f);
            for (int k = 255; k > -1; --k) {
                Block b = blocks[(y * 16 + x) * 256 + k];
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b || ++depth >= 5) continue;
                if (cliff) {
                    if (clay) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150406_ce;
                        metadata[(y * 16 + x) * 256 + k] = 9;
                        continue;
                    }
                    if (depth <= -1 || depth >= 2) continue;
                    blocks[(y * 16 + x) * 256 + k] = rand.nextInt(3) == 0 ? Blocks.field_150347_e : Blocks.field_150348_b;
                    continue;
                }
                if (depth == 0) {
                    if (m > 0.15f) {
                        stone = true;
                        blocks[(y * 16 + x) * 256 + k] = rand.nextInt(3) == 0 ? Blocks.field_150347_e : Blocks.field_150348_b;
                        continue;
                    }
                    if (k > 61) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                    continue;
                }
                if (stone) continue;
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
            }
        }
    }
}

