/*
 * Decompiled with CFR 0.152.
 */
package rwg.world;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.util.CanyonColor;
import rwg.util.CellNoise;
import rwg.util.PerlinNoise;
import rwg.world.ChunkManagerRealistic;

public class ChunkGeneratorRealistic
implements IChunkProvider {
    private Random rand;
    private World worldObj;
    private ChunkManagerRealistic cmr;
    private MapGenCaves caves;
    private MapGenStronghold strongholdGenerator = new MapGenStronghold();
    private MapGenMineshaft mineshaftGenerator = new MapGenMineshaft();
    private MapGenVillage villageGenerator;
    private PerlinNoise perlin;
    private CellNoise cell;
    private RealisticBiomeBase[] biomesForGeneration;
    private final int sampleSize = 8;
    private final int sampleArraySize;
    private final int parabolicSize;
    private final int parabolicArraySize;
    private final float[] parabolicField;
    private float parabolicFieldTotal;

    public ChunkGeneratorRealistic(World world, long l) {
        this.caves = new MapGenCaves();
        this.worldObj = world;
        this.cmr = (ChunkManagerRealistic)this.worldObj.func_72959_q();
        this.rand = new Random(l);
        this.perlin = new PerlinNoise(l);
        this.cell = new CellNoise(l, 0);
        this.cell.setUseDistance(true);
        this.villageGenerator = new MapGenVillage();
        CanyonColor.init(l);
        this.sampleArraySize = 21;
        this.parabolicSize = 8;
        this.parabolicArraySize = this.parabolicSize * 2 + 1;
        this.parabolicField = new float[this.parabolicArraySize * this.parabolicArraySize];
        for (int j = -this.parabolicSize; j <= this.parabolicSize; ++j) {
            for (int k = -this.parabolicSize; k <= this.parabolicSize; ++k) {
                float f;
                this.parabolicField[j + this.parabolicSize + (k + this.parabolicSize) * this.parabolicArraySize] = f = 0.445f / MathHelper.func_76129_c((float)((float)(j * 1 * (j * 1) + k * 1 * (k * 1)) + 0.3f));
                this.parabolicFieldTotal += f;
            }
        }
    }

    public Chunk func_73154_d(int cx, int cy) {
        this.rand.setSeed((long)cx * 341873128712L + (long)cy * 132897987541L);
        Block[] blocks = new Block[65536];
        byte[] metadata = new byte[65536];
        float[] noise = new float[256];
        this.biomesForGeneration = new RealisticBiomeBase[256];
        this.generateTerrain(this.cmr, cx, cy, blocks, metadata, this.biomesForGeneration, noise);
        this.replaceBlocksForBiome(cx, cy, blocks, metadata, this.biomesForGeneration, noise);
        this.caves.func_151539_a((IChunkProvider)this, this.worldObj, cx, cy, blocks);
        this.mineshaftGenerator.func_151539_a((IChunkProvider)this, this.worldObj, cx, cy, blocks);
        this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.worldObj, cx, cy, blocks);
        this.villageGenerator.func_151539_a((IChunkProvider)this, this.worldObj, cx, cy, blocks);
        Chunk chunk = new Chunk(this.worldObj, blocks, metadata, cx, cy);
        byte[] abyte1 = chunk.func_76605_m();
        for (int k = 0; k < abyte1.length; ++k) {
            abyte1[k] = (byte)this.biomesForGeneration[this.parabolicSize * 16 + this.parabolicSize].baseBiome.field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void generateTerrain(ChunkManagerRealistic cmr, int cx, int cy, Block[] blocks, byte[] metadata, RealisticBiomeBase[] biomes, float[] n) {
        float[] noise = this.getNewNoise(cmr, cx * 16, cy * 16, biomes);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int h = (int)noise[j * 16 + i];
                for (int k = 0; k < 256; ++k) {
                    int p = (j * 16 + i) * 256 + k;
                    if (k > h) {
                        if (k < 63) {
                            blocks[p] = Blocks.field_150355_j;
                            continue;
                        }
                        blocks[p] = Blocks.field_150350_a;
                        continue;
                    }
                    blocks[p] = Blocks.field_150348_b;
                }
                n[j * 16 + i] = noise[j * 16 + i];
            }
        }
    }

    public float[] getNewNoise(ChunkManagerRealistic cmr, int x, int y, RealisticBiomeBase[] biomes) {
        int l;
        int k;
        int j;
        int i;
        int[] biomeData = new int[this.sampleArraySize * this.sampleArraySize];
        for (i = -8; i < 13; ++i) {
            for (j = -8; j < 13; ++j) {
                biomeData[(i + 8) * this.sampleArraySize + (j + 8)] = cmr.getBiomeDataAt((int)(x + (i * 8 - 8)), (int)(y + (j * 8 - 8))).biomeID;
            }
        }
        float[][] hugeRender = new float[81][256];
        float[][] smallRender = new float[625][256];
        for (i = -1; i < 4; ++i) {
            for (j = -1; j < 4; ++j) {
                for (k = -this.parabolicSize; k <= this.parabolicSize; ++k) {
                    for (l = -this.parabolicSize; l <= this.parabolicSize; ++l) {
                        float[] fArray = hugeRender[(i * 2 + 2) * 9 + (j * 2 + 2)];
                        int n = biomeData[(i + k + 8 + 1) * this.sampleArraySize + (j + l + 8 + 1)];
                        fArray[n] = fArray[n] + this.parabolicField[k + this.parabolicSize + (l + this.parabolicSize) * this.parabolicArraySize] / this.parabolicFieldTotal;
                    }
                }
            }
        }
        biomeData = null;
        RealisticBiomeBase b = null;
        for (i = 0; i < 256; ++i) {
            if (!(hugeRender[40][i] > 0.9f)) continue;
            b = RealisticBiomeBase.getBiome(i);
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                hugeRender[(i * 2 + 1) * 9 + (j * 2 + 1)] = this.mix4(new float[][]{hugeRender[i * 2 * 9 + j * 2], hugeRender[(i * 2 + 2) * 9 + j * 2], hugeRender[i * 2 * 9 + (j * 2 + 2)], hugeRender[(i * 2 + 2) * 9 + (j * 2 + 2)]});
            }
        }
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < 7; ++j) {
                smallRender[i * 4 * 25 + j * 4] = !(i % 2 == 0 && j % 2 == 0 || i % 2 != 0 && j % 2 != 0) ? this.mix4(new float[][]{hugeRender[i * 9 + (j + 1)], hugeRender[(i + 1) * 9 + j], hugeRender[(i + 1) * 9 + (j + 2)], hugeRender[(i + 2) * 9 + (j + 1)]}) : hugeRender[(i + 1) * 9 + (j + 1)];
            }
        }
        hugeRender = null;
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 6; ++j) {
                smallRender[(i * 4 + 2) * 25 + (j * 4 + 2)] = this.mix4(new float[][]{smallRender[i * 4 * 25 + j * 4], smallRender[(i * 4 + 4) * 25 + j * 4], smallRender[i * 4 * 25 + (j * 4 + 4)], smallRender[(i * 4 + 4) * 25 + (j * 4 + 4)]});
            }
        }
        for (i = 0; i < 11; ++i) {
            for (j = 0; j < 11; ++j) {
                if (i % 2 == 0 && j % 2 == 0 || i % 2 != 0 && j % 2 != 0) continue;
                smallRender[(i * 2 + 2) * 25 + (j * 2 + 2)] = this.mix4(new float[][]{smallRender[i * 2 * 25 + (j * 2 + 2)], smallRender[(i * 2 + 2) * 25 + j * 2], smallRender[(i * 2 + 2) * 25 + (j * 2 + 4)], smallRender[(i * 2 + 4) * 25 + (j * 2 + 2)]});
            }
        }
        for (i = 0; i < 9; ++i) {
            for (j = 0; j < 9; ++j) {
                smallRender[(i * 2 + 3) * 25 + (j * 2 + 3)] = this.mix4(new float[][]{smallRender[(i * 2 + 2) * 25 + (j * 2 + 2)], smallRender[(i * 2 + 4) * 25 + (j * 2 + 2)], smallRender[(i * 2 + 2) * 25 + (j * 2 + 4)], smallRender[(i * 2 + 4) * 25 + (j * 2 + 4)]});
            }
        }
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < 16; ++j) {
                if (i % 2 == 0 && j % 2 == 0 || i % 2 != 0 && j % 2 != 0) continue;
                smallRender[(i + 4) * 25 + (j + 4)] = this.mix4(new float[][]{smallRender[(i + 3) * 25 + (j + 4)], smallRender[(i + 4) * 25 + (j + 3)], smallRender[(i + 4) * 25 + (j + 5)], smallRender[(i + 5) * 25 + (j + 4)]});
            }
        }
        boolean randBiome = true;
        float bCount = 0.0f;
        float bRand = 0.0f;
        if (b != null) {
            randBiome = false;
            for (i = 0; i < 256; ++i) {
                biomes[i] = b;
            }
        }
        float[] testHeight = new float[256];
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < 16; ++j) {
                if (randBiome) {
                    bCount = 0.0f;
                    bRand = 0.5f + this.perlin.noise2((float)(x + i) / 5.0f, (float)(y + j) / 5.0f);
                    bRand = bRand < 0.0f ? 0.0f : (bRand > 0.99999f ? 0.99999f : bRand);
                }
                float ocean = cmr.getOceanValue(x, y);
                l = (i + 4) * 25 + (j + 4);
                for (k = 0; k < 256; ++k) {
                    if (!(smallRender[l][k] > 0.0f)) continue;
                    if (randBiome && bCount <= 1.0f && (bCount += smallRender[l][k]) > bRand) {
                        biomes[j * 16 + i] = RealisticBiomeBase.getBiome(k);
                        bCount = 2.0f;
                    }
                    int n = i * 16 + j;
                    testHeight[n] = testHeight[n] + RealisticBiomeBase.getBiome(k).rNoise(this.perlin, this.cell, x + i, y + j, ocean, smallRender[l][k]) * smallRender[l][k];
                }
            }
        }
        return testHeight;
    }

    public float[] mix4(float[][] ingredients) {
        float[] result = new float[256];
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (!(ingredients[j][i] > 0.0f)) continue;
                int n = i;
                result[n] = result[n] + ingredients[j][i] / 4.0f;
            }
        }
        return result;
    }

    public void replaceBlocksForBiome(int cx, int cy, Block[] blocks, byte[] metadata, RealisticBiomeBase[] biomes, float[] n) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                RealisticBiomeBase biome = biomes[i * 16 + j];
                int depth = -1;
                biome.rReplace(blocks, metadata, cx * 16 + j, cy * 16 + i, i, j, depth, this.rand, this.perlin, this.cell, n);
                blocks[(j * 16 + i) * 256] = Blocks.field_150357_h;
            }
        }
    }

    public Chunk func_73158_c(int par1, int par2) {
        return this.func_73154_d(par1, par2);
    }

    private double[] func_4061_a(double[] ad, int i, int j, int k, int l, int i1, int j1) {
        return null;
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public void func_73153_a(IChunkProvider ichunkprovider, int i, int j) {
        int j2;
        BlockFalling.field_149832_M = true;
        int x = i * 16;
        int y = j * 16;
        RealisticBiomeBase biome = this.cmr.getBiomeDataAt(x + 16, y + 16);
        this.rand.setSeed(this.worldObj.func_72905_C());
        long i1 = this.rand.nextLong() / 2L * 2L + 1L;
        long j1 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)i * i1 + (long)j * j1 ^ this.worldObj.func_72905_C());
        boolean flag = false;
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(ichunkprovider, this.worldObj, this.rand, i, j, flag));
        this.mineshaftGenerator.func_75051_a(this.worldObj, this.rand, i, j);
        this.strongholdGenerator.func_75051_a(this.worldObj, this.rand, i, j);
        this.villageGenerator.func_75051_a(this.worldObj, this.rand, i, j);
        if (this.rand.nextInt(10) == 0) {
            int i2 = x + this.rand.nextInt(16) + 8;
            int l4 = this.rand.nextInt(50);
            int i8 = y + this.rand.nextInt(16) + 8;
            new WorldGenLakes(Blocks.field_150355_j).func_76484_a(this.worldObj, this.rand, i2, l4, i8);
        }
        if (this.rand.nextInt(18) == 0) {
            j2 = x + this.rand.nextInt(16) + 8;
            int i5 = this.rand.nextInt(this.rand.nextInt(45) + 8);
            int j8 = y + this.rand.nextInt(16) + 8;
            if (i5 < 64 || this.rand.nextInt(10) == 0) {
                new WorldGenLakes(Blocks.field_150353_l).func_76484_a(this.worldObj, this.rand, j2, i5, j8);
            }
        }
        for (int k1 = 0; k1 < 8; ++k1) {
            int j5 = x + this.rand.nextInt(16) + 8;
            int k8 = this.rand.nextInt(128);
            int j11 = y + this.rand.nextInt(16) + 8;
            new WorldGenDungeons().func_76484_a(this.worldObj, this.rand, j5, k8, j11);
        }
        for (j2 = 0; j2 < 10; ++j2) {
            int l5 = x + this.rand.nextInt(16);
            int i9 = this.rand.nextInt(64);
            int l11 = y + this.rand.nextInt(16);
            new WorldGenMinable(Blocks.field_150346_d, 32).func_76484_a(this.worldObj, this.rand, l5, i9, l11);
        }
        for (int k2 = 0; k2 < 5; ++k2) {
            int i6 = x + this.rand.nextInt(16);
            int j9 = this.rand.nextInt(64);
            int i12 = y + this.rand.nextInt(16);
            new WorldGenMinable(Blocks.field_150351_n, 32).func_76484_a(this.worldObj, this.rand, i6, j9, i12);
        }
        for (int i3 = 0; i3 < 20; ++i3) {
            int j6 = x + this.rand.nextInt(16);
            int k9 = this.rand.nextInt(128);
            int j12 = y + this.rand.nextInt(16);
            new WorldGenMinable(Blocks.field_150365_q, 16).func_76484_a(this.worldObj, this.rand, j6, k9, j12);
        }
        for (int j3 = 0; j3 < 20; ++j3) {
            int k6 = x + this.rand.nextInt(16);
            int l9 = this.rand.nextInt(64);
            int k12 = y + this.rand.nextInt(16);
            new WorldGenMinable(Blocks.field_150366_p, 8).func_76484_a(this.worldObj, this.rand, k6, l9, k12);
        }
        for (int k3 = 0; k3 < 2; ++k3) {
            int l6 = x + this.rand.nextInt(16);
            int i10 = this.rand.nextInt(32);
            int l12 = y + this.rand.nextInt(16);
            new WorldGenMinable(Blocks.field_150352_o, 8).func_76484_a(this.worldObj, this.rand, l6, i10, l12);
        }
        for (int l3 = 0; l3 < 8; ++l3) {
            int i7 = x + this.rand.nextInt(16);
            int j10 = this.rand.nextInt(16);
            int i13 = y + this.rand.nextInt(16);
            new WorldGenMinable(Blocks.field_150450_ax, 7).func_76484_a(this.worldObj, this.rand, i7, j10, i13);
        }
        for (int i4 = 0; i4 < 1; ++i4) {
            int j7 = x + this.rand.nextInt(16);
            int k10 = this.rand.nextInt(16);
            int j13 = y + this.rand.nextInt(16);
            new WorldGenMinable(Blocks.field_150482_ag, 7).func_76484_a(this.worldObj, this.rand, j7, k10, j13);
        }
        for (int j4 = 0; j4 < 1; ++j4) {
            int k7 = x + this.rand.nextInt(16);
            int l10 = this.rand.nextInt(16) + this.rand.nextInt(16);
            int k13 = y + this.rand.nextInt(16);
            new WorldGenMinable(Blocks.field_150369_x, 6).func_76484_a(this.worldObj, this.rand, k7, l10, k13);
        }
        for (int g12 = 0; g12 < 4; ++g12) {
            int p1;
            int m1;
            int n1 = x + this.rand.nextInt(16);
            if (!this.worldObj.func_147439_a(n1, m1 = this.rand.nextInt(28) + 4, p1 = y + this.rand.nextInt(16)).isReplaceableOreGen(this.worldObj, n1, m1, p1, Blocks.field_150348_b)) continue;
            this.worldObj.func_147465_d(n1, m1, p1, Blocks.field_150412_bA, 0, 2);
        }
        if (this.rand.nextInt(5) == 0) {
            int k15 = x + this.rand.nextInt(16) + 8;
            int k17 = this.rand.nextInt(64);
            int k20 = y + this.rand.nextInt(16) + 8;
            if (this.rand.nextBoolean()) {
                new WorldGenFlowers((Block)Blocks.field_150338_P).func_76484_a(this.worldObj, this.rand, k15, k17, k20);
            } else {
                new WorldGenFlowers((Block)Blocks.field_150337_Q).func_76484_a(this.worldObj, this.rand, k15, k17, k20);
            }
        }
        float[] biomeNoise = new float[256];
        for (int bx = -4; bx <= 4; ++bx) {
            for (int by = -4; by <= 4; ++by) {
                int n = this.cmr.getBiomeDataAt((int)(x + 24 + bx * 16), (int)(y + 24 + by * 16)).biomeID;
                biomeNoise[n] = biomeNoise[n] + 0.01234569f;
            }
        }
        float snow = 0.0f;
        for (int bn = 0; bn < 256; ++bn) {
            if (!(biomeNoise[bn] > 0.0f)) continue;
            if (biomeNoise[bn] >= 1.0f) {
                biomeNoise[bn] = 1.0f;
            }
            RealisticBiomeBase b = RealisticBiomeBase.getBiome(bn);
            b.rDecorate(this.worldObj, this.rand, x, y, this.perlin, this.cell, biomeNoise[bn]);
            if (b.baseBiome.field_76750_F < 0.15f) {
                snow -= 0.6f * biomeNoise[bn];
                continue;
            }
            snow += 0.6f * biomeNoise[bn];
        }
        for (int l18 = 0; l18 < 50; ++l18) {
            int l21 = x + this.rand.nextInt(16) + 8;
            int k23 = this.rand.nextInt(this.rand.nextInt(120) + 8);
            int l24 = y + this.rand.nextInt(16) + 8;
            new WorldGenLiquids((Block)Blocks.field_150358_i).func_76484_a(this.worldObj, this.rand, l21, k23, l24);
        }
        for (int i19 = 0; i19 < 20; ++i19) {
            int i22 = x + this.rand.nextInt(16) + 8;
            int l23 = this.rand.nextInt(this.rand.nextInt(this.rand.nextInt(112) + 8) + 8);
            int i25 = y + this.rand.nextInt(16) + 8;
            new WorldGenLiquids((Block)Blocks.field_150356_k).func_76484_a(this.worldObj, this.rand, i22, l23, i25);
        }
        SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)biome.baseBiome, (int)(x + 8), (int)(y + 8), (int)16, (int)16, (Random)this.rand);
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(ichunkprovider, this.worldObj, this.rand, i, j, flag));
        if (snow < 0.59f) {
            x += 8;
            y += 8;
            for (int sn1 = 0; sn1 < 16; ++sn1) {
                for (int sn2 = 0; sn2 < 16; ++sn2) {
                    float s = snow < -0.59f ? -1.0f : this.perlin.noise2((float)(sn1 + x) / 3.0f, (float)(sn2 + y) / 3.0f) + snow;
                    if (!(s < 0.0f)) continue;
                    int sn3 = this.worldObj.func_72874_g(x + sn1, y + sn2);
                    Block b1 = this.worldObj.func_147439_a(sn1 + x, sn3, sn2 + y);
                    Block b2 = this.worldObj.func_147439_a(sn1 + x, sn3 - 1, sn2 + y);
                    if (b2 == Blocks.field_150355_j || b2 == Blocks.field_150358_i) {
                        this.worldObj.func_147465_d(sn1 + x, sn3 - 1, sn2 + y, Blocks.field_150432_aD, 0, 2);
                    }
                    if (!Blocks.field_150431_aC.func_149742_c(this.worldObj, sn1 + x, sn3, sn2 + y) || b2 == Blocks.field_150432_aD || b2 == Blocks.field_150355_j || sn3 <= 62 || b1 == Blocks.field_150431_aC || b2 == Blocks.field_150403_cj) continue;
                    this.worldObj.func_147465_d(sn1 + x, sn3, sn2 + y, Blocks.field_150431_aC, 0, 2);
                }
            }
        }
        BlockFalling.field_149832_M = false;
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean unload100OldestChunks() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        BiomeGenBase var5 = this.worldObj.func_72807_a(par2, par4);
        return var5 == null ? null : var5.func_76747_a(par1EnumCreatureType);
    }

    public ChunkPosition func_147416_a(World par1World, String par2Str, int par3, int par4, int par5) {
        return "Stronghold".equals(par2Str) && this.strongholdGenerator != null ? this.strongholdGenerator.func_151545_a(par1World, par3, par4, par5) : null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_104112_b() {
    }

    public void func_82695_e(int par1, int par2) {
        this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])null);
        this.mineshaftGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])null);
        this.villageGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])null);
    }
}

