/*
 * Decompiled with CFR 0.152.
 */
package rwg.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.util.CellNoise;
import rwg.util.PerlinNoise;

public class ChunkManagerRealistic
extends WorldChunkManager {
    private BiomeCache biomeCache = new BiomeCache((WorldChunkManager)this);
    private List biomesToSpawnIn = new ArrayList();
    private PerlinNoise perlin;
    private CellNoise cell;
    private CellNoise biomecell;
    private int biomeLength;
    private RealisticBiomeBase[] biomes_polar;
    private RealisticBiomeBase[] biomes_snow;
    private RealisticBiomeBase[] biomes_taiga;
    private RealisticBiomeBase[] biomes_tundra;

    protected ChunkManagerRealistic() {
    }

    public ChunkManagerRealistic(World par1World) {
        this();
        long seed = par1World.func_72905_C();
        this.perlin = new PerlinNoise(seed);
        this.cell = new CellNoise(seed, 0);
        this.cell.setUseDistance(true);
        this.biomecell = new CellNoise(seed, 0);
        this.biomes_polar = new RealisticBiomeBase[]{RealisticBiomeBase.landPolarPlains, RealisticBiomeBase.landPolarLakes};
        this.biomes_snow = new RealisticBiomeBase[]{RealisticBiomeBase.landSnowHillsHigh, RealisticBiomeBase.landSnowHillsRivers, RealisticBiomeBase.landSnowHillsSpikes, RealisticBiomeBase.landSnowPlainsField, RealisticBiomeBase.landSnowLakesIslands};
        this.biomes_taiga = new RealisticBiomeBase[]{RealisticBiomeBase.landTaigaHillsShield, RealisticBiomeBase.landTaigaHillsRivers, RealisticBiomeBase.landTaigaHillsSpikes, RealisticBiomeBase.landTaigaHillsMix, RealisticBiomeBase.landTaigaPlainsShield, RealisticBiomeBase.landTaigaPlainsMix, RealisticBiomeBase.landTaigaLakesIslands, RealisticBiomeBase.landTaigaLakesSwamp, RealisticBiomeBase.landTaigaLakesMix};
        this.biomes_tundra = new RealisticBiomeBase[]{RealisticBiomeBase.landTundraHillsHigh, RealisticBiomeBase.landTundraHillsValley, RealisticBiomeBase.landTundraHillsSpikes, RealisticBiomeBase.landTundraPlainsPolar, RealisticBiomeBase.landTundraPlainsShield, RealisticBiomeBase.landTundraPlainsMix, RealisticBiomeBase.landTundraLakesIslands, RealisticBiomeBase.landTundraLakesShield};
    }

    public int[] getBiomesGens(int par1, int par2, int par3, int par4) {
        int[] d = new int[par3 * par4];
        for (int i = 0; i < par3; ++i) {
            for (int j = 0; j < par4; ++j) {
                d[j * par3 + i] = this.func_76935_a((int)(par1 + i), (int)(par2 + j)).field_76756_M;
            }
        }
        return d;
    }

    public RealisticBiomeBase[] getBiomesGensData(int par1, int par2, int par3, int par4) {
        RealisticBiomeBase[] data = new RealisticBiomeBase[par3 * par4];
        for (int i = 0; i < par3; ++i) {
            for (int j = 0; j < par4; ++j) {
                data[j * par3 + i] = this.getBiomeDataAt(par1 + i, par2 + j);
            }
        }
        return data;
    }

    public float getOceanValue(int x, int y) {
        return 1.0f;
    }

    public BiomeGenBase func_76935_a(int par1, int par2) {
        return this.getBiomeDataAt((int)par1, (int)par2, (float)this.getOceanValue((int)par1, (int)par2)).baseBiome;
    }

    public RealisticBiomeBase getBiomeDataAt(int par1, int par2) {
        return this.getBiomeDataAt(par1, par2, this.getOceanValue(par1, par2));
    }

    public RealisticBiomeBase getBiomeDataAt(int par1, int par2, float ocean) {
        float h = this.biomecell.noise((double)par1 / 450.0, (double)par2 / 450.0, 1.0) * 0.5f + 0.5f;
        h = h < 0.0f ? 0.0f : (h >= 0.9999999f ? 0.9999999f : h);
        float temp = 0.5f + this.perlin.noise2(((float)par1 + 2000.0f) / 2000.0f, (float)par2 / 2000.0f) * 1.1f;
        float hum = 0.5f + this.perlin.noise2(((float)par1 - 2000.0f) / 2000.0f, (float)par2 / 2000.0f) * 1.1f;
        float f = temp > 1.0f ? 1.0f : (temp = temp < 0.0f ? 0.0f : temp);
        float f2 = hum > 1.0f ? 1.0f : (hum = hum < 0.0f ? 0.0f : hum);
        if (1.0f - temp + hum > 1.0f) {
            hum -= temp;
            temp += hum;
        }
        if (temp < 0.15f) {
            return this.biomes_polar[(int)(h *= 2.0f)];
        }
        if (hum < 0.2f) {
            return this.biomes_tundra[(int)(h *= 8.0f)];
        }
        if (temp < 0.5f) {
            return this.biomes_snow[(int)(h *= 5.0f)];
        }
        if (temp > 0.85f && hum > 0.85f) {
            return RealisticBiomeBase.landRedwoodSpikes;
        }
        return this.biomes_taiga[(int)(h *= 9.0f)];
    }

    public float getNoiseAt(int x, int y) {
        float ocean = this.getOceanValue(x, y);
        return this.getBiomeDataAt(x, y, ocean).rNoise(this.perlin, this.cell, x, y, ocean, 1.0f);
    }

    public List func_76932_a() {
        return this.biomesToSpawnIn;
    }

    public float[] func_76936_a(float[] par1ArrayOfFloat, int par2, int par3, int par4, int par5) {
        if (par1ArrayOfFloat == null || par1ArrayOfFloat.length < par4 * par5) {
            par1ArrayOfFloat = new float[par4 * par5];
        }
        int[] var6 = this.getBiomesGens(par2, par3, par4, par5);
        for (int var7 = 0; var7 < par4 * par5; ++var7) {
            float var8 = (float)BiomeGenBase.func_150568_d((int)var6[var7]).func_76744_g() / 65536.0f;
            if (var8 > 1.0f) {
                var8 = 1.0f;
            }
            par1ArrayOfFloat[var7] = var8;
        }
        return par1ArrayOfFloat;
    }

    public float func_76939_a(float par1, int par2) {
        return par1;
    }

    public BiomeGenBase[] func_76937_a(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5) {
        if (par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < par4 * par5) {
            par1ArrayOfBiomeGenBase = new BiomeGenBase[par4 * par5];
        }
        int[] var7 = this.getBiomesGens(par2, par3, par4, par5);
        for (int var8 = 0; var8 < par4 * par5; ++var8) {
            par1ArrayOfBiomeGenBase[var8] = BiomeGenBase.func_150568_d((int)var7[var8]);
        }
        return par1ArrayOfBiomeGenBase;
    }

    public BiomeGenBase[] func_76933_b(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5) {
        return this.func_76931_a(par1ArrayOfBiomeGenBase, par2, par3, par4, par5, true);
    }

    public BiomeGenBase[] func_76931_a(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5, boolean par6) {
        if (par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < par4 * par5) {
            par1ArrayOfBiomeGenBase = new BiomeGenBase[par4 * par5];
        }
        int[] var7 = this.getBiomesGens(par2, par3, par4, par5);
        for (int var8 = 0; var8 < par4 * par5; ++var8) {
            par1ArrayOfBiomeGenBase[var8] = BiomeGenBase.func_150568_d((int)var7[var8]);
        }
        return par1ArrayOfBiomeGenBase;
    }

    public boolean func_76940_a(int x, int y, int par3, List par4List) {
        float centerNoise = this.getNoiseAt(x, y);
        if (centerNoise < 62.0f) {
            return false;
        }
        float lowestNoise = centerNoise;
        float highestNoise = centerNoise;
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (i == 0 || j == 0) continue;
                float n = this.getNoiseAt(x + i * 16, y + j * 16);
                if (n < lowestNoise) {
                    lowestNoise = n;
                }
                if (!(n > highestNoise)) continue;
                highestNoise = n;
            }
        }
        return highestNoise - lowestNoise < 22.0f;
    }

    public ChunkPosition func_150795_a(int p_150795_1_, int p_150795_2_, int p_150795_3_, List p_150795_4_, Random p_150795_5_) {
        return null;
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }
}

