/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenTrees;
import rwg.biomes.base.BaseBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.trees.DecoPalmTree;
import rwg.deco.trees.DecoShrub;
import rwg.util.CellNoise;
import rwg.util.PerlinNoise;

public class RealisticBiomeAtoll
extends RealisticBiomeBase {
    public RealisticBiomeAtoll() {
        super(0, BaseBiomes.baseTropicalIsland);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength) {
        for (int b1 = 0; b1 < 2; ++b1) {
            int i1 = chunkX + rand.nextInt(16) + 8;
            int j1 = chunkY + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1);
            new DecoShrub(rand.nextInt(5) + 4, 0, 0).func_76484_a(world, rand, i1, k1, j1);
        }
        for (int t = 0; t < 3; ++t) {
            int k10;
            int j6 = chunkX + rand.nextInt(16) + 8;
            int z52 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
            if (z52 >= 69) continue;
            WorldGenBigTree worldgenerator = rand.nextInt(6) == 0 ? new WorldGenBigTree(false) : (rand.nextInt(2) == 0 ? new WorldGenTrees(false) : new DecoPalmTree(8 + rand.nextInt(8), false));
            worldgenerator.func_76487_a(1.0, 1.0, 1.0);
            worldgenerator.func_76484_a(world, rand, j6, z52, k10);
        }
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border) {
        float h = perlin.noise2((float)x / 260.0f, (float)y / 260.0f) * 55.0f;
        h = h > 17.0f ? 17.0f - (h - 17.0f) : h;
        h += perlin.noise2((float)x / 35.0f, (float)y / 35.0f) * 5.6f;
        h += perlin.noise2((float)x / 25.0f, (float)y / 25.0f) * 4.3f;
        return 55.0f + (h += perlin.noise2((float)x / 13.0f, (float)y / 13.0f) * 2.8f);
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise) {
        boolean grass = false;
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            if (++depth == 0 && k > 65) {
                grass = true;
            }
            if (grass) {
                if (depth == 0) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                    continue;
                }
                if (depth >= 5) continue;
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                continue;
            }
            if (depth < 3) {
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
                continue;
            }
            if (depth >= 6) continue;
            blocks[(y * 16 + x) * 256 + k] = Blocks.field_150322_A;
        }
    }
}

