/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import rwg.biomes.base.BaseBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.util.CellNoise;
import rwg.util.CliffCalculator;
import rwg.util.PerlinNoise;
import rwg.util.SnowheightCalculator;

public class RealisticBiomeGlacier
extends RealisticBiomeBase {
    public RealisticBiomeGlacier(int sub) {
        super(sub, BaseBiomes.baseSnowDesert);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength) {
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border) {
        if (this.subID == 0) {
            return 65.0f;
        }
        float h = perlin.noise2((float)x / 300.0f, (float)y / 300.0f) * 120.0f;
        if ((h *= h / 32.0f) < 12.0f) {
            h += perlin.noise2((float)x / 50.0f, (float)y / 50.0f) * (12.0f - h) * 0.3f;
        }
        if (h > 2.0f) {
            float d = (h - 2.0f) / 2.0f > 8.0f ? 8.0f : (h - 2.0f) / 2.0f;
            h += perlin.noise2((float)x / 18.0f, (float)y / 18.0f) * d;
            if ((h += perlin.noise2((float)x / 50.0f, (float)y / 50.0f) * d * 0.5f) > 15.0f) {
                float d2 = (h - 15.0f) / 2.0f > 8.0f ? 8.0f : (h - 15.0f) / 2.0f;
                h += perlin.noise2((float)x / 60.0f, (float)y / 60.0f) * d2 * 2.0f;
                h += perlin.noise2((float)x / 12.0f, (float)y / 12.0f) * d2 * 0.5f;
            }
        }
        h = h < 5.0f ? 5.0f : h;
        return 65.0f + h;
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise) {
        float c = CliffCalculator.calc(x, y, noise);
        boolean cliff = c > 1.1f;
        boolean clay = c > 1.6f;
        boolean ice = false;
        if (this.subID == 1) {
            float h = perlin.noise2((float)i / 300.0f, (float)j / 300.0f) * 120.0f;
            if ((h *= h / 32.0f) < 5.0f) {
                ice = true;
            }
        }
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            ++depth;
            if (cliff) {
                if (depth <= -1 || depth >= 6) continue;
                if (clay) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150406_ce;
                    metadata[(y * 16 + x) * 256 + k] = 9;
                    continue;
                }
                if (depth > -1 && depth < 2) {
                    blocks[(y * 16 + x) * 256 + k] = rand.nextInt(3) == 0 ? Blocks.field_150347_e : Blocks.field_150348_b;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150348_b;
                continue;
            }
            if (depth <= -1 || depth >= 9) continue;
            if (ice && k < 70) {
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150403_cj;
                if (depth != 0 || !(perlin.noise2((float)i / 3.0f, (float)j / 3.0f) > 0.0f)) continue;
                blocks[(y * 16 + x) * 256 + k + 1] = Blocks.field_150403_cj;
                continue;
            }
            blocks[(y * 16 + x) * 256 + k] = Blocks.field_150433_aE;
            if (depth != 0 || k <= 61 || k >= 254) continue;
            SnowheightCalculator.calc(x, y, k, blocks, metadata, noise);
            ice = false;
        }
    }
}

