/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenTrees;
import rwg.biomes.base.BaseBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoBlob;
import rwg.deco.DecoCacti;
import rwg.deco.DecoFlowers;
import rwg.deco.DecoGrass;
import rwg.deco.DecoWildWheat;
import rwg.deco.trees.DecoSavannah;
import rwg.util.CellNoise;
import rwg.util.PerlinNoise;

public class RealisticBiomePlainsHot
extends RealisticBiomeBase {
    public RealisticBiomePlainsHot(int sub) {
        super(sub, BaseBiomes.baseHotPlains);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength) {
        int j1;
        int i1;
        int k1;
        if (rand.nextInt((int)(2.0f / strength)) == 0 && (k1 = world.func_72976_f(i1 = chunkX + rand.nextInt(16) + 8, j1 = chunkY + rand.nextInt(16) + 8)) < 85) {
            new DecoBlob(Blocks.field_150347_e, 0).func_76484_a(world, rand, i1, k1, j1);
        }
        if (rand.nextInt((int)(22.0f / strength)) == 0) {
            int j16 = chunkX + rand.nextInt(16) + 8;
            int j18 = rand.nextInt(128);
            int j21 = chunkY + rand.nextInt(16) + 8;
            new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
        }
        if (rand.nextInt((int)(3.0f / strength)) == 0) {
            int i18 = chunkX + rand.nextInt(16) + 8;
            int i23 = chunkY + rand.nextInt(16) + 8;
            new WorldGenReed().func_76484_a(world, rand, i18, 60 + rand.nextInt(8), i23);
        }
        int f23 = 0;
        while ((float)f23 < 3.0f * strength) {
            int j15 = chunkX + rand.nextInt(16) + 8;
            int j17 = rand.nextInt(128);
            int j20 = chunkY + rand.nextInt(16) + 8;
            new DecoFlowers(new int[]{9, 9, 9, 9, 3, 3, 3, 3, 3, 2, 2, 2, 11, 11, 11}).func_76484_a(world, rand, j15, j17, j20);
            ++f23;
        }
        if (rand.nextInt((int)(100.0f / strength)) == 0) {
            int k21 = chunkX + rand.nextInt(16) + 8;
            int j23 = rand.nextInt(60) + 60;
            int k24 = chunkY + rand.nextInt(16) + 8;
            new DecoWildWheat(rand.nextInt(3)).func_76484_a(world, rand, k21, j23, k24);
        }
        if (this.subID == 0) {
            float h = perlin.noise2((float)(chunkX + 8) / 200.0f, (float)(chunkY + 8) / 200.0f) * 20.0f;
            if (h < -4.0f) {
                int b1 = 0;
                while ((float)b1 < 3.0f * strength) {
                    int j6 = chunkX + rand.nextInt(16) + 8;
                    int k10 = chunkY + rand.nextInt(16) + 8;
                    int z52 = world.func_72976_f(j6, k10);
                    Object worldgenerator = rand.nextBoolean() ? new WorldGenShrub(0, 0) : (rand.nextInt(10) == 0 ? new DecoSavannah(1) : (rand.nextInt(10) == 0 ? new WorldGenBigTree(false) : new WorldGenTrees(false)));
                    worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                    ++b1;
                }
            }
            int l14 = 0;
            while ((float)l14 < 7.0f * strength) {
                int l19 = chunkX + rand.nextInt(16) + 8;
                int k22 = 60 + rand.nextInt(40);
                int j24 = chunkY + rand.nextInt(16) + 8;
                if (rand.nextInt(5) == 0) {
                    new DecoGrass((Block)Blocks.field_150398_cm, 2).func_76484_a(world, rand, l19, k22, j24);
                } else {
                    new DecoGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
                }
                ++l14;
            }
            int k18 = 0;
            while ((float)k18 < 4.0f * strength) {
                int k21 = chunkX + rand.nextInt(16) + 8;
                int j23 = rand.nextInt(160);
                int k24 = chunkY + rand.nextInt(16) + 8;
                new DecoCacti(false).func_76484_a(world, rand, k21, j23, k24);
                ++k18;
            }
        } else {
            int k10;
            int j6;
            int z52;
            if (rand.nextInt((int)(30.0f / strength)) == 0 && (z52 = world.func_72976_f(j6 = chunkX + rand.nextInt(16) + 8, k10 = chunkY + rand.nextInt(16) + 8)) < 85) {
                DecoSavannah worldgenerator = new DecoSavannah(1);
                worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                worldgenerator.func_76484_a(world, rand, j6, z52, k10);
            }
            int k18 = 0;
            while ((float)k18 < 36.0f * strength) {
                int k21 = chunkX + rand.nextInt(16) + 8;
                int j23 = rand.nextInt(160);
                int k24 = chunkY + rand.nextInt(16) + 8;
                if (j23 < 90) {
                    new DecoCacti(false).func_76484_a(world, rand, k21, j23, k24);
                }
                ++k18;
            }
            int l14 = 0;
            while ((float)l14 < 8.0f * strength) {
                int l19 = chunkX + rand.nextInt(16) + 8;
                int k22 = 60 + rand.nextInt(40);
                int j24 = chunkY + rand.nextInt(16) + 8;
                if (rand.nextInt(3) == 0) {
                    new DecoGrass((Block)Blocks.field_150398_cm, 2).func_76484_a(world, rand, l19, k22, j24);
                } else {
                    new DecoGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
                }
                ++l14;
            }
        }
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border) {
        if (this.subID == 0) {
            float h = perlin.noise2((float)x / 200.0f, (float)y / 200.0f) * 28.0f;
            h += cell.noise((float)x / 50.0f, (float)y / 50.0f, 1.0) * 15.0f;
            h += perlin.noise2((float)x / 50.0f, (float)y / 50.0f) * 10.0f;
            return 70.0f + (h += perlin.noise2((float)x / 15.0f, (float)y / 15.0f) * 4.0f);
        }
        float h = (perlin.noise2((float)x / 300.0f, (float)y / 300.0f) + 0.25f) * 65.0f;
        h = h < 1.0f ? 1.0f : h;
        float r = cell.noise((double)x / 50.0, (double)y / 50.0, 1.0) * h * 2.0f;
        h += r;
        h += perlin.noise2((float)x / 40.0f, (float)y / 40.0f) * 8.0f;
        return 70.0f + (h += perlin.noise2((float)x / 14.0f, (float)y / 14.0f) * 2.0f);
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise) {
        if (this.subID == 0) {
            float m = perlin.noise2((float)i / 8.0f, (float)j / 8.0f) + perlin.noise2((float)i / 75.0f, (float)j / 75.0f) * 0.8f;
            boolean sand = false;
            for (int k = 255; k > -1; --k) {
                Block b = blocks[(y * 16 + x) * 256 + k];
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth == 0) {
                    if (k < 63) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
                        sand = true;
                        continue;
                    }
                    if (m < -0.3f) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                        metadata[(y * 16 + x) * 256 + k] = 1;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                    continue;
                }
                if (depth >= 6) continue;
                if (sand) {
                    if (depth < 4) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150322_A;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
            }
        } else {
            float h = (perlin.noise2((float)i / 300.0f, (float)j / 300.0f) + 0.25f) * 65.0f;
            h = h < 1.0f ? 1.0f : h;
            float m = perlin.noise2((float)i / 12.0f, (float)j / 12.0f);
            boolean sand = false;
            for (int k = 255; k > -1; --k) {
                Block b = blocks[(y * 16 + x) * 256 + k];
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth == 0) {
                    if ((float)k > 90.0f + perlin.noise2((float)i / 24.0f, (float)j / 24.0f) * 10.0f - h || m < -0.28f) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
                        sand = true;
                        continue;
                    }
                    if (m < 0.22f || k < 62) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                        metadata[(y * 16 + x) * 256 + k] = 1;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                    continue;
                }
                if (depth >= 6) continue;
                if (sand) {
                    if (depth < 4) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150322_A;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
            }
        }
    }
}

