/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenForest;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;
import rwg.biomes.base.BaseBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoFlowers;
import rwg.deco.DecoGrass;
import rwg.deco.DecoLog;
import rwg.deco.DecoWildWheat;
import rwg.deco.trees.DecoLargePine;
import rwg.deco.trees.DecoShrub;
import rwg.deco.trees.DecoSmallPine;
import rwg.util.CellNoise;
import rwg.util.CliffCalculator;
import rwg.util.PerlinNoise;

public class RealisticBiomeRedwood
extends RealisticBiomeBase {
    public RealisticBiomeRedwood(int i) {
        super(i, BaseBiomes.baseRedwood);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength) {
        int z22;
        int x22;
        int y22;
        WorldGenerator worldgenerator;
        int k10;
        int j6;
        int z52;
        float l = perlin.noise2((float)chunkX / 80.0f, (float)chunkY / 80.0f) * 40.0f + 10.0f;
        int b1 = 0;
        while ((float)b1 < l * strength) {
            if (rand.nextInt(10) == 0 && (z52 = world.func_72976_f(j6 = chunkX + rand.nextInt(16) + 8, k10 = chunkY + rand.nextInt(16) + 8)) < 110) {
                worldgenerator = new DecoLargePine((int)(14.0f - (float)(z52 - 70) / 5.0f) + rand.nextInt(8), (int)(15.0f - (float)(z52 - 70) / 5.0f) + rand.nextInt(12));
                worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                worldgenerator.func_76484_a(world, rand, j6, z52, k10);
            }
            ++b1;
        }
        if (l > 5.0f) {
            int b2 = 0;
            while ((float)b2 < 6.0f * strength) {
                j6 = chunkX + rand.nextInt(16) + 8;
                z52 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
                if (z52 < 120) {
                    worldgenerator = rand.nextInt(4) == 0 ? new DecoSmallPine(4 + rand.nextInt(7), 6 + rand.nextInt(9), 0) : (rand.nextInt(6) != 0 ? new WorldGenTrees(false) : new WorldGenForest(false, false));
                    worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                }
                ++b2;
            }
        }
        if (rand.nextInt((int)(4.0f / strength)) == 0 && (y22 = world.func_72976_f(x22 = chunkX + rand.nextInt(16) + 8, z22 = chunkY + rand.nextInt(16) + 8)) < 100) {
            new DecoLog(1, 3 + rand.nextInt(4), false).func_76484_a(world, rand, x22, y22, z22);
        }
        int f24 = 0;
        while ((float)f24 < 3.0f * strength) {
            int j1;
            int i1 = chunkX + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
            if (k1 < 110) {
                new DecoShrub(rand.nextInt(4) + 1, 0, rand.nextInt(3)).func_76484_a(world, rand, i1, k1, j1);
            }
            ++f24;
        }
        if (rand.nextInt((int)(150.0f / strength)) == 0) {
            int k21 = chunkX + rand.nextInt(16) + 8;
            int j23 = rand.nextInt(60) + 60;
            int k24 = chunkY + rand.nextInt(16) + 8;
            new DecoWildWheat(rand.nextInt(3)).func_76484_a(world, rand, k21, j23, k24);
        }
        if (rand.nextInt((int)(15.0f / strength)) == 0) {
            int j16 = chunkX + rand.nextInt(16) + 8;
            int j18 = rand.nextInt(100);
            int j21 = chunkY + rand.nextInt(16) + 8;
            new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
        }
        int f23 = 0;
        while ((float)f23 < 8.0f * strength) {
            int j15 = chunkX + rand.nextInt(16) + 8;
            int j17 = rand.nextInt(128);
            int j20 = chunkY + rand.nextInt(16) + 8;
            new DecoFlowers(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}).func_76484_a(world, rand, j15, j17, j20);
            ++f23;
        }
        int l14 = 0;
        while ((float)l14 < 12.0f * strength) {
            int l19 = chunkX + rand.nextInt(16) + 8;
            int k22 = rand.nextInt(128);
            int j24 = chunkY + rand.nextInt(16) + 8;
            new DecoGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
            ++l14;
        }
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border) {
        float b = 12.0f + perlin.noise2((float)x / 300.0f, (float)y / 300.0f) * 6.0f;
        float h = cell.noise((double)x / 200.0, (double)y / 200.0, 1.0) * b;
        float f = h = (h *= h * 1.5f) > 155.0f ? 155.0f : h;
        if (h > 2.0f) {
            float d = (h - 2.0f) / 2.0f > 8.0f ? 8.0f : (h - 2.0f) / 2.0f;
            h += perlin.noise2((float)x / 30.0f, (float)y / 30.0f) * d;
            if ((h += perlin.noise2((float)x / 50.0f, (float)y / 50.0f) * d * 0.5f) > 35.0f) {
                float d2 = (h - 35.0f) / 1.5f > 30.0f ? 30.0f : (h - 35.0f) / 1.5f;
                h += cell.noise((double)x / 25.0, (double)y / 25.0, 1.0) * d2;
            }
        }
        h += perlin.noise2((float)x / 18.0f, (float)y / 18.0f) * 3.0f;
        return 45.0f + (h += perlin.noise2((float)x / 8.0f, (float)y / 8.0f) * 2.0f) + b * 2.0f;
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise) {
        float p = perlin.noise2((float)i / 8.0f, (float)j / 8.0f) * 0.5f;
        float c = CliffCalculator.calc(x, y, noise);
        int cliff = 0;
        boolean sand = false;
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            if (++depth == 0) {
                if (k < 64) {
                    sand = true;
                }
                if (c > 0.45f && c > 1.5f - ((float)k - 70.0f) / 95.0f + p) {
                    cliff = 1;
                }
                if (c > 1.5f) {
                    cliff = 2;
                }
                if ((float)k > 140.0f + p * 4.0f && c < 0.3f + ((float)k - 140.0f) / 70.0f + p) {
                    cliff = 3;
                }
                if (cliff == 1) {
                    blocks[(y * 16 + x) * 256 + k] = rand.nextInt(3) == 0 ? Blocks.field_150347_e : Blocks.field_150348_b;
                    continue;
                }
                if (cliff == 2) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150406_ce;
                    metadata[(y * 16 + x) * 256 + k] = 9;
                    continue;
                }
                if (cliff == 3) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150433_aE;
                    continue;
                }
                if (perlin.noise2((float)i / 50.0f, (float)j / 50.0f) + p * 0.6f > 0.24f) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                    metadata[(y * 16 + x) * 256 + k] = 2;
                    continue;
                }
                if (k < 64) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
                    sand = true;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                continue;
            }
            if (depth >= 6) continue;
            if (cliff == 1) {
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150348_b;
                continue;
            }
            if (cliff == 2) {
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150406_ce;
                metadata[(y * 16 + x) * 256 + k] = 9;
                continue;
            }
            blocks[(y * 16 + x) * 256 + k] = cliff == 3 ? Blocks.field_150433_aE : (sand ? Blocks.field_150354_m : Blocks.field_150346_d);
        }
    }
}

