/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenDeadBush;
import rwg.biomes.base.BaseBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoBlob;
import rwg.deco.DecoCacti;
import rwg.deco.trees.DecoDeadDesertTrees;
import rwg.deco.trees.DecoShrub;
import rwg.util.CellNoise;
import rwg.util.PerlinNoise;

public class RealisticBiomeRockDesert
extends RealisticBiomeBase {
    public RealisticBiomeRockDesert() {
        super(0, BaseBiomes.baseHotPlains);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength) {
        if (rand.nextInt((int)(1.0f / strength)) == 0) {
            int j6 = chunkX + rand.nextInt(16) + 8;
            int k10 = chunkY + rand.nextInt(16) + 8;
            int z52 = world.func_72976_f(j6, k10);
            DecoDeadDesertTrees worldgenerator = new DecoDeadDesertTrees(rand.nextInt(15) == 0 ? 0 : 1);
            worldgenerator.func_76487_a(1.0, 1.0, 1.0);
            worldgenerator.func_76484_a(world, rand, j6, z52, k10);
        }
        if (rand.nextInt((int)(1.0f / strength)) == 0) {
            int i1 = chunkX + rand.nextInt(16) + 8;
            int j1 = chunkY + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1);
            new DecoShrub(rand.nextInt(4) + 1, 3, 4, true).func_76484_a(world, rand, i1, k1, j1);
        }
        int b2 = 0;
        while ((float)b2 < 2.0f * strength) {
            int i1 = chunkX + rand.nextInt(16) + 8;
            int j1 = chunkY + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1);
            new DecoBlob(Blocks.field_150347_e, rand.nextInt(12) == 0 ? 1 : 0).func_76484_a(world, rand, i1, k1, j1);
            ++b2;
        }
        int k18 = 0;
        while ((float)k18 < 5.0f * strength) {
            int k21 = chunkX + rand.nextInt(16) + 8;
            int k24 = chunkY + rand.nextInt(16) + 8;
            int j23 = world.func_72976_f(k21, k24);
            new DecoCacti(false).func_76484_a(world, rand, k21, j23, k24);
            ++k18;
        }
        int i15 = 0;
        while ((float)i15 < 5.0f * strength) {
            int i17 = chunkX + rand.nextInt(16) + 8;
            int i20 = rand.nextInt(160);
            int l22 = chunkY + rand.nextInt(16) + 8;
            new WorldGenDeadBush((Block)Blocks.field_150330_I).func_76484_a(world, rand, i17, i20, l22);
            ++i15;
        }
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border) {
        return 70.0f + perlin.noise2((float)x / 30.0f, (float)y / 30.0f) * 6.0f + perlin.noise2((float)x / 12.0f, (float)y / 12.0f) * 4.0f;
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise) {
        boolean stone = false;
        boolean dirt = false;
        float p = perlin.noise2((float)i / 50.0f, (float)j / 50.0f) * 0.5f + perlin.noise2((float)i / 8.0f, (float)j / 8.0f) * 0.5f * 0.6f;
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            if (++depth == 0) {
                if (p > 0.1f) {
                    stone = true;
                }
                if (p < -0.1f) {
                    dirt = true;
                }
            }
            if (stone) {
                if (depth != 0) continue;
                blocks[(y * 16 + x) * 256 + k] = rand.nextBoolean() ? Blocks.field_150347_e : Blocks.field_150348_b;
                continue;
            }
            if (dirt) {
                if (depth >= 3) continue;
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                metadata[(y * 16 + x) * 256 + k] = 1;
                continue;
            }
            if (depth < 3) {
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
                continue;
            }
            if (depth >= 5) continue;
            blocks[(y * 16 + x) * 256 + k] = Blocks.field_150322_A;
        }
    }
}

