/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenDeadBush;
import rwg.biomes.base.BaseBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoCacti;
import rwg.util.CellNoise;
import rwg.util.CliffCalculator;
import rwg.util.PerlinNoise;

public class RealisticBiomeSaltLakes
extends RealisticBiomeBase {
    public RealisticBiomeSaltLakes() {
        super(0, BaseBiomes.baseHotDesert);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength) {
        int k18 = 0;
        while ((float)k18 < 5.0f * strength) {
            int k21 = chunkX + rand.nextInt(16) + 8;
            int j23 = rand.nextInt(160);
            int k24 = chunkY + rand.nextInt(16) + 8;
            new DecoCacti(false).func_76484_a(world, rand, k21, j23, k24);
            ++k18;
        }
        int i15 = 0;
        while ((float)i15 < 2.0f * strength) {
            int l22;
            int i17 = chunkX + rand.nextInt(16) + 8;
            int i20 = world.func_72976_f(i17, l22 = chunkY + rand.nextInt(16) + 8);
            if (i20 > 63) {
                new WorldGenDeadBush((Block)Blocks.field_150330_I).func_76484_a(world, rand, i17, i20, l22);
            }
            ++i15;
        }
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border) {
        float st;
        float h = perlin.noise2((float)x / 200.0f, (float)y / 200.0f) * 32.0f;
        if (h > 5.0f) {
            st = ((h = 5.0f + (h - 5.0f) * (4.0f * border)) - 5.0f) * 1.5f > 15.0f ? 15.0f : (h - 5.0f) * 1.5f;
            h += cell.noise((double)x / 70.0, (double)y / 70.0, 1.0) * st;
        }
        if (border < 1.0f) {
            h += (1.0f - border) * 35.0f;
        }
        if (h > -4.0f) {
            st = h + 4.0f > 8.0f ? 8.0f : h + 4.0f;
            h += perlin.noise2((float)x / 50.0f, (float)y / 50.0f) * st;
            h += perlin.noise2((float)x / 20.0f, (float)y / 20.0f) * (st / 2.0f);
            h += perlin.noise2((float)x / 10.0f, (float)y / 10.0f) * (st / 4.0f);
        }
        h = h < -2.0f ? -2.0f : h;
        return 65.0f + h;
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise) {
        float c = CliffCalculator.calc(x, y, noise);
        boolean cliff = false;
        boolean salt = false;
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            if (k < 62 && ++depth < 10) {
                if (depth < 4) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                }
                if (depth < 7) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150322_A;
                continue;
            }
            if (depth >= 10) continue;
            if (depth == 0) {
                float c2 = 1.4f - ((float)k - 60.0f) / 60.0f + perlin.noise2((float)i / 8.0f, (float)j / 8.0f) * 0.5f;
                if (c > c2 && c2 > 0.4f) {
                    cliff = true;
                } else if (k < 63) {
                    salt = true;
                }
            }
            if (cliff && depth < 2) {
                blocks[(y * 16 + x) * 256 + k] = rand.nextInt(3) == 0 ? Blocks.field_150347_e : Blocks.field_150348_b;
                continue;
            }
            if (salt) {
                if (depth < 3) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150406_ce;
                    metadata[(y * 16 + x) * 256 + k] = 0;
                    continue;
                }
                if (depth < 7) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
                    continue;
                }
                if (depth >= 10) continue;
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150322_A;
                continue;
            }
            if (depth < 7) {
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
                continue;
            }
            if (depth >= 10) continue;
            blocks[(y * 16 + x) * 256 + k] = Blocks.field_150322_A;
        }
    }
}

